/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.core.util.ArgCheck;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ResourceProxyHandler
implements InvocationHandler {
    public static final String LOG_CONTEXT = "ResourceProxy";
    private Object delegate;
    private boolean isClosed = false;

    public ResourceProxyHandler(Object delegate) {
        if (delegate == null) {
            ArgCheck.isNotNull((Object)delegate, (String)CommonPlugin.Util.getString("ERR.003.002.0005"));
        }
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setIsClosed(boolean closed) {
        this.isClosed = closed;
    }

    protected Object postProcess(Method method, Object[] args, Object result) {
        return result;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (this.isClosed()) {
            throw new ResourcePoolException("ERR.003.002.0006");
        }
        try {
            result = method.invoke(this.getDelegate(), args);
            this.logCall(this.getDelegate().getClass().getName(), method.getName(), args, result);
            result = this.postProcess(method, args, result);
            return result;
        }
        catch (InvocationTargetException e) {
            this.logException(this.getDelegate().getClass().getName(), method.getName(), args, e.getTargetException());
            throw e;
        }
    }

    protected void logException(String className, String methodName, Object[] args, Throwable t) {
        StringBuffer message = new StringBuffer("");
        message.append(className);
        message.append(".");
        message.append(methodName);
        message.append("(");
        this.appendMethodArgsToLogMessage(message, args);
        message.append(")");
        String msg = message.toString();
        I18nLogManager.logError(LOG_CONTEXT, "ERR.003.002.0007", msg);
    }

    protected void logCall(String className, String methodName, Object[] args, Object result) {
        StringBuffer message = new StringBuffer("Call to method ");
        message.append(className);
        message.append(".");
        message.append(methodName);
        message.append("(");
        this.appendMethodArgsToLogMessage(message, args);
        message.append(")");
        this.appendResultToLogMessage(message, result);
        String msg = message.toString();
        LogManager.logDetail(LOG_CONTEXT, msg);
    }

    protected void appendMethodArgsToLogMessage(StringBuffer message, Object[] args) {
        if (args != null && args.length != 0) {
            message.append(args[0]);
            for (int i = 1; i != args.length; ++i) {
                message.append(",");
                message.append(args[i]);
            }
        }
    }

    protected void appendResultToLogMessage(StringBuffer message, Object result) {
        if (result != null) {
            message.append("=");
            message.append(result);
        }
    }
}

