/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.impl.BasicResourcePool;

class CleanUpThread
extends Thread {
    private BasicResourcePool pool;
    private long sleepTime;
    private boolean continueChecks = true;
    private String poolName;

    CleanUpThread(BasicResourcePool pool, long sleepTime) {
        super("CleanUpThread" + pool.getResourceDescriptor().getName());
        this.pool = pool;
        this.sleepTime = sleepTime;
        this.poolName = pool.getResourceDescriptor().getName();
    }

    public void stopCleanup() {
        this.continueChecks = false;
        this.pool = null;
    }

    public synchronized void setSleepTime(long newSleepTime) {
        this.sleepTime = newSleepTime;
    }

    public void run() {
        while (this.continueChecks) {
            try {
                CleanUpThread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.pool == null) continue;
            LogManager.logTrace("RESOURCE_POOLING", "ResourcePool Clean-up of resource " + this.poolName);
            this.pool.cleanUp();
        }
    }
}

