/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourcePool;
import com.metamatrix.common.pooling.api.ResourcePoolMgr;
import com.metamatrix.common.pooling.api.ResourcePoolStatistics;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.util.PoolingUtil;
import com.metamatrix.common.remote.MMRemoteObject;
import com.metamatrix.common.util.PropertiesUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ResourcePoolMgrImpl
extends MMRemoteObject
implements ResourcePoolMgr {
    private static ResourcePoolMgrImpl instance = null;
    private Map resourcePools;
    private WriterPreferenceReadWriteLock lock;
    private Map idToDescriptorMap;
    private boolean shutdownRequested;
    private static final String CONTEXT = "RESOURCE_POOLING";
    static /* synthetic */ Class class$com$metamatrix$common$pooling$api$ResourcePool;

    public Resource getResource(ResourceDescriptor descriptor, String userName) throws ResourcePoolException, RemoteException {
        return this.getInstance().r1$(descriptor, userName);
    }

    public Collection getAllResourceDescriptorIDs() throws ResourcePoolException, RemoteException {
        return this.getInstance().rd2$();
    }

    public Collection getAllResourceDescriptors() throws ResourcePoolException, RemoteException {
        return this.getInstance().rd1$();
    }

    public ResourceDescriptor getResourceDescriptor(ResourceDescriptorID descriptorID) throws ResourcePoolException, RemoteException {
        return this.getInstance().rd3$(descriptorID);
    }

    public void updateResourcePool(ResourceDescriptorID descriptorID, Properties props) throws ResourcePoolException, RemoteException {
        LogManager.logTrace(CONTEXT, "Updating ResourcePool " + descriptorID.getName());
        ResourcePool rp = this.getResourcePool(descriptorID);
        if (rp != null) {
            rp.update(props);
            LogManager.logDetail(CONTEXT, "Update of ResourcePool " + descriptorID.getName() + " completed.");
        } else {
            LogManager.logTrace(CONTEXT, "Unable to update resource pool, no resource pool found for " + descriptorID.getName());
        }
    }

    public Collection getResourcePoolStatistics() throws ResourcePoolException, RemoteException {
        return this.getInstance().rps1$();
    }

    public ResourcePoolStatistics getResourcePoolStatistics(ResourceDescriptorID descriptorID) throws ResourcePoolException, RemoteException {
        return this.getInstance().rps2$(descriptorID);
    }

    public Collection getResourcesStatisticsForPool(ResourceDescriptorID descriptorID) throws ResourcePoolException, RemoteException {
        return this.getInstance().rsp1$(descriptorID);
    }

    public void shutDown(ResourceDescriptorID descriptorID) throws ResourcePoolException, RemoteException {
        LogManager.logTrace(CONTEXT, "Shutting down ResourcePool " + descriptorID.getName());
        this.getInstance().sd2$(descriptorID);
        LogManager.logDetail(CONTEXT, "Shut down ResourcePool " + descriptorID.getName() + " completed");
    }

    public void shutDown() throws ResourcePoolException, RemoteException {
        LogManager.logTrace(CONTEXT, "Shutting down all ResourcePools");
        this.getInstance().sd1$();
        LogManager.logDetail(CONTEXT, "Shut down all ResourcePools completed");
    }

    public ResourcePool getResourcePool(ResourceDescriptorID descriptorID) throws ResourcePoolException {
        return this.getInstance().rp2$(descriptorID);
    }

    public ResourcePool getResourcePool(ResourceDescriptor descriptor) throws ResourcePoolException {
        return this.getInstance().rp1$(descriptor);
    }

    public Collection getResourcePools() throws ResourcePoolException {
        return this.getInstance().rp4$();
    }

    protected synchronized ResourcePoolMgrImpl getInstance() throws ResourcePoolException {
        if (instance == null) {
            ResourcePoolMgrImpl rpm = new ResourcePoolMgrImpl();
            rpm.init();
            instance = rpm;
        } else if (instance.isBeingShutDown()) {
            throw new ResourcePoolException("ERR.003.002.0036", CommonPlugin.Util.getString("ERR.003.002.0036"));
        }
        return instance;
    }

    protected void init() throws ResourcePoolException {
        this.resourcePools = Collections.synchronizedMap(new HashMap());
        this.idToDescriptorMap = Collections.synchronizedMap(new HashMap());
        this.lock = new WriterPreferenceReadWriteLock();
        this.shutdownRequested = false;
    }

    private boolean isBeingShutDown() {
        return this.shutdownRequested;
    }

    protected void setIsBeingShutDown(boolean shutDown) {
        this.shutdownRequested = shutDown;
    }

    private final Resource r1$(ResourceDescriptor descriptor, String userName) throws ResourcePoolException {
        ResourcePool rp = null;
        LogManager.logTrace(CONTEXT, "Getting resource " + descriptor.getName() + " from pool for user " + userName);
        if (this.resourcePools.isEmpty()) {
            LogManager.logTrace(CONTEXT, "Pool Is Empty");
        }
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.resourcePools.containsKey(descriptor.getID())) {
            LogManager.logTrace(CONTEXT, "Found Resource " + descriptor.getName() + " in pool.");
            Object obj = this.resourcePools.get(descriptor.getID());
            rp = (ResourcePool)obj;
            this.lock.writeLock().release();
        } else {
            ResourceDescriptor cloneDescriptor = null;
            try {
                cloneDescriptor = (ResourceDescriptor)descriptor.clone();
            }
            catch (Throwable t) {
                this.lock.writeLock().release();
                throw new ResourcePoolException(t, "ERR.003.002.0037", CommonPlugin.Util.getString("ERR.003.002.0037"));
            }
            String poolClassName = cloneDescriptor.getProperty("pooling.resource.pool.class.name");
            try {
                rp = (ResourcePool)PoolingUtil.create(poolClassName, null);
                rp.init(cloneDescriptor);
                this.resourcePools.put(cloneDescriptor.getID(), rp);
                this.idToDescriptorMap.put(cloneDescriptor.getID(), cloneDescriptor);
                LogManager.logDetail(CONTEXT, "New ResourcePool " + poolClassName + " created.\n" + PropertiesUtils.prettyPrint(cloneDescriptor.getProperties()));
            }
            catch (ClassCastException e) {
                throw new ResourcePoolException(e, "ERR.003.002.0038", CommonPlugin.Util.getString("ERR.003.002.0038", new Object[]{poolClassName, (class$com$metamatrix$common$pooling$api$ResourcePool == null ? (class$com$metamatrix$common$pooling$api$ResourcePool = ResourcePoolMgrImpl.class$("com.metamatrix.common.pooling.api.ResourcePool")) : class$com$metamatrix$common$pooling$api$ResourcePool).getName()}));
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        return rp.checkOut(userName);
    }

    protected ResourcePool rp1$(ResourceDescriptor descriptor) {
        ResourcePool rp = null;
        if (this.resourcePools.containsKey(descriptor.getID())) {
            Object obj = this.resourcePools.get(descriptor.getID());
            rp = (ResourcePool)obj;
        }
        return rp;
    }

    protected ResourcePool rp2$(ResourceDescriptorID descriptorID) {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ResourcePool rp = null;
        if (this.resourcePools.containsKey(descriptorID)) {
            rp = (ResourcePool)this.resourcePools.get(descriptorID);
        }
        this.lock.readLock().release();
        return rp;
    }

    protected Collection rd2$() throws ResourcePoolException {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ArrayList ids = new ArrayList(this.idToDescriptorMap.size());
        ids.addAll(this.idToDescriptorMap.keySet());
        this.lock.readLock().release();
        return ids;
    }

    protected Collection rd1$() throws ResourcePoolException {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ArrayList ids = new ArrayList(this.idToDescriptorMap.size());
        ids.addAll(this.idToDescriptorMap.values());
        this.lock.readLock().release();
        return ids;
    }

    protected ResourceDescriptor rd3$(ResourceDescriptorID descriptorID) throws ResourcePoolException {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ResourceDescriptor rd = null;
        if (this.idToDescriptorMap.containsKey(descriptorID)) {
            rd = (ResourceDescriptor)this.idToDescriptorMap.get(descriptorID);
        }
        this.lock.readLock().release();
        return rd;
    }

    protected Collection rp4$() {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        Collection pools = this.resourcePools.values();
        this.lock.readLock().release();
        return pools;
    }

    protected Collection rps1$() throws ResourcePoolException {
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ArrayList<ResourcePoolStatistics> stats = new ArrayList<ResourcePoolStatistics>(this.resourcePools.size());
        Iterator it = this.resourcePools.keySet().iterator();
        while (it.hasNext()) {
            ResourceDescriptorID rdID = (ResourceDescriptorID)it.next();
            ResourcePool rp = (ResourcePool)this.resourcePools.get(rdID);
            stats.add(rp.getResourcePoolStatistics());
        }
        this.lock.readLock().release();
        return stats;
    }

    protected ResourcePoolStatistics rps2$(ResourceDescriptorID descriptorID) throws ResourcePoolException {
        ResourcePoolStatistics rps = null;
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ResourcePool rp = null;
        if (this.resourcePools.containsKey(descriptorID)) {
            rp = (ResourcePool)this.resourcePools.get(descriptorID);
            rps = rp.getResourcePoolStatistics();
        }
        this.lock.readLock().release();
        return rps;
    }

    protected Collection rsp1$(ResourceDescriptorID descriptorID) throws ResourcePoolException {
        Collection rsp = null;
        try {
            this.lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ResourcePool rp = null;
        if (this.resourcePools.containsKey(descriptorID)) {
            rp = (ResourcePool)this.resourcePools.get(descriptorID);
            rsp = rp.getPoolResourceStatistics();
        }
        this.lock.readLock().release();
        return rsp;
    }

    protected void sd1$() throws ResourcePoolException {
        this.shutdownRequested = true;
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Iterator it = this.resourcePools.keySet().iterator();
        while (it.hasNext()) {
            ResourceDescriptorID rdID = (ResourceDescriptorID)it.next();
            ResourcePool rp = (ResourcePool)this.resourcePools.get(rdID);
            rp.shutDown();
        }
        this.resourcePools.clear();
        this.idToDescriptorMap.clear();
        this.shutdownRequested = false;
        this.lock.writeLock().release();
    }

    protected void sd2$(ResourceDescriptorID descriptorID) throws ResourcePoolException {
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ResourcePool rp = null;
        if (this.resourcePools.containsKey(descriptorID)) {
            rp = (ResourcePool)this.resourcePools.get(descriptorID);
            rp.shutDown();
            this.resourcePools.remove(descriptorID);
            this.idToDescriptorMap.remove(descriptorID);
        }
        this.lock.writeLock().release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

