/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.queue;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.MonitoredChannel;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPoolStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkerPool {
    private String name;
    private QueueWorkerFactory workerFactory;
    private int maxThreads;
    private long keepAlive;
    private Channel channel;
    private int numThreads;
    private int busyThreads;
    private Map threads = new HashMap();
    private Object threadStateLock = new Object();
    private String threadBaseName;
    private int threadNameCounter = 0;
    private static final int RUNNING = 0;
    private static final int SUSPENDED = 1;
    private static final int STOPPED = 2;
    private Object lifecycleLock = new Object();
    private int state = 0;

    public WorkerPool(String name, QueueWorkerFactory factory, int maxThreads, long keepAlive) {
        this(name, new MonitoredChannel((Channel)new LinkedQueue()), factory, maxThreads, keepAlive);
    }

    public WorkerPool(String name, Channel channel, QueueWorkerFactory factory, int maxThreads, long keepAlive) {
        this.name = name;
        this.workerFactory = factory;
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
        this.channel = channel;
        this.numThreads = 0;
        this.busyThreads = 0;
        this.setThreadBaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWork(Object work) throws QueueSuspendedException {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new QueueSuspendedException("ERR.003.023.0001", CommonPlugin.Util.getString("ERR.003.023.0001"));
            }
            if (this.state == 1) {
                throw new QueueSuspendedException("ERR.003.023.0002", CommonPlugin.Util.getString("ERR.003.023.0002"));
            }
        }
        boolean createThread = false;
        boolean warnLastThread = false;
        Object object2 = this.threadStateLock;
        synchronized (object2) {
            if (this.busyThreads == this.numThreads && this.numThreads < this.maxThreads) {
                createThread = true;
                this.threadAdded();
                this.threadBusy();
                if (this.maxThreads > 1 && this.numThreads == this.maxThreads) {
                    warnLastThread = true;
                }
            }
        }
        if (createThread) {
            QueueWorker thread = this.workerFactory.createWorker();
            String threadName = this.getNewThreadName();
            thread.setPoolState(threadName, this, this.channel, this.keepAlive, work);
            Object object3 = this.threadStateLock;
            synchronized (object3) {
                this.threads.put(threadName, thread);
            }
            thread.start();
            if (LogManager.isMessageToBeRecorded("RESOURCE_POOLING", 6)) {
                LogManager.logTrace("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.New_thread", new Object[]{threadName, this.name}));
            }
            if (warnLastThread) {
                LogManager.logWarning("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.Max_thread", new Object[]{new Integer(this.maxThreads), this.name}));
            }
        } else {
            while (true) {
                try {
                    this.channel.put(work);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadAdded() {
        Object object = this.threadStateLock;
        synchronized (object) {
            ++this.numThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadRemoved(String threadName) {
        Object object = this.threadStateLock;
        synchronized (object) {
            --this.numThreads;
            this.threads.remove(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadBusy() {
        Object object = this.threadStateLock;
        synchronized (object) {
            ++this.busyThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadFree() {
        Object object = this.threadStateLock;
        synchronized (object) {
            --this.busyThreads;
        }
    }

    public boolean hasWork() {
        Object work = this.channel.peek();
        return work != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.state == 0) {
                this.state = 1;
            } else if (this.state == 2) {
                throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.023.0003"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 0;
            } else if (this.state == 2) {
                throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.023.0004"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 1) {
                this.state = 2;
                Object object2 = this.threadStateLock;
                synchronized (object2) {
                    Iterator threadIter = this.threads.values().iterator();
                    while (threadIter.hasNext()) {
                        QueueWorker thread = (QueueWorker)threadIter.next();
                        thread.interruptAndStop();
                    }
                    this.threads.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    public WorkerPoolStats getStats() {
        WorkerPoolStats stats = new WorkerPoolStats();
        stats.name = this.name;
        stats.threads = this.numThreads;
        if (this.channel instanceof MonitoredChannel) {
            ((MonitoredChannel)this.channel).fillStats(stats);
        }
        return stats;
    }

    private void setThreadBaseName() {
        this.threadBaseName = this.name == null ? "Worker_" : this.name + "_Worker_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewThreadName() {
        String string = this.threadBaseName;
        synchronized (string) {
            int threadNum = this.threadNameCounter++;
            return this.threadBaseName + threadNum;
        }
    }

    public String getName() {
        return this.name;
    }
}

