/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.core.util.HashCodeUtil;

public abstract class AbstractTransform
implements Transform {
    public abstract Object transform(Object var1) throws TransformationException;

    protected void checkType(Object value) throws TransformationException {
        if (!this.getSourceType().isInstance(value)) {
            throw new TransformationException("ERR.003.029.0001", CommonPlugin.Util.getString("ERR.003.029.0001", (Object)value.getClass().getName(), (Object)this.getSourceType().getName()));
        }
    }

    public abstract Class getSourceType();

    public String getSourceTypeName() {
        return DataTypeManager.getDataTypeName(this.getSourceType());
    }

    public abstract Class getTargetType();

    public String getTargetTypeName() {
        return DataTypeManager.getDataTypeName(this.getTargetType());
    }

    public String getDisplayName() {
        return this.getSourceTypeName() + " to " + this.getTargetTypeName();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isNarrowing() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.getSourceTypeName().hashCode(), (int)this.getTargetTypeName().hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Transform other = (Transform)obj;
        return other.getSourceType() == this.getSourceType() && other.getTargetType() == this.getTargetType();
    }
}

