/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.exception;

import java.sql.SQLException;

public class SQLExceptionUnroller {
    public static SQLException unRollException(SQLException theException) {
        String SQLState = theException.getSQLState();
        int vendorCode = theException.getErrorCode();
        SQLException outException = new SQLException(theException.getMessage(), SQLState, vendorCode);
        SQLException ei = theException.getNextException();
        SQLException currentException = outException;
        while (ei != null) {
            SQLState = ei.getSQLState();
            vendorCode = ei.getErrorCode();
            currentException.setNextException(new SQLException(ei.getMessage(), SQLState, vendorCode));
            ei = ei.getNextException();
            currentException = currentException.getNextException();
        }
        return outException;
    }

    public static String unRollMsg(SQLException theException) {
        StringBuffer concattedMsg = new StringBuffer(SQLExceptionUnroller.getSQLErrorMsg(theException));
        for (SQLException sqlChild = theException.getNextException(); sqlChild != null; sqlChild = sqlChild.getNextException()) {
            concattedMsg.append(SQLExceptionUnroller.getSQLErrorMsg(sqlChild));
        }
        return concattedMsg.toString();
    }

    private static String getSQLErrorMsg(SQLException e) {
        StringBuffer buf = new StringBuffer("[" + e.getMessage());
        buf.append("|" + e.getSQLState());
        buf.append("|" + e.getErrorCode() + "]");
        return buf.toString();
    }
}

