/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.client.systinet.client;

import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.soap.client.systinet.SOAPPlugin;
import com.metamatrix.soap.client.systinet.client.MessageHandler;
import com.metamatrix.soap.client.systinet.client.MetaMatrixServerAPI;
import com.metamatrix.soap.helper.SOAPAuthentication;
import com.metamatrix.soap.helper.SOAPException;
import com.metamatrix.soap.log.MMSOAPlatformLog;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.handler.Handler;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;

public class MMSOAPClientServlet
extends HttpServlet {
    MetaMatrixServerAPI service = null;
    ServiceClient serviceClient = null;
    public LogListener newListener = null;
    public FileLogWriter logWriter = null;
    MMSOAPlatformLog platformLog = MMSOAPlatformLog.getInstance();
    private static final String ERROR_CONSTANT = "ERROR OCCURRED";
    private static final String MESSAGE = "message";
    static /* synthetic */ Class class$com$metamatrix$soap$client$systinet$client$MetaMatrixServerAPI;

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        String waspLocation = config.getInitParameter("wasp.location");
        if (waspLocation != null) {
            System.setProperty("wasp.location", waspLocation);
        }
        String waspConfigLocation = config.getInitParameter("wasp.config.location");
        if (waspLocation != null) {
            System.setProperty("wasp.config.location", waspConfigLocation);
        }
        String logFile = this.getServletContext().getInitParameter("logfile");
        File log = new File(logFile);
        this.logWriter = new FileLogWriter(log);
        this.platformLog.getPlatformLog().addListener((LogListener)this.logWriter);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        ServletOutputStream out = resp.getOutputStream();
        out.println("<HTML><HEAD><TITLE>MMSoapClient</TITLE></HEAD>");
        out.println("<BODY><H2>Error</H2>");
        out.println("<H3>This test servlet understands the post method only</H3>");
        out.println("</BODY>");
        out.println("</HTML>");
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String logon = req.getParameter("Logon");
        String pass = req.getParameter("Password");
        String sessionID = req.getParameter("SessionID");
        String serverURL = req.getParameter("ServerURL");
        String soapURL = req.getParameter("SOAPURL");
        String soapServiceURN = req.getParameter("SOAPServiceURN");
        String vdbName = req.getParameter("VDBName");
        String vdbVersion = req.getParameter("VDBVersion");
        String fetchSize = req.getParameter("FetchSize");
        String fullMetadata = req.getParameter("FullMetadata");
        String partialResults = req.getParameter("PartialResults");
        String timeout = req.getParameter("TimeOut");
        this.serviceClient = ServiceClient.create((String)soapURL);
        this.serviceClient.getHandlers().insert((Handler)new MessageHandler());
        try {
            this.service = (MetaMatrixServerAPI)this.serviceClient.createProxy(class$com$metamatrix$soap$client$systinet$client$MetaMatrixServerAPI == null ? (class$com$metamatrix$soap$client$systinet$client$MetaMatrixServerAPI = MMSOAPClientServlet.class$("com.metamatrix.soap.client.systinet.client.MetaMatrixServerAPI")) : class$com$metamatrix$soap$client$systinet$client$MetaMatrixServerAPI);
        }
        catch (LookupException err) {
            err.printStackTrace();
        }
        String sdebug = this.convertCheckbox(req.getParameter("Debug"));
        boolean debug = false;
        if (sdebug != null && sdebug.length() > 0) {
            if (sdebug.equalsIgnoreCase("debug")) {
                debug = true;
            } else if (sdebug.equalsIgnoreCase("true")) {
                debug = true;
            }
        }
        if (logon != null && logon.length() == 0) {
            logon = null;
            pass = null;
        }
        if (sessionID != null && sessionID.length() == 0) {
            sessionID = null;
        }
        String executeQuery = req.getParameter("executeQuery");
        String executeUpdate = req.getParameter("executeUpdate");
        String executeStoredProcedure = req.getParameter("executeStoredProcedure");
        String executeMetadata = req.getParameter("executeMetadata");
        String executeLogon = req.getParameter("executeLogon");
        String executeLogoff = req.getParameter("executeLogoff");
        if (debug) {
            Map map = req.getParameterMap();
            Iterator iter = map.keySet().iterator();
            MMSOAPlatformLog.getInstance().getLogFile().log(1, "----------PARAMETERS PASSED IN---------------------------------");
            while (iter.hasNext()) {
                Object key = iter.next();
                String val = req.getParameter((String)key);
                MMSOAPlatformLog.getInstance().getLogFile().log(1, key + "=" + val);
            }
            MMSOAPlatformLog.getInstance().getLogFile().log(1, "------------------------------------------------------------------------------------");
        }
        String results = null;
        try {
            String sql;
            if (executeQuery != null && executeQuery.length() > 0) {
                sql = req.getParameter("SQL");
                MMSOAPClientServlet.checkFormValue(sql, "SQL");
                results = this.executeQuery(sessionID, vdbName, vdbVersion, logon, pass, "false", serverURL, fetchSize, timeout, partialResults, fullMetadata, sql, soapServiceURN, soapURL);
            }
            if (executeUpdate != null && executeUpdate.length() > 0) {
                sql = req.getParameter("SQL");
                MMSOAPClientServlet.checkFormValue(sql, "SQL");
                results = this.executeUpdate(sessionID, vdbName, vdbVersion, logon, pass, "false", serverURL, sql, soapServiceURN, soapURL);
            }
            if (executeMetadata != null && executeMetadata.length() > 0) {
                HashMap<String, String> metadataFilterMap = new HashMap<String, String>();
                String metadataMethod = null;
                Enumeration en = req.getParameterNames();
                while (en.hasMoreElements()) {
                    String value;
                    String name = (String)en.nextElement();
                    if (name.startsWith("METADATA_") && (value = req.getParameter(name)) != null) {
                        if (value != null && value.length() == 0) {
                            value = null;
                        }
                        metadataFilterMap.put(name, value);
                    }
                    if (!name.startsWith("rdo_metadata") || (value = req.getParameter(name)) == null) continue;
                    metadataMethod = value;
                }
                results = this.executeGetMetadata(sessionID, vdbName, vdbVersion, logon, pass, "false", serverURL, soapServiceURN, soapURL, metadataMethod, fullMetadata, metadataFilterMap);
            }
            if (executeStoredProcedure != null && executeStoredProcedure.length() > 0) {
                String storedProcedureName = req.getParameter("sp_sp_procedure_name_key");
                Map parameterMap = this.getStoredProcedureParameters(req);
                results = this.executeStoredProcedure(sessionID, vdbName, vdbVersion, logon, pass, "false", serverURL, timeout, fullMetadata, storedProcedureName, soapServiceURN, soapURL, parameterMap);
            }
            if (executeLogon != null && executeLogon.length() > 0) {
                results = this.executeLogon(sessionID, vdbName, vdbVersion, logon, pass, "false", serverURL, soapServiceURN, soapURL);
            }
            if (executeLogoff != null && executeLogoff.length() > 0) {
                results = this.executeLogoff(sessionID, soapServiceURN, soapURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            results = e.getMessage();
        }
        ServletOutputStream out = resp.getOutputStream();
        if (results.indexOf("Logon Successful") < 0) {
            resp.setContentType("text/xml");
            out.print(results);
        } else {
            resp.setContentType("text/html");
            out.print("<html><body>");
            out.print(results);
            out.print("</body></html>");
        }
        out.flush();
        out.close();
    }

    private String convertCheckbox(String name) {
        String result = "false";
        if (name != null && name.length() > 0) {
            result = "true";
        }
        return result;
    }

    private String executeQuery(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL, String fetchSize, String timeout, String partialResults, String fullMetadata, String sql, String urn, String soapURL) throws Exception {
        SOAPAuthentication authElement = this.getAuthentication(sessionID, vdb, vdbVersion, user, pass, encrypt, serverURL);
        int i_fetchSize = new Integer(fetchSize);
        int i_timeOut = new Integer(timeout);
        boolean b_partialResults = new Boolean(partialResults);
        boolean b_fullMetadata = new Boolean(fullMetadata);
        try {
            this.service.submitQuery(authElement, i_fetchSize, i_timeOut, b_partialResults, b_fullMetadata, sql);
        }
        catch (SOAPException err) {
            return this.printSOAPPart(this.getSOAPPart());
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private String executeUpdate(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL, String sql, String urn, String soapURL) throws Exception {
        SOAPAuthentication authElement = this.getAuthentication(sessionID, vdb, vdbVersion, user, pass, encrypt, serverURL);
        try {
            this.service.submitUpdate(authElement, sql);
        }
        catch (SOAPException err) {
            return this.printSOAPPart(this.getSOAPPart());
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private String executeGetMetadata(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL, String urn, String soapURL, String metadataType, String fullMetadataString, HashMap metadataFilterMap) throws Exception {
        block41: {
            SOAPAuthentication authElement = this.getAuthentication(sessionID, vdb, vdbVersion, user, pass, encrypt, serverURL);
            boolean fullMetadata = new Boolean(fullMetadataString);
            try {
                if (metadataType.equalsIgnoreCase("crossreferences")) {
                    try {
                        this.service.getCrossReferences(authElement, (String)metadataFilterMap.get("METADATA_cr_primarygroupname"), (String)metadataFilterMap.get("METADATA_cr_foreigngroupname"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("datatypes")) {
                    try {
                        this.service.getDataTypes(authElement, fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("elements")) {
                    try {
                        this.service.getElements(authElement, (String)metadataFilterMap.get("METADATA_e_elementpattern"), (String)metadataFilterMap.get("METADATA_e_grouppattern"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("exportedkeys")) {
                    try {
                        this.service.getExportedKeys(authElement, (String)metadataFilterMap.get("METADATA_ek_primarygroupname"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("foreignkeys")) {
                    try {
                        this.service.getForeignKeys(authElement, (String)metadataFilterMap.get("METADATA_fk_groupname"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("groups")) {
                    try {
                        this.service.getGroups(authElement, (String)metadataFilterMap.get("METADATA_g_grouppattern"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("importedkeys")) {
                    try {
                        this.service.getModels(authElement, fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("models")) {
                    try {
                        this.service.getModels(authElement, fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("primarykeys")) {
                    try {
                        this.service.getPrimaryKeys(authElement, (String)metadataFilterMap.get("METADATA_p_procedurepattern"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("procedureparameters")) {
                    try {
                        this.service.getProcedureParameters(authElement, (String)metadataFilterMap.get("METADATA_p_procedurepattern"), (String)metadataFilterMap.get("METADATA_p_procedurepattern"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("procedures")) {
                    try {
                        this.service.getProcedures(authElement, (String)metadataFilterMap.get("METADATA_p_procedurepattern"), fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("userdefineddatatypes")) {
                    try {
                        this.service.getUserDefinedDataTypes(authElement, fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                if (metadataType.equalsIgnoreCase("virtualdatabases")) {
                    try {
                        this.service.getVirtualDatabases(authElement, fullMetadata);
                        break block41;
                    }
                    catch (SOAPException err) {
                        return this.printSOAPPart(this.getSOAPPart());
                    }
                }
                throw new SOAPException("Client.QueryExecution: " + SOAPPlugin.Util.getString("ERR.018.002.0001", (Object)metadataType));
            }
            catch (Exception e) {
                MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, SOAPPlugin.Util.getString("ERR.018.011.0022"));
                Object[] params = new Object[]{e};
                String msg = SOAPPlugin.Util.getString("ERR.018.011.0022", params);
                throw new SOAPException("Server.QueryExecution" + msg);
            }
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private String executeLogon(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL, String urn, String soapURL) throws Exception {
        SOAPAuthentication authElement = this.getAuthentication(sessionID, vdb, vdbVersion, user, pass, encrypt, serverURL);
        try {
            this.service.logon(authElement);
        }
        catch (SOAPException err) {
            return this.printSOAPPart(this.getSOAPPart());
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private String executeLogoff(String sessionID, String urn, String soapURL) throws Exception {
        try {
            this.service.logoff(sessionID);
        }
        catch (SOAPException err) {
            return this.printSOAPPart(this.getSOAPPart());
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private String executeStoredProcedure(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL, String timeout, String fullMetadata, String storedProcedureName, String urn, String soapURL, Map storedProcedureParameters) throws Exception {
        SOAPAuthentication auth = this.getAuthentication(sessionID, vdb, vdbVersion, user, pass, encrypt, serverURL);
        int i_timeOut = new Integer(timeout);
        boolean b_fullMetadata = new Boolean(fullMetadata);
        Object[] sqParams = new Object[storedProcedureParameters.size()];
        for (int i = 1; i < storedProcedureParameters.size() + 1; ++i) {
            Integer index = new Integer(i);
            sqParams[i - 1] = storedProcedureParameters.get(index);
        }
        try {
            this.service.submitStoredProcedure(auth, storedProcedureName, sqParams, i_timeOut, b_fullMetadata);
        }
        catch (SOAPException err) {
            return this.printSOAPPart(this.getSOAPPart());
        }
        return this.printSOAPPart(this.getSOAPPart());
    }

    private Map getStoredProcedureParameters(HttpServletRequest request) throws ServletException {
        return this.getStoredXXXXParameters("sp_", "sp_sp_procedure_param_value_key", ".", request);
    }

    private Map getStoredXXXXParameters(String prepend, String paramValueKey, String seperatorString, HttpServletRequest req) throws ServletException {
        HashMap<Integer, String> mapOfParameters = new HashMap<Integer, String>();
        Enumeration enumOfParameterNames = req.getParameterNames();
        while (enumOfParameterNames.hasMoreElements()) {
            String name = (String)enumOfParameterNames.nextElement();
            if (!name.startsWith(prepend) || name.indexOf(paramValueKey) < 0) continue;
            String currentIndex = name.substring(name.indexOf(seperatorString) + 1, name.length());
            Integer index = null;
            try {
                index = new Integer(currentIndex);
            }
            catch (NumberFormatException nfe) {
                throw new ServletException(SOAPPlugin.Util.getString("ERR.018.002.0002", (Object)currentIndex, (Object)nfe.getMessage()));
            }
            String currentValue = req.getParameter(paramValueKey + seperatorString + currentIndex);
            if (currentValue == null || currentValue.length() <= 0) continue;
            if (currentValue.equalsIgnoreCase("NULL")) {
                mapOfParameters.put(index, null);
                continue;
            }
            mapOfParameters.put(index, currentValue);
        }
        return mapOfParameters;
    }

    private SOAPAuthentication getAuthentication(String sessionID, String vdb, String vdbVersion, String user, String pass, String encrypt, String serverURL) {
        if (sessionID == null && (user == null || pass == null)) {
            return null;
        }
        SOAPAuthentication auth = null;
        if (sessionID != null) {
            auth = new SOAPAuthentication();
            auth.setSessionID(sessionID);
        } else {
            auth = new SOAPAuthentication();
            auth.setUserName(user);
            auth.setPassword(pass);
            auth.setServerURL(serverURL);
            auth.setVDB(vdbVersion);
            auth.setVdbVersion(vdbVersion);
            auth.setIsEncrypted(encrypt);
            auth.setTrustedString("false");
        }
        return auth;
    }

    private String printSOAPPart(Object obj) {
        StringBuffer soapPart = new StringBuffer();
        if (obj instanceof StringBuffer) {
            soapPart.append("<br>");
            soapPart.append(ERROR_CONSTANT);
            soapPart.append("<br>");
            soapPart.append(obj.toString());
        } else {
            soapPart.append(obj);
        }
        return soapPart.toString();
    }

    private String getSOAPPart() {
        StringBuffer soapPart = new StringBuffer();
        try {
            CallContext ctx = this.serviceClient.getCallContext();
            Map ctxData = ctx.getContextData();
            soapPart.append(ctxData.get(MESSAGE));
        }
        catch (Exception err) {
            err.printStackTrace();
            return err.getMessage();
        }
        return soapPart.toString();
    }

    private static void checkFormValue(String parameter, String expectedParameterName) throws Exception {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", (Object)expectedParameterName));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

