/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.license;

import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.license.exception.UnlicensedProductException;
import com.metamatrix.license.exception.UnverifiedLicenseException;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.log.MMSOAPlatformLog;

public class LicenseInfo {
    private static final LicenseInfo INSTANCE = new LicenseInfo();
    private static final String PRODUCT = "Integration API/SOAP";
    private static final String VERSION = "5.0";
    private static String errorMessage;
    private static boolean SOAPAPILicensed;
    static /* synthetic */ Class class$com$metamatrix$soap$license$LicenseInfo;

    private LicenseInfo() {
    }

    public static final void checkSOAPAPILicense() {
        boolean isLicensed = false;
        try {
            LicenseChecker.loadLicense((ClassLoader)(class$com$metamatrix$soap$license$LicenseInfo == null ? (class$com$metamatrix$soap$license$LicenseInfo = LicenseInfo.class$("com.metamatrix.soap.license.LicenseInfo")) : class$com$metamatrix$soap$license$LicenseInfo).getClassLoader());
            LicenseChecker.checkProductLicense((String)PRODUCT, (String)VERSION, (boolean)false);
            isLicensed = true;
        }
        catch (UnverifiedLicenseException err) {
            Object[] params = new Object[]{err};
            String msg = SOAPPlugin.Util.getString("LicenseInfo.UnverifiedLicenseException", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, msg);
            errorMessage = err.getMessage();
        }
        catch (UnlicensedProductException err) {
            Object[] params = new Object[]{err};
            String msg = SOAPPlugin.Util.getString("LicenseInfo.UnlicensedProductException", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, msg);
            errorMessage = err.getMessage();
        }
        catch (InvalidLicenseException err) {
            Object[] params = new Object[]{err};
            String msg = SOAPPlugin.Util.getString("LicenseInfo.InvalidLicenseException", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, msg);
            errorMessage = err.getMessage();
        }
        catch (LicenseVerificationException err) {
            Object[] params = new Object[]{err};
            String msg = SOAPPlugin.Util.getString("LicenseInfo.LicenseVerificationException", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, msg);
            errorMessage = err.getMessage();
        }
        LicenseInfo.setSOAPAPILicensed(isLicensed);
    }

    public static String getPRODUCT() {
        return PRODUCT;
    }

    public static String getVERSION() {
        return VERSION;
    }

    public boolean isSOAPAPILicensed() {
        return SOAPAPILicensed;
    }

    public static void setSOAPAPILicensed(boolean licensed) {
        SOAPAPILicensed = licensed;
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static LicenseInfo getInstance() {
        return INSTANCE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SOAPAPILicensed = true;
        LicenseInfo.checkSOAPAPILicense();
    }
}

