/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.helper.SOAPConfiguration;
import com.metamatrix.soap.helper.SOAPConnection;
import com.metamatrix.soap.helper.SOAPException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class MMSoapConnectionController {
    private HashMap soapConnectionCache;
    private HashMap anonymousConnectionPool;
    private int anonymousConnectionsInUse;
    private int maxAnonymousUsers;
    private int timeToLive;
    String testQuery;
    private static Object soapConnectionCache_Lock = new Object();
    private static Object anonymousConnectionPool_Lock = new Object();
    private static MMSoapConnectionController instance;

    private MMSoapConnectionController() throws SOAPException {
        SOAPConfiguration config = new SOAPConfiguration();
        this.soapConnectionCache = new HashMap();
        this.anonymousConnectionPool = new HashMap();
        this.anonymousConnectionsInUse = 0;
        this.maxAnonymousUsers = config.getMaxUsers();
        this.timeToLive = config.getTimeOut() * 1000;
        this.testQuery = config.getTestQuery();
        long secondsBetweenRuns = config.getCleanDelay();
        new MMSOAPConnectionDaemon(this, secondsBetweenRuns, secondsBetweenRuns);
    }

    public static synchronized MMSoapConnectionController instance() throws SOAPException {
        if (null == instance) {
            instance = new MMSoapConnectionController();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessTime(String sessionID) {
        Object object = soapConnectionCache_Lock;
        synchronized (object) {
            SOAPConnection connection = (SOAPConnection)this.soapConnectionCache.get(sessionID);
            if (connection != null) {
                connection.updateAccessTime();
                this.soapConnectionCache.put(sessionID, connection);
            }
        }
    }

    public void logoff(String sessionID) throws SQLException {
        this.removeSOAPConnection(sessionID);
    }

    public void logon(SOAPConnection connection) {
        this.setSOAPConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPConnection acquireSOAPConnection(String sessionID) throws SQLException {
        SOAPConnection connection = null;
        Object object = soapConnectionCache_Lock;
        synchronized (object) {
            connection = (SOAPConnection)this.soapConnectionCache.get(sessionID);
            if (connection != null) {
                if (!connection.getConnection().isClosed() && this.isAlive(connection.getConnection())) {
                    connection.updateAccessTime();
                    this.soapConnectionCache.put(sessionID, connection);
                } else {
                    this.soapConnectionCache.remove(sessionID);
                    return null;
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPConnection acquireAnonymousConnection() throws SQLException, SOAPException {
        SOAPConnection connection = null;
        if (this.anonymousConnectionsInUse >= this.maxAnonymousUsers) {
            throw new SOAPException("Client.Authentication: " + SOAPPlugin.Util.getString("ERR.018.001.0004"));
        }
        ArrayList<String> listToRemove = new ArrayList<String>();
        Object object = anonymousConnectionPool_Lock;
        synchronized (object) {
            if (this.anonymousConnectionPool.size() == 0) {
                return null;
            }
            String sessionID = (String)this.anonymousConnectionPool.keySet().iterator().next();
            connection = (SOAPConnection)this.anonymousConnectionPool.remove(sessionID);
            boolean gotConnection = false;
            if (connection != null) {
                if (connection.getConnection().isClosed() || !this.isAlive(connection.getConnection())) {
                    Iterator<Object> iter = this.anonymousConnectionPool.keySet().iterator();
                    while (iter.hasNext() && !gotConnection) {
                        sessionID = (String)iter.next();
                        connection = (SOAPConnection)this.anonymousConnectionPool.get(sessionID);
                        listToRemove.add(sessionID);
                        if (connection.getConnection().isClosed() || !this.isAlive(connection.getConnection())) continue;
                        gotConnection = true;
                    }
                    iter = listToRemove.iterator();
                    while (iter.hasNext()) {
                        sessionID = (String)iter.next();
                        this.anonymousConnectionPool.remove(sessionID);
                    }
                } else {
                    gotConnection = true;
                }
            }
            if (!gotConnection) {
                return null;
            }
            ++this.anonymousConnectionsInUse;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPConnection acquireNewAnonymousConnection(Connection connection) throws SOAPException {
        SOAPConnection soapConnection = new SOAPConnection(connection, true);
        Object object = anonymousConnectionPool_Lock;
        synchronized (object) {
            ++this.anonymousConnectionsInUse;
        }
        return soapConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAnonymousConnection(SOAPConnection connection, boolean badConnection) {
        connection.updateAccessTime();
        Object object = anonymousConnectionPool_Lock;
        synchronized (object) {
            if (!badConnection) {
                this.anonymousConnectionPool.put(connection.getSessionID(), connection);
                --this.anonymousConnectionsInUse;
            } else {
                this.anonymousConnectionPool.clear();
                this.anonymousConnectionsInUse = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSOAPConnection(SOAPConnection connection) {
        Object object = soapConnectionCache_Lock;
        synchronized (object) {
            this.soapConnectionCache.put(connection.getSessionID(), connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnonymousSOAPConnection(SOAPConnection connection) {
        Object object = anonymousConnectionPool_Lock;
        synchronized (object) {
            this.anonymousConnectionPool.put(connection.getSessionID(), connection);
            ++this.anonymousConnectionsInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSOAPConnection(String sessionID) throws SQLException {
        SOAPConnection connection = null;
        Object object = soapConnectionCache_Lock;
        synchronized (object) {
            connection = (SOAPConnection)this.soapConnectionCache.remove(sessionID);
        }
        if (connection != null) {
            connection.logoff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupPool() throws SQLException {
        Object connection;
        String sessionID;
        SOAPConnection connection2;
        long currentTime = System.currentTimeMillis();
        ArrayList<String> listToRemove = new ArrayList<String>();
        ArrayList<SOAPConnection> connectionList = new ArrayList<SOAPConnection>();
        Object object = soapConnectionCache_Lock;
        synchronized (object) {
            Iterator iter = this.soapConnectionCache.values().iterator();
            while (iter.hasNext()) {
                connection2 = (SOAPConnection)iter.next();
                Long accessTime = connection2.getLastAccessTime();
                long totalTime = accessTime + (long)this.timeToLive;
                if (totalTime >= currentTime && !connection2.getConnection().isClosed()) continue;
                listToRemove.add(connection2.getSessionID());
            }
            Iterator removeIter = listToRemove.iterator();
            while (removeIter.hasNext()) {
                sessionID = (String)removeIter.next();
                SOAPConnection connection3 = (SOAPConnection)this.soapConnectionCache.remove(sessionID);
                connectionList.add(connection3);
            }
        }
        Iterator connIter = connectionList.iterator();
        while (connIter.hasNext()) {
            connection = (SOAPConnection)connIter.next();
            if (connection == null) continue;
            try {
                if (!this.isAlive(((SOAPConnection)connection).getConnection())) continue;
                ((SOAPConnection)connection).logoff();
            }
            catch (Throwable t) {
                SOAPPlugin.Util.log(2, t, SOAPPlugin.Util.getString("MMSoapConnectionController.Error_in_controller_cleaning_thread_2"));
            }
        }
        listToRemove = new ArrayList();
        connectionList = new ArrayList();
        connection = anonymousConnectionPool_Lock;
        synchronized (connection) {
            Iterator iter = this.anonymousConnectionPool.values().iterator();
            while (iter.hasNext()) {
                SOAPConnection connection4 = (SOAPConnection)iter.next();
                Long accessTime = connection4.getLastAccessTime();
                long totalTime = accessTime + (long)this.timeToLive;
                if (totalTime >= currentTime && !connection4.getConnection().isClosed()) continue;
                listToRemove.add(connection4.getSessionID());
            }
            connIter = listToRemove.iterator();
            while (connIter.hasNext()) {
                sessionID = (String)connIter.next();
                SOAPConnection connection5 = (SOAPConnection)this.anonymousConnectionPool.remove(sessionID);
                connectionList.add(connection5);
            }
        }
        Iterator anonIter = connectionList.iterator();
        while (anonIter.hasNext()) {
            connection2 = (SOAPConnection)anonIter.next();
            if (connection2 == null) continue;
            try {
                if (!this.isAlive(connection2.getConnection())) continue;
                connection2.logoff();
            }
            catch (Throwable t) {
                SOAPPlugin.Util.log(2, t, SOAPPlugin.Util.getString("MMSoapConnectionController.Error_in_controller_cleaning_thread_2"));
            }
        }
    }

    public boolean isAlive(Connection connection) {
        if (this.testQuery != null && this.testQuery.length() != 0) {
            return this.testQuery(connection, this.testQuery);
        }
        return true;
    }

    public boolean testQuery(Connection connection, String query) {
        if (query != null && query.length() != 0) {
            try {
                Statement statement = connection.createStatement();
                if (null == statement) {
                    return false;
                }
                statement.setQueryTimeout(60);
                statement.executeQuery(query);
                statement.close();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static final class MMSOAPConnectionDaemon {
        private Timer timer = new Timer(true);

        public MMSOAPConnectionDaemon(MMSoapConnectionController controller, long initialDelay, long secondsBetweenRuns) {
            this.timer.schedule((TimerTask)new MMSOAPConnectionTask(controller), initialDelay * 1000L, secondsBetweenRuns * 1000L);
        }

        private static final class MMSOAPConnectionTask
        extends TimerTask {
            private MMSoapConnectionController controller;

            public MMSOAPConnectionTask(MMSoapConnectionController controller) {
                this.controller = controller;
            }

            public void run() {
                try {
                    this.controller.cleanupPool();
                }
                catch (Exception e) {
                    SOAPPlugin.Util.log(2, (Throwable)e, SOAPPlugin.Util.getString("MMSoapConnectionController.Error_in_controller_cleaning_thread_2"));
                }
            }
        }
    }
}

