/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.util;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.util.XMLTranslationException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTranslator {
    private Document document;

    public Element translateResultDocuments(ResultSet documents) throws SQLException, XMLTranslationException {
        Element resultsElement = this.getNewElement("xmlresults");
        try {
            while (documents.next()) {
                Element documentElement = this.getNewElement("xmldoc");
                String documentString = documents.getString(1);
                documentString = documentString.substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length());
                Node documentNode = this.getNewTextNode("xmldoc");
                documentNode.setNodeValue(documentString);
                documentElement.appendChild(documentNode);
                resultsElement.appendChild(documentElement);
            }
        }
        catch (Exception e) {
            throw new XMLTranslationException(e, "ERR.018.011.0009", SOAPPlugin.Util.getString("ERR.018.011.0009"));
        }
        resultsElement = this.addWarningsAndExceptions(resultsElement, documents);
        return resultsElement;
    }

    public Element translateXMLSchema(String schema, boolean isPrimary) throws XMLTranslationException {
        if (schema == null) {
            throw new XMLTranslationException("ERR.018.011.0010", SOAPPlugin.Util.getString("ERR.018.011.0010"));
        }
        Element schemaElement = this.getNewElement("xmlschema");
        Node xmlNode = this.getNewTextNode("xmlschema");
        xmlNode.setNodeValue(schema);
        schemaElement.setAttribute("isprimary", "" + isPrimary);
        schemaElement.appendChild(xmlNode);
        return schemaElement;
    }

    public Element translateXMLSchemas(Element root, Collection schemas) throws XMLTranslationException {
        if (root == null) {
            root = this.getNewElement("xmlschema");
        }
        if (schemas == null) {
            Element schemaElement = this.translateXMLSchema(SOAPPlugin.Util.getString("ERR.018.011.0011"), true);
            root.appendChild(schemaElement);
        } else {
            Iterator iter = schemas.iterator();
            boolean isPrimary = true;
            while (iter.hasNext()) {
                String schema = (String)iter.next();
                Element schemaElement = this.translateXMLSchema(schema, isPrimary);
                root.appendChild(schemaElement);
                isPrimary = false;
            }
        }
        return root;
    }

    public Map translateStoredProcedureParameters(Element parameters) throws XMLTranslationException {
        HashMap<Integer, String> parameterMap = new HashMap<Integer, String>();
        NodeList list = parameters.getChildNodes();
        int numberOfParameters = list.getLength();
        Integer index = null;
        String value = null;
        for (int itemIndex = 0; itemIndex < numberOfParameters; ++itemIndex) {
            Node parameterNode = list.item(itemIndex);
            NamedNodeMap attributes = parameterNode.getAttributes();
            Node indexAttribute = attributes.getNamedItem("index");
            if (indexAttribute != null) {
                String indexString = indexAttribute.getNodeValue();
                try {
                    index = new Integer(indexString);
                }
                catch (NumberFormatException nfe) {
                    throw new XMLTranslationException(nfe, "ERR.018.011.0012", SOAPPlugin.Util.getString("ERR.018.011.0012", (Object)indexString));
                }
            } else {
                throw new XMLTranslationException("ERR.018.011.0013", SOAPPlugin.Util.getString("ERR.018.011.0013"));
            }
            Node valueNode = parameterNode.getFirstChild();
            if (valueNode != null) {
                value = valueNode.getNodeValue();
            }
            parameterMap.put(index, value);
        }
        return parameterMap;
    }

    public Element translateParameters(Map parameters) throws XMLTranslationException {
        if (parameters == null) {
            parameters = new HashMap();
        }
        Element parametersElement = this.getNewElement("parameters");
        try {
            Iterator iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                Integer index = (Integer)iter.next();
                Object value = parameters.get(index);
                Element parameter = this.constructParameterElement(index, value);
                parametersElement.appendChild(parameter);
            }
        }
        catch (Exception e) {
            throw new XMLTranslationException(e, "ERR.018.011.0014", SOAPPlugin.Util.getString("ERR.018.011.0014", (Object)e.getMessage()));
        }
        return parametersElement;
    }

    public Element createMetadataParameter(String parameterName, String filter) throws XMLTranslationException {
        if (parameterName == null) {
            throw new XMLTranslationException("ERR.018.011.0015", SOAPPlugin.Util.getString("ERR.018.011.0015"));
        }
        Element parametersElement = this.getNewElement("metadataparameter");
        parametersElement.setAttribute("name", parameterName);
        Node valueNode = this.getNewTextNode("metadataparameter");
        if (filter == null) {
            filter = new String();
        }
        valueNode.setNodeValue(filter);
        parametersElement.appendChild(valueNode);
        return parametersElement;
    }

    public Element getMetadataParameterElement(Element rootElement, String parameterName) throws XMLTranslationException {
        NodeList list = rootElement.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            String attributeValue;
            Node nodeToCheck = list.item(i);
            if (nodeToCheck.getNodeType() != 1 || !parameterName.equalsIgnoreCase(attributeValue = ((Element)nodeToCheck).getAttribute("name"))) continue;
            return (Element)nodeToCheck;
        }
        return rootElement;
    }

    public String getMetadataParameterName(Element metadataParameterElement) throws XMLTranslationException {
        return metadataParameterElement.getAttribute("name");
    }

    public String getMetadataParameterValue(Element metadataParameterElement) throws XMLTranslationException {
        String value = null;
        Node textNode = metadataParameterElement.getFirstChild();
        if (textNode != null) {
            value = textNode.getNodeValue();
        }
        return value;
    }

    private Element constructParameterElement(Integer index, Object value) throws XMLTranslationException {
        if (index == null) {
            throw new XMLTranslationException("ERR.018.011.0016", SOAPPlugin.Util.getString("ERR.018.011.0016"));
        }
        Element parameterElement = this.getNewElement("param");
        parameterElement.setAttribute("index", index.toString());
        Node valueNode = this.getNewTextNode("param");
        if (value == null) {
            value = new String();
        }
        valueNode.setNodeValue(value.toString());
        parameterElement.appendChild(valueNode);
        return parameterElement;
    }

    public Element translateRowsAffected(int rowsAffected) throws XMLTranslationException {
        Element rowsAffectedElement = this.getNewElement("rowsaffected");
        Node rowsAffectedNode = this.getNewTextNode("rowsaffected");
        rowsAffectedNode.setNodeValue("" + rowsAffected);
        rowsAffectedElement.appendChild(rowsAffectedNode);
        return rowsAffectedElement;
    }

    public Element translateTabularResults(ResultSet results, boolean fullMetadata) throws SQLException, XMLTranslationException {
        Element resultsElement = this.getNewElement("resultset");
        try {
            Element metadataElement = this.createMetadataElement(results.getMetaData());
            List listOfColumnElements = this.createColumnElements(results.getMetaData(), fullMetadata);
            Iterator iter = listOfColumnElements.iterator();
            while (iter.hasNext()) {
                Element columnElement = (Element)iter.next();
                metadataElement.appendChild(columnElement);
            }
            resultsElement.appendChild(metadataElement);
            Element dataElement = this.createDataElement((ResultsImpl)results);
            resultsElement.appendChild(dataElement);
        }
        catch (Exception e) {
            throw new XMLTranslationException(e, "ERR.018.011.0017", SOAPPlugin.Util.getString("ERR.018.011.0017", (Object)e.getMessage()));
        }
        resultsElement = this.addWarningsAndExceptions(resultsElement, results);
        return resultsElement;
    }

    public Element translateTabularResults(ResultSet results, boolean fullMetadata, int[] rows) throws SQLException, XMLTranslationException {
        Element resultsElement = this.getNewElement("resultset");
        try {
            Element metadataElement = this.createMetadataElement(results.getMetaData());
            List listOfColumnElements = this.createColumnElements(results.getMetaData(), fullMetadata);
            Iterator iter = listOfColumnElements.iterator();
            while (iter.hasNext()) {
                Element columnElement = (Element)iter.next();
                metadataElement.appendChild(columnElement);
            }
            resultsElement.appendChild(metadataElement);
            Element dataElement = this.createDataElement((ResultsImpl)results, rows);
            resultsElement.appendChild(dataElement);
        }
        catch (Exception ste) {
            throw new XMLTranslationException(ste, "ERR.018.011.0017", SOAPPlugin.Util.getString("ERR.018.011.0017", (Object)ste.getMessage()));
        }
        resultsElement = this.addWarningsAndExceptions(resultsElement, results);
        return resultsElement;
    }

    private Element addWarningsAndExceptions(Element root, ResultSet results) throws SQLException, XMLTranslationException {
        Element exceptionElement;
        Element warningElement = this.translateWarnings(results);
        if (warningElement != null) {
            root.appendChild(warningElement);
        }
        if ((exceptionElement = this.translateExceptions(results)) != null) {
            root.appendChild(exceptionElement);
        }
        return root;
    }

    private Element translateWarnings(ResultSet results) throws SQLException, XMLTranslationException {
        Element warningElement = null;
        SQLWarning warning = results.getWarnings();
        if (warning != null) {
            warningElement = this.getNewElement("warnings");
            while (warning != null) {
                String message = warning.getMessage();
                Element warningChild = this.getNewElement("warning");
                Node childTextNode = this.getNewTextNode("warning");
                childTextNode.setNodeValue(message);
                warningChild.appendChild(childTextNode);
                warningElement.appendChild(warningChild);
                warning = warning.getNextWarning();
            }
        }
        return warningElement;
    }

    private Element translateExceptions(ResultSet results) throws SQLException, XMLTranslationException {
        MetaMatrixException exception;
        Element exceptionElement = null;
        if (results instanceof ResultsImpl && (exception = ((ResultsImpl)results).getException()) != null) {
            exceptionElement = this.getNewElement("exception");
            String message = exception.getFullMessage();
            exceptionElement.setNodeValue(message);
        }
        return exceptionElement;
    }

    private List createColumnElements(ResultSetMetaData metadata, boolean fullMetadata) throws SQLException, XMLTranslationException {
        ArrayList<Element> listOfColumns = new ArrayList<Element>();
        int count = metadata.getColumnCount();
        for (int index = 0; index < count; ++index) {
            Element columnElement = this.createColumnElement((com.metamatrix.jdbc.api.ResultSetMetaData)metadata, fullMetadata, index);
            listOfColumns.add(columnElement);
        }
        return listOfColumns;
    }

    private Element createDataElement(ResultsImpl results) throws XMLTranslationException {
        Element dataElement = this.getNewElement("data");
        try {
            while (results.next()) {
                List record = results.getCurrentRecord();
                Element rowElement = this.createRowElement(record);
                dataElement.appendChild(rowElement);
            }
        }
        catch (Exception e) {
            throw new XMLTranslationException(e.getMessage());
        }
        return dataElement;
    }

    private Element createDataElement(ResultsImpl results, int[] rows) throws XMLTranslationException {
        if (rows == null) {
            return this.createDataElement(results);
        }
        Element dataElement = this.getNewElement("data");
        try {
            for (int i = 0; i < rows.length; ++i) {
                int rowIndex = rows[i];
                while (results.getRow() != rowIndex) {
                    results.next();
                }
                List record = results.getCurrentRecord();
                Element rowElement = this.createRowElement(record);
                dataElement.appendChild(rowElement);
            }
        }
        catch (Exception e) {
            throw new XMLTranslationException(e.getMessage());
        }
        return dataElement;
    }

    private Element createRowElement(List record) throws XMLTranslationException {
        Element rowElement = this.getNewElement("row");
        Iterator iter = record.iterator();
        while (iter.hasNext()) {
            Element cellElement = this.getNewElement("cell");
            Object value = iter.next();
            Node cellNode = this.getNewTextNode("cell");
            if (value == null) {
                value = new String();
            }
            cellNode.setNodeValue(value.toString());
            cellElement.appendChild(cellNode);
            rowElement.appendChild(cellElement);
        }
        return rowElement;
    }

    private Element createColumnElement(com.metamatrix.jdbc.api.ResultSetMetaData metadata, boolean fullMetadata, int index) throws SQLException, XMLTranslationException {
        Element columnElement = this.getNewElement("column");
        columnElement.setAttribute("datatype", metadata.getColumnTypeName(index));
        Node columnNameNode = this.getNewTextNode("datatype");
        columnNameNode.setNodeValue(metadata.getColumnName(index));
        columnElement.appendChild(columnNameNode);
        if (fullMetadata) {
            columnElement.setAttribute("vdbname", metadata.getVirtualDatabaseName(index));
            columnElement.setAttribute("vdbversion", metadata.getVirtualDatabaseVersion(index));
            columnElement.setAttribute("groupname", metadata.getCatalogName(index));
            columnElement.setAttribute("precision", "" + metadata.getPrecision(index));
            columnElement.setAttribute("radix", "10");
            columnElement.setAttribute("scale", "" + metadata.getScale(index));
            columnElement.setAttribute("searchable", "" + metadata.isSearchable(index));
            columnElement.setAttribute("isautoincrementing", "" + metadata.isAutoIncrement(index));
            columnElement.setAttribute("iscasesensitive", "" + metadata.isCaseSensitive(index));
            columnElement.setAttribute("iscurrency", "" + metadata.isCurrency(index));
            columnElement.setAttribute("isnullable", "" + metadata.isNullable(index));
            columnElement.setAttribute("issigned", "" + metadata.isSigned(index));
            columnElement.setAttribute("isupdateable", "" + metadata.isWritable(index));
        }
        return columnElement;
    }

    private Element createMetadataElement(ResultSetMetaData metadata) throws SQLException, XMLTranslationException {
        Element metadataElement = this.getNewElement("metadata");
        metadataElement = this.addMetadataElementAttributes(metadataElement, metadata);
        return metadataElement;
    }

    private Element addMetadataElementAttributes(Element metadataElement, ResultSetMetaData metadata) throws SQLException {
        String elementCount = new String("" + metadata.getColumnCount());
        metadataElement.setAttribute("elementcount", elementCount);
        return metadataElement;
    }

    public Element getNewElement(String elementName) throws XMLTranslationException {
        if (elementName == null) {
            throw new XMLTranslationException("ERR.018.011.0018", SOAPPlugin.Util.getString("ERR.018.011.0018"));
        }
        Document doc = null;
        try {
            doc = this.getDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new XMLTranslationException(pce, "ERR.018.011.0019", SOAPPlugin.Util.getString("ERR.018.011.0019", (Object)pce.getMessage()));
        }
        return doc.createElement(elementName);
    }

    protected Document getDocument() throws ParserConfigurationException {
        if (this.document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        return this.document;
    }

    protected Node getNewTextNode(String nodeName) throws XMLTranslationException {
        if (nodeName == null) {
            throw new XMLTranslationException("ERR.018.011.0020", SOAPPlugin.Util.getString("ERR.018.011.0020"));
        }
        Document doc = null;
        try {
            doc = this.getDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new XMLTranslationException(pce, "ERR.018.011.0019", SOAPPlugin.Util.getString("ERR.018.011.0019", (Object)pce.getMessage()));
        }
        return doc.createTextNode(nodeName);
    }

    public String translateElementToString(Node element) throws XMLTranslationException {
        StringBuffer result = new StringBuffer();
        if (element.getNodeType() == 3) {
            result.append(element.getNodeValue());
        } else {
            if (element.getParentNode() == null) {
                result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            }
            result.append("<");
            result.append(element.getNodeName());
            NamedNodeMap map = element.getAttributes();
            if (map != null) {
                int attributes = map.getLength();
                for (int index = 0; index < attributes; ++index) {
                    Node attr = map.item(index);
                    result.append(" ");
                    result.append(attr.getNodeName());
                    result.append("=");
                    result.append("\"");
                    result.append(attr.getNodeValue());
                    result.append("\"");
                    if (index >= attributes - 1) continue;
                    result.append(" ");
                }
            }
            result.append(">");
            NodeList list = element.getChildNodes();
            int numberOfChildren = list.getLength();
            for (int i = 0; i < numberOfChildren; ++i) {
                String child = this.translateElementToString(list.item(i));
                result.append(child);
            }
            result.append("</");
            result.append(element.getNodeName());
            result.append(">");
        }
        return result.toString();
    }

    public static final class Constant_TAGS {
        public static final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        public static final String ROWS_AFFECTED_TAG = "rowsaffected";
        public static final String RESULT_SET_TAG = "resultset";
        public static final String WARNINGS_TAG = "warnings";
        public static final String WARNING_TAG = "warning";
        public static final String EXCEPTION_TAG = "exception";
        public static final String XMLDOCUMENTS_RESULTS_TAG = "xmlresults";

        public static final class Data {
            public static final String DATA_TAG = "data";

            public static final class Row {
                public static final String ROW_TAG = "row";

                public static final class Cell {
                    public static final String CELL_TAG = "cell";
                }
            }
        }

        public static final class Column {
            public static final String COLUMN_TAG = "column";

            public static final class COLUMN_ATTRIBUTE_TAGS {
                public static final String DATATYPE = "datatype";
                public static final String VDBNAME = "vdbname";
                public static final String VDBVERSION = "vdbversion";
                public static final String GROUPNAME = "groupname";
                public static final String PRECISION = "precision";
                public static final String RADIX = "radix";
                public static final String SCALE = "scale";
                public static final String SEARCHABLE = "searchable";
                public static final String ISAUTOINCREMENTING = "isautoincrementing";
                public static final String ISCASESENSITIVE = "iscasesensitive";
                public static final String ISCURRENCY = "iscurrency";
                public static final String ISNULLABLE = "isnullable";
                public static final String ISSIGNED = "issigned";
                public static final String ISUPDATEABLE = "isupdateable";
            }
        }

        public static final class MetadataParameter {
            public static final String METADATA_PARAMETER_TAG = "metadataparameter";

            public static final class Attributes {
                public static final String NAME_TAG = "name";
            }
        }

        public static final class Metadata {
            public static final String METADATA_TAG = "metadata";

            public static final class Attributes {
                public static final String ELEMENT_COUNT_TAG = "elementcount";
            }
        }

        public static final class StoredProcedureParameters {
            public static final String PARAMETERS_TAG = "parameters";

            public static final class Param {
                public static final String PARAM_TAG = "param";

                public static final class Attributes {
                    public static final String INDEX_TAG = "index";
                }
            }
        }

        public static final class XMLSCHEMA {
            public static final String XMLSCHEMA_TAG = "xmlschema";

            public static final class Attributes {
                public static final String IS_PRIMARY_TAG = "isprimary";
            }
        }

        public static final class XMLDOCUMENTS {
            public static final String XMLDOCUMENTS_TAG = "xmldoc";
        }
    }
}

