/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.classloader;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class URLClassLoaderRegistry {
    private static File baseFolder;
    private final Map classLoaders = new HashMap();

    public static void setBaseFolder(String folder) {
        baseFolder = folder == null ? null : new File(folder);
    }

    public synchronized URLClassLoader removeClassLoader(URL[] urls) {
        ArgCheck.isNotNull(urls);
        Object key = this.doCreateKey(urls);
        return (URLClassLoader)this.classLoaders.remove(key);
    }

    public synchronized URLClassLoader removeClassLoader(String[] urlStrings) throws MalformedURLException {
        ArgCheck.isNotNull(urlStrings);
        Object key = this.doCreateKey(urlStrings);
        return (URLClassLoader)this.classLoaders.remove(key);
    }

    public URLClassLoader getClassLoader(String[] urlStrings) throws MalformedURLException {
        return this.getClassLoader(urlStrings, null);
    }

    public URLClassLoader getClassLoader(String[] urlStrings, ClassLoader parent) throws MalformedURLException {
        ArgCheck.isNotNull(urlStrings);
        Object key = this.doCreateKey(urlStrings);
        URL[] urls = new URL[urlStrings.length];
        for (int i = 0; i < urlStrings.length; ++i) {
            urls[i] = this.doCreateUrl(urlStrings[i]);
        }
        return this.doGetOrCreateClassLoader(key, urls, parent);
    }

    public URLClassLoader getClassLoader(URL[] urls) {
        return this.getClassLoader(urls, null);
    }

    public URLClassLoader getClassLoader(URL[] urls, ClassLoader parent) {
        ArgCheck.isNotNull(urls);
        Object key = this.doCreateKey(urls);
        return this.doGetOrCreateClassLoader(key, urls, parent);
    }

    protected int size() {
        return this.classLoaders.size();
    }

    protected Object doCreateKey(String[] urlStrings) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < urlStrings.length; ++i) {
            String str = urlStrings[i];
            if (i != 0) {
                sb.append("\n\n");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    protected Object doCreateKey(URL[] urls) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            if (i != 0) {
                sb.append("\n\n");
            }
            sb.append(url.toString());
        }
        return sb.toString();
    }

    protected URL doCreateUrl(String urlString) throws MalformedURLException {
        MalformedURLException mfue = null;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e1) {
            mfue = e1;
        }
        if (url == null) {
            File jarFile;
            File file = jarFile = baseFolder == null ? new File(urlString) : new File(baseFolder, urlString);
            if (jarFile.exists()) {
                try {
                    url = jarFile.toURL();
                    mfue = null;
                }
                catch (MalformedURLException e) {
                    mfue = e;
                }
            } else {
                Object[] params = new Object[]{urlString};
                String msg = CorePlugin.Util.getString("URLClassLoaderRegistry.UnableToCreateClassLoaderForUrl_FileDoesNotExist", params);
                mfue = new MalformedURLException(msg);
            }
        }
        if (mfue != null) {
            throw mfue;
        }
        return url;
    }

    protected synchronized URLClassLoader doGetOrCreateClassLoader(Object key, URL[] urls, ClassLoader parent) {
        URLClassLoader loader = (URLClassLoader)this.classLoaders.get(key);
        if (loader == null) {
            loader = this.doCreateClassLoader(key, urls, parent);
            this.classLoaders.put(key, loader);
        }
        return loader;
    }

    protected URLClassLoader doCreateClassLoader(Object key, URL[] urls, ClassLoader parent) {
        return new URLClassLoader(urls, parent);
    }
}

