/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;

public abstract class ResourceNameUtil {
    private static final String INVALID_EXTENSION_ERROR_ID = "ResourceNameUtil.invalidFileExtensionError";
    private static final String COMMA_SPACE = ", ";
    public static final String XMI_FILE_EXTENSION = "xmi";
    public static final String VDB_FILE_EXTENSION = "vdb";
    public static final String XSD_FILE_EXTENSION = "xsd";
    public static final String XML_FILE_EXTENSION = "xml";
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    public static final String DOT_XMI_FILE_EXTENSION = ".xmi";
    public static final String DOT_VDB_FILE_EXTENSION = ".vdb";
    public static final String DOT_XSD_FILE_EXTENSION = ".xsd";
    public static final String DOT_XML_FILE_EXTENSION = ".xml";
    public static final String DOT_WSDL_FILE_EXTENSION = ".wsdl";
    public static final String ADMIN_NAME = "Admin";
    public static final String BUILTINDATATYPES_NAME = "builtInDataTypes";
    public static final String BUILTINRELATIONALTYPES_NAME = "builtInRelationshipTypes";
    public static final String CORE_NAME = "Core";
    public static final String DATAACCESS_NAME = "Dataaccess";
    public static final String DATASERVICESYSTEMMODEL_NAME = "DataServiceSystemModel";
    public static final String DTCBASE_NAME = "DtcBase";
    public static final String ECORE_NAME = "Ecore";
    public static final String ENTERPRISEDATATYPES_NAME = "EnterpriseDatatypes";
    public static final String EXTENSION_NAME = "Extension";
    public static final String FUNCTION_NAME = "Function";
    public static final String HELP_NAME = "Help";
    public static final String JDBC_NAME = "Jdbc";
    public static final String JDBCMODEL_NAME = "jdbcModel";
    public static final String JDBCSYSTEM_NAME = "JDBCSystem";
    public static final String MAGICXMLSCHEMA_NAME = "MagicXMLSchema";
    public static final String MANIFEST_NAME = "Manifest";
    public static final String MAPPING_NAME = "Mapping";
    public static final String MBR_NAME = "Mbr";
    public static final String METAMATRIX_VDBMANIFESTMODEL_NAME = "MetaMatrix-VdbManifestModel";
    public static final String METAMODELRELATIONALMODEL_NAME = "MetamodelRelationalModel";
    public static final String NAMESPACE_NAME = "namespace";
    public static final String PRIMATIVETYPES_NAME = "primitiveTypes";
    public static final String RELATIONAL_NAME = "Relational";
    public static final String RELATIONSHIP_NAME = "Relationship";
    public static final String SIMPLEDATATYPES_INSTANCE_NAME = "SimpleDatatypes-instance";
    public static final String SYSTEM_NAME = "System";
    public static final String SYSTEMADMIN_NAME = "SystemAdmin";
    public static final String SYSTEMADMINPHYSICAL_NAME = "SystemAdminPhysical";
    public static final String SYSTEMPHYSICAL_NAME = "SystemPhysical";
    public static final String SYSTEMSCHEMA_NAME = "SystemSchema";
    public static final String SYSTEMVIRTUALDATABASE_NAME = "SystemVirtualDatabase";
    public static final String TRANSFORMATION_NAME = "Transformation";
    public static final String UML2_NAME = "Uml2";
    public static final String WEBSERVICE_NAME = "Webservice";
    public static final String WSDL1_1_NAME = "WSDL1_1";
    public static final String WSDLSOAP_NAME = "WSDLSOAP";
    public static final String XML_NAME = "Xml";
    public static final String XMLSCHEMA_NAME = "XMLSchema";
    public static final String XMLSCHEMA_INSTANCE_NAME = "XMLSchema-instance";
    public static final String XSD_NAME = "Xsd";
    public static final String[] RESERVED_VDB_NAMES = new String[]{"Admin", "Help", "System", "SystemVirtualDatabase"};
    public static final String[] RESERVED_XMI_NAMES = new String[]{"Core", "builtInRelationshipTypes", "Dataaccess", "DataServiceSystemModel", "DtcBase", "Ecore", "EnterpriseDatatypes", "Extension", "Function", "Jdbc", "jdbcModel", "JDBCSystem", "Manifest", "Mapping", "Mbr", "MetaMatrix-VdbManifestModel", "MetamodelRelationalModel", "primitiveTypes", "Relational", "Relationship", "SimpleDatatypes-instance", "System", "SystemAdmin", "SystemAdminPhysical", "SystemPhysical", "Transformation", "Uml2", "Webservice", "WSDL1_1", "WSDLSOAP", "Xml", "Xsd"};
    public static final String[] RESERVED_XSD_NAMES = new String[]{"builtInDataTypes", "EnterpriseDatatypes", "MagicXMLSchema", "namespace", "SimpleDatatypes-instance", "SystemSchema", "Xml", "XMLSchema", "XMLSchema-instance"};

    public static boolean isReservedVdbName(String proposedName) throws IllegalArgumentException {
        if (proposedName == null && proposedName.length() <= 0) {
            return false;
        }
        if (proposedName.indexOf(46) != -1) {
            if (!proposedName.endsWith(DOT_VDB_FILE_EXTENSION)) {
                throw new IllegalArgumentException(CorePlugin.Util.getString(INVALID_EXTENSION_ERROR_ID, proposedName, VDB_FILE_EXTENSION));
            }
            if ((proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_VDB_FILE_EXTENSION))).indexOf(46) != -1) {
                return false;
            }
        }
        for (int i = 0; i < RESERVED_VDB_NAMES.length; ++i) {
            if (!proposedName.equalsIgnoreCase(RESERVED_VDB_NAMES[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedModelName(String proposedName) throws IllegalArgumentException {
        if (proposedName == null && proposedName.length() <= 0) {
            return false;
        }
        if (proposedName.indexOf(46) != -1) {
            if (!proposedName.endsWith(DOT_XMI_FILE_EXTENSION)) {
                throw new IllegalArgumentException(CorePlugin.Util.getString(INVALID_EXTENSION_ERROR_ID, proposedName, XMI_FILE_EXTENSION));
            }
            if ((proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_XMI_FILE_EXTENSION))).indexOf(46) != -1) {
                return false;
            }
        }
        for (int i = 0; i < RESERVED_XMI_NAMES.length; ++i) {
            if (!proposedName.equalsIgnoreCase(RESERVED_XMI_NAMES[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedSchemaName(String proposedName) throws IllegalArgumentException {
        if (proposedName == null && proposedName.length() <= 0) {
            return false;
        }
        if (proposedName.indexOf(46) != -1) {
            if (!proposedName.endsWith(DOT_XSD_FILE_EXTENSION)) {
                throw new IllegalArgumentException(CorePlugin.Util.getString(INVALID_EXTENSION_ERROR_ID, proposedName, XSD_FILE_EXTENSION));
            }
            if ((proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_XSD_FILE_EXTENSION))).indexOf(46) != -1) {
                return false;
            }
        }
        for (int i = 0; i < RESERVED_XSD_NAMES.length; ++i) {
            if (!proposedName.equalsIgnoreCase(RESERVED_XSD_NAMES[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isReservedResourceName(String proposedName) throws IllegalArgumentException {
        boolean result = false;
        if (proposedName == null && proposedName.length() <= 0) {
            return false;
        }
        if (proposedName.indexOf(46) != -1) {
            if (!(proposedName.endsWith(DOT_XSD_FILE_EXTENSION) || proposedName.endsWith(DOT_XMI_FILE_EXTENSION) || proposedName.endsWith(DOT_VDB_FILE_EXTENSION))) {
                String allExtensions = "xmi, xsd, vdb";
                throw new IllegalArgumentException(CorePlugin.Util.getString(INVALID_EXTENSION_ERROR_ID, proposedName, allExtensions));
            }
            if (proposedName.endsWith(DOT_XSD_FILE_EXTENSION)) {
                result = (proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_XSD_FILE_EXTENSION))).indexOf(46) != -1 ? false : ResourceNameUtil.isReservedSchemaName(proposedName);
            }
            if (!result && proposedName.endsWith(DOT_XMI_FILE_EXTENSION)) {
                result = (proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_XMI_FILE_EXTENSION))).indexOf(46) != -1 ? false : ResourceNameUtil.isReservedModelName(proposedName);
            }
            if (!result && proposedName.endsWith(DOT_VDB_FILE_EXTENSION)) {
                result = (proposedName = proposedName.substring(0, proposedName.lastIndexOf(DOT_VDB_FILE_EXTENSION))).indexOf(46) != -1 ? false : ResourceNameUtil.isReservedVdbName(proposedName);
            }
        } else {
            result = ResourceNameUtil.isReservedSchemaName(proposedName);
            if (!result) {
                result = ResourceNameUtil.isReservedModelName(proposedName);
            }
            if (!result) {
                result = ResourceNameUtil.isReservedVdbName(proposedName);
            }
        }
        return result;
    }
}

