/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.license.LicenseDescriptor;
import com.metamatrix.license.LicenseManager;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.license.exception.UnlicensedProductException;
import com.metamatrix.license.exception.UnverifiedLicenseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LicenseChecker {
    static final String LICENSE_FILE = "MetaMatrixLicense.xml";
    static final String CERT_FILE = "metamatrix.cert";
    static final String ABOUT_PLUGIN_NAME = "com.metamatrix.modeler";
    static final String ABOUT_MAPPINGS_FILE = "about.mappings";
    private static boolean licenseLoaded = false;
    private static final LicenseManager licenseManager = new LicenseManager();
    private static Notifier notifier = LicenseChecker.getNullNotifier();
    static /* synthetic */ Class class$com$metamatrix$license$LicenseChecker;

    public static void registerNotifier(Notifier clientNotifier) {
        notifier = clientNotifier;
    }

    public static String getLicenseFileName() {
        return LICENSE_FILE;
    }

    public static synchronized void loadLicense() throws LicenseVerificationException {
        try {
            licenseManager.setLicenseFilename(LICENSE_FILE);
            licenseManager.setCertificateFilename(CERT_FILE);
            licenseManager.loadLicense();
            licenseLoaded = true;
        }
        catch (FileNotFoundException e) {
            notifier.showFailureMessage(e.getMessage());
            throw new LicenseVerificationException(e, LicensePlugin.Util.getString("ERR.003.016.0003", (Object)LICENSE_FILE));
        }
        catch (IOException e) {
            notifier.showFailureMessage(e.getMessage());
            throw new LicenseVerificationException(e, LicensePlugin.Util.getString("ERR.003.016.0005", (Object)LICENSE_FILE));
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
            throw new LicenseVerificationException((Throwable)((Object)e), LicensePlugin.Util.getString("ERR.003.016.0005", (Object)LICENSE_FILE));
        }
    }

    public static synchronized void loadLicense(ClassLoader classLoader) throws LicenseVerificationException {
        try {
            if (classLoader == null) {
                classLoader = (class$com$metamatrix$license$LicenseChecker == null ? (class$com$metamatrix$license$LicenseChecker = LicenseChecker.class$("com.metamatrix.license.LicenseChecker")) : class$com$metamatrix$license$LicenseChecker).getClassLoader();
            }
            InputStream licenseStream = classLoader.getResourceAsStream(LICENSE_FILE);
            InputStream certStream = classLoader.getResourceAsStream(CERT_FILE);
            if (licenseStream == null) {
                notifier.showFailureMessage(LicensePlugin.Util.getString("ERR.003.016.0003", (Object)LICENSE_FILE));
                throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0003", (Object)LICENSE_FILE));
            }
            if (certStream == null) {
                notifier.showFailureMessage(LicensePlugin.Util.getString("ERR.003.016.0004", (Object)CERT_FILE));
                throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0004", (Object)CERT_FILE));
            }
            licenseManager.setLicenseStream(licenseStream);
            licenseManager.setCertificateStream(certStream);
            licenseManager.loadLicense();
            licenseLoaded = true;
        }
        catch (FileNotFoundException e) {
            notifier.showFailureMessage(e.getMessage());
            throw new LicenseVerificationException(e, LicensePlugin.Util.getString("ERR.003.016.0003", (Object)LICENSE_FILE));
        }
        catch (IOException e) {
            notifier.showFailureMessage(e.getMessage());
            throw new LicenseVerificationException(e, LicensePlugin.Util.getString("ERR.003.016.0005", (Object)LICENSE_FILE));
        }
    }

    public static boolean hasValidProductLicense(String productName, String version, boolean checkIP) {
        try {
            String license = LicenseChecker.checkProductLicense(productName, version, checkIP);
            if (license != null && license.length() > 0) {
                notifier.showInfoMessage(license);
            }
            return true;
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return false;
    }

    public static boolean hasValidProductLicense(String productName, String version) {
        try {
            String license = LicenseChecker.checkProductLicense(productName, version);
            if (license != null && license.length() > 0) {
                notifier.showInfoMessage(license);
            }
            return true;
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return false;
    }

    public static boolean hasValidProductLicense(String productName, String version, int nUnits) {
        try {
            String license = LicenseChecker.checkProductLicense(productName, version, nUnits);
            if (license != null && license.length() > 0) {
                notifier.showInfoMessage(license);
            }
            return true;
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return false;
    }

    public static boolean checkProductLicenseForExpiring(String productName, String version) {
        try {
            licenseManager.resetExpireWarned();
            String license = LicenseChecker.checkProductLicense(productName, version);
            if (license != null && license.length() > 0) {
                String sAboutMessage = licenseManager.getEffectivityMessageForAboutDialog(productName, version);
                LicenseChecker.updateLicenseExpiringAboutMessage(sAboutMessage);
                notifier.showInfoMessage(license);
            } else {
                LicenseChecker.updateLicenseExpiringAboutMessage("");
            }
            return true;
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return false;
    }

    public static void updateLicenseExpiringAboutMessage(String sMessage) {
        try {
            Bundle bundle = Platform.getBundle((String)ABOUT_PLUGIN_NAME);
            Path path = new Path(ABOUT_MAPPINGS_FILE);
            URL fileURL = Platform.find((Bundle)bundle, (IPath)path);
            InputStream is = fileURL.openStream();
            Properties props = new Properties();
            props.load(is);
            props.setProperty("1", sMessage);
            URL fileUrlResolved = Platform.resolve((URL)fileURL);
            String pathResolved = fileUrlResolved.getPath();
            File mappingsFile = new File(pathResolved);
            FileOutputStream fos = new FileOutputStream(mappingsFile);
            props.store(fos, null);
            ((OutputStream)fos).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String checkProductLicense(String productName, String version) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.isLicenseValid(productName, version);
    }

    public static String checkProductLicense(String productName, String version, boolean checkIP) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.isLicenseValid(productName, version, checkIP);
    }

    public static String checkProductLicense(String productName, String version, int nUnits) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.isLicenseValid(productName, version, nUnits);
    }

    public static synchronized LicenseDescriptor getLicenseDescriptor(String productName, String version) {
        try {
            if (!licenseLoaded) {
                LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
            }
            return licenseManager.getLicenseDescriptor(productName, version);
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return null;
    }

    public static synchronized LicenseDescriptor getLicenseDescriptor(String productName, String version, String type, String ipAddress) {
        try {
            if (!licenseLoaded) {
                LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
            }
            return licenseManager.getLicenseDescriptor(productName, version, type, ipAddress);
        }
        catch (LicenseVerificationException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnverifiedLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            notifier.showFailureMessage(e.getMessage());
        }
        return null;
    }

    static Notifier getSystemOutNotifier() {
        return new Notifier(){

            public void showFailureMessage(String message) {
                System.out.println(message);
            }

            public void showInfoMessage(String message) {
                System.out.println(message);
            }
        };
    }

    static Notifier getNullNotifier() {
        return new Notifier(){

            public void showFailureMessage(String message) {
            }

            public void showInfoMessage(String message) {
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Notifier {
        public void showFailureMessage(String var1);

        public void showInfoMessage(String var1);
    }
}

