/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.license.LicenseDescriptor;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.License;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.license.exception.UnlicensedProductException;
import com.metamatrix.license.exception.UnverifiedLicenseException;
import com.metamatrix.license.util.MessageIntegrityChecker;
import com.metamatrix.license.util.XMLDocumentUtil;
import com.metamatrix.license.xml.LicenseReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.JDOMException;

public class LicenseManager {
    private static final String SIG_ELEM_PATH = "license.licenseInfo.signature";
    private String licenseFilename;
    private String certificateFilename;
    private InputStream licenseStream;
    private InputStream certificateStream;
    private MessageIntegrityChecker verifier = new MessageIntegrityChecker();
    private XMLDocumentUtil docUtil = new XMLDocumentUtil();
    private License license;
    private Document xmlDoc;

    String getLicenseFilename() {
        return this.licenseFilename;
    }

    public void setLicenseFilename(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0009"));
        }
        this.licenseFilename = name;
    }

    public void setLicenseStream(InputStream istream) {
        if (istream == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0010"));
        }
        this.licenseStream = istream;
    }

    String getCertificateFilename() {
        return this.certificateFilename;
    }

    public void setCertificateFilename(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0011"));
        }
        this.certificateFilename = name;
    }

    public void setCertificateStream(InputStream istream) {
        if (istream == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0012"));
        }
        this.certificateStream = istream;
    }

    public void loadLicense(String filename) throws FileNotFoundException, IOException, LicenseVerificationException {
        this.setLicenseFilename(filename);
        this.loadLicense();
    }

    public void loadLicense() throws FileNotFoundException, IOException, LicenseVerificationException {
        this.loadLicenseFromXML();
        this.verifyLicenseIntegrity();
    }

    public String isLicenseValid(String productName, String version) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        this.wasLicenseLoaded();
        return this.license.checkValidity(productName, version);
    }

    public String getEffectivityMessageForAboutDialog(String productName, String version) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        return this.license.getEffectivityMessageForAboutDialog(productName, version);
    }

    public void resetExpireWarned() {
        this.license.resetExpireWarned();
    }

    public String isLicenseValid(String productName, String version, int nUnits) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        this.wasLicenseLoaded();
        return this.license.checkValidity(productName, version, nUnits);
    }

    public String isLicenseValid(String productName, String version, boolean checkIP) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        this.wasLicenseLoaded();
        return this.license.checkValidity(productName, version, checkIP);
    }

    public LicenseDescriptor getLicenseDescriptor(String productName, String version) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        this.wasLicenseLoaded();
        ProductLicense productLicense = this.license.getProductLicense(productName, version);
        LicenseDescriptor descriptor = new LicenseDescriptor(this.license, productLicense);
        return descriptor;
    }

    public LicenseDescriptor getLicenseDescriptor(String productName, String version, String type, String ipAddr) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        this.wasLicenseLoaded();
        ProductLicense productLicense = this.license.getProductLicense(productName, version, type, ipAddr);
        LicenseDescriptor descriptor = new LicenseDescriptor(this.license, productLicense);
        return descriptor;
    }

    private void loadLicenseFromXML() throws FileNotFoundException, IOException, LicenseVerificationException {
        LicenseReader reader = null;
        if (this.licenseFilename != null) {
            reader = new LicenseReader(this.licenseFilename);
        } else if (this.licenseStream != null) {
            reader = new LicenseReader(this.licenseStream);
        } else {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0013"));
        }
        try {
            reader.init();
            this.license = reader.loadLicense();
            this.xmlDoc = reader.getXMLDocument();
        }
        catch (IOException e) {
            throw e;
        }
        catch (JDOMException e) {
            throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0014", (Object)e.getMessage()));
        }
        catch (NullPointerException e) {
            throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0015", (Object)e.getMessage()));
        }
        catch (Exception e) {
            throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0016", (Object)e.getMessage()));
        }
    }

    private void verifyLicenseIntegrity() throws LicenseVerificationException {
        boolean passed = false;
        try {
            if (this.certificateFilename != null) {
                this.verifier.setCertificateStream(this.certificateFilename);
            } else if (this.certificateStream != null) {
                this.verifier.setCertificateStream(this.certificateStream);
            } else {
                throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0017"));
            }
            this.docUtil.setDocument(this.xmlDoc);
            String messageToVerify = this.docUtil.getDocumentAsStringExcludingElement(SIG_ELEM_PATH);
            this.verifier.setMessage(messageToVerify);
            String encodedSig = this.docUtil.getElementContent(SIG_ELEM_PATH);
            this.verifier.setSignatureBytes(encodedSig);
            this.verifier.init();
            passed = this.verifier.verify();
            this.verifier.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0018", (Object)e.getMessage()));
        }
        if (!passed) {
            throw new LicenseVerificationException(LicensePlugin.Util.getString("ERR.003.016.0019"));
        }
    }

    private void wasLicenseLoaded() throws UnverifiedLicenseException {
        if (this.license == null) {
            throw new UnverifiedLicenseException(LicensePlugin.Util.getString("ERR.003.016.0020"));
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("help")) {
            System.out.println("\nusage: java com.metamatrix.common.LicenseManager [licenseFile] [certFile] [source] [productName] [version]\n");
            System.out.println("  where ");
            System.out.println("    licenseFile is file containing the license");
            System.out.println("             (default is MetaMatrixLicense.xml)");
            System.out.println("    certFile    is the file containing the certificate");
            System.out.println("             (default is metamatrix.cert)");
            System.out.println("    source      is 'stream' or 'file' (default)");
            System.out.println("    productName is the name of the product to check license for");
            System.out.println("             (default is to not check license)");
            System.out.println("    version     is the product version to check a license for");
            System.out.println("             (default is to not check license)");
            System.exit(0);
        }
        String licenseFile = args.length > 0 ? args[0] : "MetaMatrixLicense.xml";
        String certFile = args.length > 1 ? args[1] : "metamatrix.cert";
        String source = args.length > 2 ? args[2] : "file";
        String productName = args.length > 3 ? args[3] : null;
        String version = args.length > 4 ? args[4] : null;
        LicenseManager licenseManager = new LicenseManager();
        if (source.equalsIgnoreCase("stream")) {
            LicenseManager.testLoadFromStreams(licenseManager, licenseFile, certFile);
        } else {
            LicenseManager.testLoadFromFiles(licenseManager, licenseFile, certFile);
        }
        if (productName != null && productName.length() > 0 && version != null) {
            LicenseManager.testLicenseCheck(licenseManager, productName, version, false);
            LicenseManager.testLicenseCheck(licenseManager, productName, version, true);
        }
    }

    private static void testLoadFromFiles(LicenseManager lm, String licenseFile, String certFile) throws LicenseVerificationException, FileNotFoundException, IOException {
        lm.setLicenseFilename(licenseFile);
        lm.setCertificateFilename(certFile);
        System.out.println("\nAttempting to load and verify '" + licenseFile + "' using certificate '" + certFile + "'.");
        try {
            lm.loadLicense();
            System.out.println("\nLicense was successfully loaded and verified.\n");
        }
        catch (LicenseVerificationException e) {
            System.out.println("\nLicense was NOT successfully loaded and verified.\n");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("\nIO error occurred trying to load license.\n");
            e.printStackTrace();
        }
    }

    private static void testLoadFromStreams(LicenseManager lm, String licenseFile, String certFile) throws LicenseVerificationException, FileNotFoundException, IOException {
        InputStream certStream;
        InputStream licenseStream = LicenseManager.getResourceStream(lm.getClass(), licenseFile);
        if (licenseStream == null) {
            System.err.println("License file " + licenseFile + " not found in application classpath.");
            System.exit(-1);
        }
        if ((certStream = LicenseManager.getResourceStream(lm.getClass(), certFile)) == null) {
            System.err.println("Certificate file " + certFile + " not found in application classpath.");
            System.exit(-1);
        }
        lm.setLicenseStream(licenseStream);
        lm.setCertificateStream(certStream);
        System.out.println("\nAttempting to load and verify '" + licenseFile + "' using certificate '" + certFile + "'.");
        try {
            lm.loadLicense();
            System.out.println("\nLicense was successfully loaded and verified.\n");
        }
        catch (LicenseVerificationException e) {
            System.out.println("\nLicense was NOT successfully loaded and verified.\n");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("\nIO error occurred trying to load license.\n");
            e.printStackTrace();
        }
    }

    private static void testLicenseCheck(LicenseManager licenseManager, String productName, String version, boolean checkIP) {
        System.out.println("\nAttempting to get a license for '" + productName + "' version '" + version + "'" + (checkIP ? " localhost IP check" : "") + ".");
        try {
            licenseManager.isLicenseValid(productName, version, checkIP);
            System.out.println("\nLicense was successfully obtained.\n");
        }
        catch (UnverifiedLicenseException e) {
            System.out.println("\nLicense was NOT successfully loaded and verified.\n");
            e.printStackTrace();
        }
        catch (UnlicensedProductException e) {
            System.out.println("\nProduct '" + productName + "' version '" + version + "' is not licensed.\n");
            e.printStackTrace();
        }
        catch (InvalidLicenseException e) {
            System.out.println("\nLicense for product '" + productName + "' version '" + version + "' is invalid.\n");
            e.printStackTrace();
        }
    }

    private static InputStream getResourceStream(Class appClass, String filename) {
        InputStream inputStream = null;
        try {
            inputStream = appClass.getClassLoader().getResourceAsStream(filename);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return inputStream;
    }
}

