/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.IPSet;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.domain.ProductVersionComparator;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.UnlicensedProductException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;

public class ProductLicenses {
    private static final int DAYS_TO_WARN_EXPIRE = 10;
    public static final ProductVersionComparator COMPARATOR = new ProductVersionComparator();
    private static boolean expireWarned = false;
    Map productLicenses = new TreeMap();

    public int size() {
        return this.productLicenses.size();
    }

    public ProductLicense getLicense(String uuid) {
        return (ProductLicense)this.productLicenses.get(uuid);
    }

    public void addLicense(ProductLicense license) {
        this.productLicenses.put(license.getUUID(), license);
    }

    public Iterator iterator() {
        return this.getLicenses().iterator();
    }

    public static void resetExpireWarned() {
        expireWarned = false;
    }

    public Set getLicenses() {
        TreeSet<ProductLicense> list = new TreeSet<ProductLicense>(COMPARATOR);
        Iterator entries = this.productLicenses.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ProductLicense license = (ProductLicense)entry.getValue();
            list.add(license);
        }
        return list;
    }

    public Set getLicenses(String productName) throws UnlicensedProductException {
        if (productName == null || productName.length() == 0) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0032"));
        }
        TreeSet<ProductLicense> list = new TreeSet<ProductLicense>(COMPARATOR);
        Iterator entries = this.productLicenses.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ProductLicense license = (ProductLicense)entry.getValue();
            String name = license.getProductName();
            if (!name.equals(productName)) continue;
            list.add(license);
        }
        if (list.size() == 0) {
            throw new UnlicensedProductException(productName);
        }
        return list;
    }

    public Set getLicenses(String productName, String version) throws UnlicensedProductException {
        if (productName == null || productName.length() == 0) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0032"));
        }
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0033"));
        }
        TreeSet<ProductLicense> list = new TreeSet<ProductLicense>(COMPARATOR);
        Iterator entries = this.productLicenses.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ProductLicense license = (ProductLicense)entry.getValue();
            String name = license.getProductName();
            if (!name.equals(productName) || !ProductLicenses.versionMatches(version, license.getVersionSpec())) continue;
            list.add(license);
        }
        if (list.size() == 0) {
            throw new UnlicensedProductException(productName, version);
        }
        return list;
    }

    public Set getLicenses(String productName, String version, String type, String ipAddr) throws UnlicensedProductException, InvalidLicenseException {
        TreeSet<ProductLicense> list = new TreeSet<ProductLicense>(COMPARATOR);
        SortedSet matches = (SortedSet)this.getLicenses(productName, version);
        Iterator entries = matches.iterator();
        while (entries.hasNext()) {
            ProductLicense license = (ProductLicense)entries.next();
            if (type != null && !license.getType().equalsIgnoreCase(type) || ipAddr != null && !license.isIPValid(ipAddr)) continue;
            list.add(license);
        }
        if (list.size() == 0) {
            String reason = type == null ? LicensePlugin.Util.getString("ERR.003.016.0034", new Object[]{ipAddr, productName, version}) : (ipAddr == null ? LicensePlugin.Util.getString("ERR.003.016.0035", new Object[]{type, productName, version}) : LicensePlugin.Util.getString("ERR.003.016.0036", new Object[]{ipAddr, type, productName, version}));
            throw new InvalidLicenseException(productName, version, reason);
        }
        return list;
    }

    public ProductLicense getBestLicense(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        Set licenses = this.getLicenses(productName, version);
        return this.getBestLicense(licenses);
    }

    public ProductLicense getBestLicense(String productName, String version, String type, String ipAddr) throws UnlicensedProductException, InvalidLicenseException {
        Set licenses = this.getLicenses(productName, version, type, ipAddr);
        return this.getBestLicense(licenses);
    }

    public ProductLicense getBestLicense(Set licenses) throws InvalidLicenseException {
        boolean expired;
        ProductLicense bestLicense = null;
        int maxDaysToExpiration = Integer.MIN_VALUE;
        Iterator iter = licenses.iterator();
        while (iter.hasNext()) {
            int daysEffective;
            ProductLicense plicense = (ProductLicense)iter.next();
            int days = plicense.getDaysToExpiration();
            if (days <= maxDaysToExpiration || (daysEffective = plicense.getDaysEffective()) < 0) continue;
            maxDaysToExpiration = days;
            bestLicense = plicense;
        }
        boolean bl = expired = maxDaysToExpiration < 0;
        if (expired) {
            ProductLicense pl = (ProductLicense)licenses.iterator().next();
            String productName = pl.getProductName();
            String versionSpec = pl.getVersionSpec();
            throw new InvalidLicenseException(productName, versionSpec, maxDaysToExpiration);
        }
        return bestLicense;
    }

    public Set getEffectiveLicenses(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        Set licenses = this.getLicenses(productName, version);
        return this.getEffectiveLicenses(licenses);
    }

    public Set getEffectiveLicenses(Set licenses) throws InvalidLicenseException {
        HashSet<ProductLicense> effective = new HashSet<ProductLicense>();
        int maxDaysToExpiration = Integer.MIN_VALUE;
        Iterator iter = licenses.iterator();
        while (iter.hasNext()) {
            int daysEffective;
            int days;
            ProductLicense plicense = (ProductLicense)iter.next();
            if (plicense.isEffective()) {
                effective.add(plicense);
                continue;
            }
            if (effective.size() != 0 || (days = plicense.getDaysToExpiration()) <= maxDaysToExpiration || (daysEffective = plicense.getDaysEffective()) < 0) continue;
            maxDaysToExpiration = days;
        }
        if (effective.size() == 0) {
            ProductLicense pl = (ProductLicense)licenses.iterator().next();
            String productName = pl.getProductName();
            String versionSpec = pl.getVersionSpec();
            throw new InvalidLicenseException(productName, versionSpec, maxDaysToExpiration);
        }
        return effective;
    }

    public String checkLicenseValidity(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        ProductLicense bestMatch = this.getBestLicense(productName, version);
        int daysToExpire = bestMatch.getDaysToExpiration();
        return ProductLicenses.getEffectivityInfo(productName, version, daysToExpire, 10);
    }

    public String checkLicenseValidity(String productName, String version, int nUnits) throws UnlicensedProductException, InvalidLicenseException {
        Set effective = this.getEffectiveLicenses(productName, version);
        int maxDaysToExpiration = Integer.MIN_VALUE;
        int totalAvailable = 0;
        Iterator iter = effective.iterator();
        while (iter.hasNext()) {
            int daysEffective;
            int days;
            ProductLicense plicense = (ProductLicense)iter.next();
            if (totalAvailable != Integer.MAX_VALUE) {
                int units = plicense.getNumberOfUnits();
                totalAvailable = units != Integer.MAX_VALUE ? (totalAvailable += units) : Integer.MAX_VALUE;
            }
            if ((days = plicense.getDaysToExpiration()) <= maxDaysToExpiration || (daysEffective = plicense.getDaysEffective()) < 0) continue;
            maxDaysToExpiration = days;
        }
        if (nUnits > totalAvailable) {
            throw new InvalidLicenseException(productName, version, LicensePlugin.Util.getString("ERR.003.016.0037", new Object[]{new Integer(nUnits), new Integer(totalAvailable)}));
        }
        return ProductLicenses.getEffectivityInfo(productName, version, maxDaysToExpiration, 10);
    }

    public String checkLicenseValidity(String productName, String version, String type, String ipAddr) throws UnlicensedProductException, InvalidLicenseException {
        ProductLicense bestMatch = this.getBestLicense(productName, version, type, ipAddr);
        int daysToExpire = bestMatch.getDaysToExpiration();
        return ProductLicenses.getEffectivityInfo(productName, version, daysToExpire, 10);
    }

    public String checkLicenseValidity(String productName, String version, boolean checkIP) throws UnlicensedProductException, InvalidLicenseException {
        if (checkIP) {
            String ip = null;
            try {
                ip = ProductLicense.getLocalHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0038"));
            }
            return this.checkLicenseValidity(productName, version, null, ip);
        }
        return this.checkLicenseValidity(productName, version);
    }

    private static String getEffectivityInfo(String productName, String version, int daysToExpire, int limit) {
        if (daysToExpire > limit || expireWarned) {
            return "";
        }
        String msg = null;
        if (Platform.getProduct() == null) {
            msg = LicensePlugin.Util.getString("ProductLicenses.MetaMatrix_license_for_product");
        } else {
            String vendor = Platform.getProduct().getProperty("ownerName");
            msg = LicensePlugin.Util.getString("ProductLicenses.vendorLicenseForProduct", (Object)vendor);
        }
        StringBuffer buffer = new StringBuffer(msg);
        buffer.append(productName);
        buffer.append(LicensePlugin.Util.getString("ProductLicenses.version"));
        buffer.append(version);
        if (daysToExpire == 0) {
            buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_today"));
            expireWarned = true;
        } else if (daysToExpire > 0) {
            if (daysToExpire == 1) {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_in_1_day"));
                expireWarned = true;
            } else {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_in") + daysToExpire + LicensePlugin.Util.getString("ProductLicenses.days"));
                expireWarned = true;
            }
        } else if (daysToExpire != Integer.MIN_VALUE) {
            if (daysToExpire == -1) {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expired_1_day_ago"));
            } else {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expired") + -daysToExpire + LicensePlugin.Util.getString("ProductLicenses.days_ago"));
            }
        } else {
            buffer.append(LicensePlugin.Util.getString("ProductLicenses.has_not_yet_become_effective"));
        }
        return buffer.toString();
    }

    public String getEffectivityMessageForAboutDialog(String productName, String version) {
        ProductLicense bestMatch = null;
        try {
            bestMatch = this.getBestLicense(productName, version);
        }
        catch (Exception e) {
            System.err.println("Could not get license. ");
            return "";
        }
        int daysToExpire = bestMatch.getDaysToExpiration();
        int limit = 10;
        if (daysToExpire > limit) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(LicensePlugin.Util.getString("ProductLicenses.license_text"));
        if (daysToExpire == 0) {
            buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_today"));
        } else if (daysToExpire > 0) {
            if (daysToExpire == 1) {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_in_1_day"));
            } else {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expires_in") + daysToExpire + LicensePlugin.Util.getString("ProductLicenses.days"));
            }
        } else if (daysToExpire != Integer.MIN_VALUE) {
            if (daysToExpire == -1) {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expired_1_day_ago"));
            } else {
                buffer.append(LicensePlugin.Util.getString("ProductLicenses.expired") + -daysToExpire + LicensePlugin.Util.getString("ProductLicenses.days_ago"));
            }
        } else {
            buffer.append(LicensePlugin.Util.getString("ProductLicenses.has_not_yet_become_effective"));
        }
        return buffer.toString();
    }

    public void removeLicense(ProductLicense license) {
        if (license != null) {
            this.removeLicense(license.getUUID());
        }
    }

    public void removeLicense(String uuid) {
        this.productLicenses.remove(uuid);
    }

    public void setLicenses(List productLicenses) {
        Iterator iter = productLicenses.iterator();
        while (iter.hasNext()) {
            ProductLicense productLicense = (ProductLicense)iter.next();
            this.addLicense(productLicense);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Product licenses...");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            buffer.append("\n    " + ((ProductLicense)iter.next()).toString());
        }
        return buffer.toString();
    }

    public String toString(String productName) {
        StringBuffer buffer = new StringBuffer();
        TreeSet products = null;
        try {
            products = this.getLicenses(productName);
        }
        catch (Exception e) {
            products = new TreeSet();
        }
        buffer.append("  Product '" + productName + "' has " + products.size() + " licenses");
        Iterator iter = products.iterator();
        while (iter.hasNext()) {
            buffer.append("\n    " + ((ProductLicense)iter.next()).toString());
        }
        return buffer.toString();
    }

    public String toStringVerbose() {
        StringBuffer buffer = new StringBuffer("Product licenses...");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            buffer.append("\n    " + ((ProductLicense)iter.next()).toStringVerbose());
        }
        return buffer.toString();
    }

    public String toStringVerbose(String productName) {
        StringBuffer buffer = new StringBuffer();
        TreeSet products = null;
        try {
            products = this.getLicenses(productName);
        }
        catch (Exception e) {
            products = new TreeSet();
        }
        buffer.append("  Product '" + productName + "' has " + products.size() + " licenses");
        Iterator iter = products.iterator();
        while (iter.hasNext()) {
            buffer.append("\n  " + ((ProductLicense)iter.next()).toStringVerbose());
        }
        return buffer.toString();
    }

    public static boolean versionMatches(String version, String versionSpec) {
        if (version.indexOf(42) >= 0) {
            throw new IllegalArgumentException("Wildcard spec not allowed in application version.");
        }
        if (version.equals(versionSpec)) {
            return true;
        }
        int splatPos = versionSpec.indexOf(42);
        if (splatPos < 0) {
            return false;
        }
        int dotPos2 = splatPos - 1;
        int dotPos1 = version.indexOf(46);
        return version.substring(0, dotPos1).equals(versionSpec.substring(0, dotPos2));
    }

    public static ProductLicenses example(int key) {
        ProductLicenses licenses = new ProductLicenses();
        for (int k = 0; k <= key; ++k) {
            licenses.addLicense(ProductLicense.example(key));
        }
        return licenses;
    }

    public static void main(String[] args) throws Exception {
        String ipCheck;
        if (args.length != 0 && args[0].equals("help")) {
            System.out.println("\nusage: java com.metamatrix.common.license.ProductLicenses [fileName] [ipCheck]\n");
            System.out.println("  where ");
            System.out.println("    fileName is name of file to output results to");
            System.out.println("             (default is to write to stdout)");
            System.out.println("    ipCheck  is IP address to check");
            System.out.println("             (default is to check localhost)");
            System.exit(0);
        }
        String filename = args.length > 0 && !args[0].equals("-") ? args[0] : null;
        String string = ipCheck = args.length > 1 ? args[1] : IPSet.example(0).getFirstAddress();
        if (ipCheck.equalsIgnoreCase("localhost")) {
            ipCheck = ProductLicense.getLocalHostAddress();
        }
        PrintWriter pw = null;
        pw = filename != null ? new PrintWriter((Writer)new BufferedWriter(new FileWriter(filename)), true) : new PrintWriter(System.out, true);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        pw.println("\nPRODUCT LICENSE TEST\n\nToday's Date " + calendar.getTime());
        ProductLicenses licenses = ProductLicenses.createProductLicenses(calendar);
        ProductLicenses.printLicenseInfos(licenses, pw);
        ProductLicenses.testValidities(licenses, pw);
        ProductLicenses.testValidities(licenses, ipCheck, pw);
        if (filename != null) {
            pw.close();
        }
    }

    private static ProductLicenses createProductLicenses(Calendar calendar) {
        ProductLicenses licenses = new ProductLicenses();
        ProductLicense[] license = new ProductLicense[]{new ProductLicense(ProductLicense.PRODUCT_NAMES[0], "2.0"), new ProductLicense(ProductLicense.PRODUCT_NAMES[0], "2.1"), new ProductLicense(ProductLicense.PRODUCT_NAMES[0], "2.*"), new ProductLicense(ProductLicense.PRODUCT_NAMES[1], "2.0"), new ProductLicense(ProductLicense.PRODUCT_NAMES[1], "2.1"), new ProductLicense(ProductLicense.PRODUCT_NAMES[1], "2.*"), new ProductLicense(ProductLicense.PRODUCT_NAMES[2], "2.0"), new ProductLicense(ProductLicense.PRODUCT_NAMES[2], "2.1"), new ProductLicense(ProductLicense.PRODUCT_NAMES[2], "2.*"), new ProductLicense(ProductLicense.PRODUCT_NAMES[0], "9.0")};
        int effectiveDelta = -10;
        ProductLicenses.setDateDelta(license[0], calendar, 1, 0, effectiveDelta);
        ProductLicenses.setDateDelta(license[1], calendar, 5, 1, effectiveDelta);
        ProductLicenses.setDateDelta(license[2], calendar, 5, -1, effectiveDelta);
        ProductLicenses.setDateDelta(license[3], calendar, 5, 7, effectiveDelta);
        ProductLicenses.setDateDelta(license[4], calendar, 5, -7, effectiveDelta);
        ProductLicenses.setDateDelta(license[5], calendar, 2, 1, effectiveDelta);
        ProductLicenses.setDateDelta(license[6], calendar, 2, -1, effectiveDelta);
        ProductLicenses.setDateDelta(license[7], calendar, 1, 1, effectiveDelta);
        ProductLicenses.setDateDelta(license[8], calendar, 1, -1, effectiveDelta);
        ProductLicenses.setDateDelta(license[9], calendar, 5, 25, -30);
        for (int k = 0; k < license.length; ++k) {
            if (!license[k].getProductName().equals("Modeler")) {
                license[k].setIPSet(IPSet.example(k % 3));
            }
            if (k == license.length - 1) {
                IPSet ipSet = new IPSet("localhost");
                try {
                    ipSet.addAddress(ProductLicense.getLocalHostAddress());
                    license[k].setIPSet(ipSet);
                }
                catch (UnknownHostException e) {
                    System.err.println("Could not set local host IP address. ");
                }
            }
            licenses.addLicense(license[k]);
        }
        return licenses;
    }

    private static void testValidities(ProductLicenses licenses, PrintWriter pw) throws Exception {
        pw.println("\n\nTEST EXPIRATION...\n");
        String[] versions = new String[]{"2.0", "2.1", "3.0"};
        for (int j = 0; j < ProductLicense.PRODUCT_NAMES.length; ++j) {
            for (int k = 0; k < versions.length; ++k) {
                ProductLicenses.testValidity(licenses, ProductLicense.PRODUCT_NAMES[j], versions[k], pw);
            }
        }
        ProductLicenses.testValidity(licenses, ProductLicense.PRODUCT_NAMES[0], "9.0", pw);
        ProductLicenses.testValidity(licenses, "Dummy", "2.0", pw);
    }

    private static void testValidity(ProductLicenses licenses, String productName, String version, PrintWriter pw) throws Exception {
        pw.println("\nProduct " + productName + " version " + version + "...");
        try {
            int daysToExpire = licenses.getBestLicense(productName, version).getDaysToExpiration();
            pw.println("  Is expired?  " + (daysToExpire < 0) + "  [Max days to expiration: " + daysToExpire + "]");
            String info = licenses.checkLicenseValidity(productName, version);
            if (info.length() > 0) {
                pw.println("  Validity check info string:\n  '" + info + "'");
            } else {
                pw.println("  License is valid.");
            }
        }
        catch (UnlicensedProductException e) {
            pw.println("  UnlicensedProductException: " + e.getMessage());
        }
        catch (InvalidLicenseException e) {
            pw.println("  InvalidLicenseException: " + e.getMessage());
        }
    }

    private static void testValidities(ProductLicenses licenses, String ip, PrintWriter pw) throws Exception {
        pw.println("\n\nTEST EXPIRATION for IP ADDRESS " + ip + "...\n");
        String[] versions = new String[]{"2.0", "2.1", "3.0"};
        for (int j = 0; j < ProductLicense.PRODUCT_NAMES.length; ++j) {
            for (int k = 0; k < versions.length; ++k) {
                ProductLicenses.testValidity(licenses, ProductLicense.PRODUCT_NAMES[j], versions[k], ip, pw);
            }
        }
        ProductLicenses.testValidity(licenses, ProductLicense.PRODUCT_NAMES[0], "9.0", ip, pw);
        ProductLicenses.testValidity(licenses, "Dummy", "2.0", ip, pw);
    }

    private static void testValidity(ProductLicenses licenses, String productName, String version, String ip, PrintWriter pw) throws Exception {
        String info;
        pw.println("\nProduct " + productName + " version " + version + "...");
        try {
            int daysToExpire = licenses.getBestLicense(productName, version, null, ip).getDaysToExpiration();
            pw.println("  Is expired?  " + (daysToExpire < 0) + "  [Max days to expiration: " + daysToExpire + "]");
            info = licenses.checkLicenseValidity(productName, version, null, ip);
            if (info.length() > 0) {
                pw.println("  Validity check info string for IP " + ip + ":\n  '" + info + "'");
            } else {
                pw.println("  License is valid for IP " + ip + ".");
            }
        }
        catch (UnlicensedProductException e) {
            pw.println("  UnlicensedProductException: " + e.getMessage());
        }
        catch (InvalidLicenseException e) {
            pw.println("  InvalidLicenseException: " + e.getMessage());
        }
        try {
            info = licenses.checkLicenseValidity(productName, version, true);
            if (info.length() > 0) {
                pw.println("  Validity check info string for local IP:\n  '" + info + "'");
            } else {
                pw.println("  License is valid.");
            }
        }
        catch (UnlicensedProductException e) {
            pw.println("  UnlicensedProductException: " + e.getMessage());
        }
        catch (InvalidLicenseException e) {
            pw.println("  InvalidLicenseException: " + e.getMessage());
        }
    }

    private static void setDateDelta(ProductLicense license, Calendar calendar, int calendarConstant, int increment, int effectiveDelta) {
        calendar.add(calendarConstant, increment);
        license.setExpirationDate(calendar.getTime());
        calendar.add(5, effectiveDelta);
        license.setIssuanceDate(calendar.getTime());
        license.setEffectiveDate();
        calendar.add(5, -effectiveDelta);
        calendar.add(calendarConstant, -increment);
    }

    private static void printLicenseInfos(ProductLicenses licenses, PrintWriter pw) {
        pw.println("\n\nPRODUCT LICENSES...\n");
        Iterator iter = licenses.iterator();
        while (iter.hasNext()) {
            ProductLicense license = (ProductLicense)iter.next();
            ProductLicenses.printLicenseInfo(license, pw);
        }
    }

    private static void printLicenseInfo(ProductLicense license, PrintWriter pw) {
        pw.println("\nProduct " + license.getProductName() + " version " + license.getVersionSpec() + "...");
        pw.println("  UUID             " + license.getUUID());
        pw.println("  Type             " + license.getType());
        pw.println("  Issuance   Date  " + license.getIssuanceDate());
        pw.println("  Expiration Date  " + license.getExpirationDate());
        pw.println("  Effective  Date  " + license.getEffectiveDate());
        pw.println("    -- Number of days until expiration: " + license.getDaysToExpiration() + "\t [expired?   " + license.isExpired() + "]");
        pw.println("    -- Number of days effective       : " + license.getDaysEffective() + "\t [effective? " + license.isEffective() + "]");
        pw.println("  Number of Units  " + license.getNumberOfUnits());
        pw.println("  IP Addresses     " + license.getIPSet());
    }
}

