/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.util;

import com.metamatrix.license.LicensePlugin;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HexInputStream
extends FilterInputStream {
    public HexInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int b0 = this.readHexValue();
        if (b0 == -1) {
            return -1;
        }
        int b1 = this.readHexValue();
        if (b1 == -1) {
            throw new IOException(LicensePlugin.Util.getString("ERR.003.016.0045"));
        }
        return (b0 << 4 | b1) & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                if (b == null) continue;
                b[off + i] = (byte)c;
            }
        }
        catch (IOException ee) {
            // empty catch block
        }
        return i;
    }

    private int readHexValue() throws IOException {
        int b;
        block20: while (true) {
            b = this.in.read();
            switch (b) {
                case -1: {
                    return -1;
                }
                case 0: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block20;
                }
                case 48: {
                    return 0;
                }
                case 49: {
                    return 1;
                }
                case 50: {
                    return 2;
                }
                case 51: {
                    return 3;
                }
                case 52: {
                    return 4;
                }
                case 53: {
                    return 5;
                }
                case 54: {
                    return 6;
                }
                case 55: {
                    return 7;
                }
                case 56: {
                    return 8;
                }
                case 57: {
                    return 9;
                }
                case 65: 
                case 97: {
                    return 10;
                }
                case 66: 
                case 98: {
                    return 11;
                }
                case 67: 
                case 99: {
                    return 12;
                }
                case 68: 
                case 100: {
                    return 13;
                }
                case 69: 
                case 101: {
                    return 14;
                }
                case 70: 
                case 102: {
                    return 15;
                }
            }
            break;
        }
        throw new IOException(LicensePlugin.Util.getString("HexInputStream.Illegal_char_{0}_in_hex_stream_1", b));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: HexInputStream fileName");
            System.exit(0);
        }
        String fileName = args[0];
        FileInputStream fis = new FileInputStream(fileName);
        HexInputStream his = new HexInputStream(fis);
        byte[] bytes = new byte[]{};
        byte[] bytesRead = new byte[50];
        int numBytesRead = 0;
        while ((numBytesRead = his.read(bytesRead)) != -1) {
            byte[] newBytes = new byte[bytes.length + numBytesRead];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            System.arraycopy(bytesRead, 0, newBytes, bytes.length, numBytesRead);
            bytes = newBytes;
        }
        his.close();
        System.out.println(bytes.length);
        if (fileName.equalsIgnoreCase("hexall.txt")) {
            System.out.println("Bytes from file...");
            for (int k = 0; k < bytes.length; ++k) {
                System.out.println(bytes[k] + " ");
            }
        }
    }
}

