/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.xml;

import com.metamatrix.core.util.AssertionException;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.Customer;
import com.metamatrix.license.domain.IPSet;
import com.metamatrix.license.domain.IPSets;
import com.metamatrix.license.domain.License;
import com.metamatrix.license.domain.LicenseInfo;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.domain.ProductLicenses;
import com.metamatrix.license.domain.RangeSet;
import com.metamatrix.license.domain.ReferenceSet;
import com.metamatrix.license.xml.LicenseReader;
import com.metamatrix.license.xml.LicenseXMLTags;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LicenseWriter
implements LicenseXMLTags {
    private Document xmlDoc;
    private Element root;
    private Namespace namespace;
    private License license;

    public LicenseWriter() {
    }

    public LicenseWriter(License license) {
        this.setLicense(license);
    }

    public Document getXMLDocument() {
        return this.xmlDoc;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void init() throws IllegalNameException, JDOMException {
        this.namespace = Namespace.getNamespace((String)"MetaMatrix", (String)"http://www.metamatrix.com");
        this.root = new Element("license", this.namespace);
        this.xmlDoc = new Document(this.root);
        this.root = this.xmlDoc.getRootElement();
    }

    public Document loadLicense() throws Exception {
        this.root.setAttribute("version", this.license.getVersion());
        this.loadLicenseInfo(this.root, this.license.getLicenseInfo());
        this.loadCustomer(this.root, this.license.getCustomer());
        this.loadIPSets(this.root, this.license.getIPSets());
        this.loadProductLicense(this.root, this.license.getProductLicenses());
        return this.xmlDoc;
    }

    private void loadLicenseInfo(Element startElement, LicenseInfo info) throws Exception {
        Element einfo = new Element("licenseInfo", this.namespace);
        startElement.addContent((Content)einfo);
        einfo.addContent((Content)new Element("licenseType", this.namespace).setText(this.getStringText(info.getLicenseType())));
        einfo.addContent((Content)new Element("createdBy", this.namespace).setText(this.getStringText(info.getCreatedBy())));
        einfo.addContent((Content)new Element("created", this.namespace).setText(this.getDateText(info.getCreated())));
        einfo.addContent((Content)new Element("lastUpdatedBy", this.namespace).setText(this.getStringText(info.getLastUpdatedBy())));
        einfo.addContent((Content)new Element("lastUpdated", this.namespace).setText(this.getDateText(info.getLastUpdated())));
        einfo.addContent((Content)new Element("signature", this.namespace).setText(this.getStringText(info.getSignature())));
    }

    private void loadCustomer(Element startElement, Customer cust) throws Exception {
        Element ecust = new Element("customer", this.namespace);
        startElement.addContent((Content)ecust);
        ecust.addContent((Content)new Element("organization", this.namespace).setText(this.getStringText(cust.getOrganization())));
        ecust.addContent((Content)new Element("organizationalUnit", this.namespace).setText(this.getStringText(cust.getOrganizationalUnit())));
    }

    private void loadIPSets(Element startElement, IPSets ipSets) throws Exception {
        if (ipSets.size() == 0) {
            return;
        }
        Element eipSets = new Element("ipSets", this.namespace);
        startElement.addContent((Content)eipSets);
        Iterator iter = ipSets.iterator();
        while (iter.hasNext()) {
            IPSet ipSet = (IPSet)iter.next();
            this.loadIPSet(eipSets, ipSet);
        }
    }

    private void loadProductLicense(Element startElement, ProductLicenses licenses) throws Exception {
        if (licenses.size() == 0) {
            return;
        }
        Element elicenses = new Element("productLicenses", this.namespace);
        startElement.addContent((Content)elicenses);
        this.loadAllProductLicenseInstances(elicenses, licenses);
    }

    public void loadAllProductLicenseInstances(Element startElement, ProductLicenses licenses) throws Exception {
        Set products = licenses.getLicenses();
        if (products.size() == 0) {
            return;
        }
        Element productElement = null;
        Iterator iter = products.iterator();
        while (iter.hasNext()) {
            ProductLicense license = (ProductLicense)iter.next();
            productElement = new Element("product", this.namespace);
            productElement.setAttribute("name", this.getStringText(license.getProductName()));
            productElement.setAttribute("version", this.getStringText(license.getVersionSpec()));
            startElement.addContent((Content)productElement);
            this.loadProductLicense(productElement, license);
        }
    }

    private void loadProductLicense(Element startElement, ProductLicense license) throws Exception {
        Element plicense = new Element("productLicense", this.namespace);
        startElement.addContent((Content)plicense);
        plicense.setAttribute("uuid", this.getStringText(license.getUUID()));
        plicense.setAttribute("type", this.getStringText(license.getType()));
        plicense.addContent((Content)new Element("issuanceDate", this.namespace).setText(this.getDateText(license.getIssuanceDate())));
        plicense.addContent((Content)new Element("effectiveDate", this.namespace).setText(this.getDateText(license.getEffectiveDate())));
        plicense.addContent((Content)new Element("expirationDate", this.namespace).setText(this.getDateText(license.getExpirationDate())));
        plicense.addContent((Content)new Element("numberOfUnits", this.namespace).setText(this.getIntText(license.getNumberOfUnits())));
        this.loadIPSet(plicense, license.getIPSet());
    }

    private void loadIPSet(Element startElement, IPSet ipSet) throws Exception {
        Element eipSet = new Element("ipSet", this.namespace);
        startElement.addContent((Content)eipSet);
        if (ipSet.equals(IPSet.UNDEFINED)) {
            eipSet.setText(IPSet.UNDEFINED.getName());
            return;
        }
        if (ipSet.getName() != null && ipSet.getName().length() > 0) {
            eipSet.setAttribute("name", ipSet.getName());
        }
        Iterator addrIter = ipSet.getSingleIPs().iterator();
        while (addrIter.hasNext()) {
            String saddr = (String)addrIter.next();
            Element e1 = new Element("ipAddress", this.namespace);
            e1.setAttribute("address", this.getStringText(saddr));
            eipSet.addContent((Content)e1);
        }
        Iterator rangeIter = ipSet.getRanges().iterator();
        while (rangeIter.hasNext()) {
            RangeSet rs1 = (RangeSet)rangeIter.next();
            Element re1 = new Element("ipRange", this.namespace);
            re1.setAttribute("startAddress", this.getStringText((String)rs1.getFirst()));
            re1.setAttribute("endAddress", this.getStringText((String)rs1.getLast()));
            eipSet.addContent((Content)re1);
        }
        Iterator inclIter = ipSet.getIncludeSets().iterator();
        while (inclIter.hasNext()) {
            ReferenceSet rs2 = (ReferenceSet)inclIter.next();
            Element re2 = new Element("ipSetRef", this.namespace);
            re2.setAttribute("name", this.getStringText(rs2.getName()));
            eipSet.addContent((Content)re2);
        }
    }

    private String getDateText(Date date) {
        if (date == null) {
            return "";
        }
        return License.dateToString(date);
    }

    private String getStringText(String str) {
        return str != null ? str : "";
    }

    private String getIntText(int value) {
        return String.valueOf(value);
    }

    public static void writeDocument(Document doc, OutputStream stream, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            String msg = LicensePlugin.Util.getString("ERR.003.016.0051");
            throw new AssertionException(msg);
        }
        if (stream == null) {
            String msg = LicensePlugin.Util.getString("ERR.003.016.0052");
            throw new AssertionException(msg);
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat((String)indent, (boolean)newlines));
        outputter.output(doc, stream);
    }

    public static void main(String[] args) throws Exception {
        String outFileName;
        String fileName = args[0];
        String string = outFileName = args.length > 1 ? args[1] : null;
        if (outFileName != null && outFileName.equals("-doc")) {
            LicenseWriter.readWrite(fileName, null);
        } else {
            LicenseWriter.readWrite(fileName, new PrintWriter(System.out, true));
            if (outFileName != null) {
                LicenseWriter.readWrite(fileName, new PrintWriter((Writer)new FileWriter(outFileName), true));
                LicenseWriter.readWrite(outFileName, new PrintWriter(System.out, true));
            }
        }
    }

    public static void readWrite(String inFile, PrintWriter pw) throws Exception {
        Format format = JdomHelper.getFormat((String)"    ", (boolean)true);
        format.setTextMode(Format.TextMode.NORMALIZE);
        XMLOutputter outputter = new XMLOutputter(format);
        LicenseReader reader = new LicenseReader(inFile);
        License license = null;
        try {
            reader.init();
            license = reader.loadLicense();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pw == null) {
            System.out.println("\nDocument structure loaded from file");
            JdomHelper.print((PrintStream)System.out, (Document)reader.getXMLDocument());
        }
        System.out.println("\nDocument output loaded from file");
        outputter.output(reader.getXMLDocument(), (Writer)new PrintWriter(System.out, true));
        LicenseWriter writer = new LicenseWriter(license);
        Document document = null;
        try {
            writer.init();
            document = writer.loadLicense();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pw == null) {
            System.out.println("\nDocument structure after loading from license object");
            JdomHelper.print((PrintStream)System.out, (Document)document);
        } else {
            System.out.println("\nDocument output after loading from license object");
            outputter.output(writer.getXMLDocument(), (Writer)pw);
        }
    }
}

