/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.SAXBuilderHelper;
import com.metamatrix.internal.core.xml.XMLVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JdomHelper {
    private static List results = null;
    private static Element result = null;
    private static int count = 0;
    public static final String DEFAULT_INDENT = "  ";
    public static final boolean DEFAULT_VALIDATION = false;
    public static final int PRE_ORDER_TRAVERSAL = 0;
    public static final int POST_ORDER_TRAVERSAL = 1;
    public static final int LEVEL_ORDER_TRAVERSAL = 2;

    public static Document buildDocument(String filename) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), filename, false);
    }

    public static Document buildDocument(File file) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), file, false);
    }

    public static Document buildDocument(String filename, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), filename, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, String filename, boolean validateXML) throws IOException, JDOMException {
        if (saxDriverClass == null) {
            ArgCheck.isNotNull((Object)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_null_1"));
        }
        if (saxDriverClass.length() == 0) {
            ArgCheck.isNotZeroLength((String)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_zero-length_2"));
        }
        if (filename == null) {
            ArgCheck.isNotNull((Object)filename, (String)CorePlugin.Util.getString("JdomHelper.The_file_name_may_not_be_null_3"));
        }
        if (filename.length() == 0) {
            ArgCheck.isNotZeroLength((String)filename, (String)CorePlugin.Util.getString("JdomHelper.The_file_name_may_not_be_zero-length_4"));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(new File(filename));
    }

    public static Document buildDocument(String saxDriverClass, File file, boolean validateXML) throws IOException, JDOMException {
        if (saxDriverClass == null) {
            ArgCheck.isNotNull((Object)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_null_1"));
        }
        if (saxDriverClass.length() == 0) {
            ArgCheck.isNotZeroLength((String)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_zero-length_2"));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(file);
    }

    public static Document buildDocument(InputStream stream) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, false);
    }

    public static Document buildDocument(InputStream stream, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, InputStream stream, boolean validateXML) throws IOException, JDOMException {
        if (saxDriverClass == null) {
            ArgCheck.isNotNull((Object)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_null_5"));
        }
        if (saxDriverClass.length() == 0) {
            ArgCheck.isNotZeroLength((String)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_zero-length_6"));
        }
        if (stream == null) {
            ArgCheck.isNotNull((Object)stream, (String)CorePlugin.Util.getString("JdomHelper.The_InputStream_may_not_be_null_7"));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(stream);
    }

    public static Document buildDocument(Reader stream) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, false);
    }

    public static Document buildDocument(Reader stream, boolean validateXML) throws IOException, JDOMException {
        return JdomHelper.buildDocument(SAXBuilderHelper.getParserClassName(), stream, validateXML);
    }

    public static Document buildDocument(String saxDriverClass, Reader stream, boolean validateXML) throws IOException, JDOMException {
        if (saxDriverClass == null) {
            ArgCheck.isNotNull((Object)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_null_8"));
        }
        if (saxDriverClass.length() == 0) {
            ArgCheck.isNotZeroLength((String)saxDriverClass, (String)CorePlugin.Util.getString("JdomHelper.The_SAX_driver_class_name_may_not_be_zero-length_9"));
        }
        if (stream == null) {
            ArgCheck.isNotNull((Object)stream, (String)CorePlugin.Util.getString("JdomHelper.The_InputStream_may_not_be_null_10"));
        }
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(saxDriverClass, validateXML);
        return builder.build(stream);
    }

    public static Document createNewDocument(String rootTag) {
        if (rootTag == null) {
            ArgCheck.isNotNull((Object)rootTag, (String)CorePlugin.Util.getString("JdomHelper.The_root_tag_name_may_not_be_null_11"));
        }
        if (rootTag.length() == 0) {
            ArgCheck.isNotZeroLength((String)rootTag, (String)CorePlugin.Util.getString("JdomHelper.The_root_tag_name_may_not_be_zero-length_12"));
        }
        Element root = new Element(rootTag);
        return new Document(root);
    }

    public static List getDescendents(int traversalMethod, Element parent, final Namespace ns) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_13"));
        }
        if (ns == null) {
            ArgCheck.isNotNull((Object)ns, (String)CorePlugin.Util.getString("JdomHelper.The_Namespace_reference_may_not_be_null_14"));
        }
        results = new LinkedList();
        switch (traversalMethod) {
            case 0: {
                JdomHelper.preOrderTraversal(parent, new XMLVisitor(){

                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
                break;
            }
            case 1: {
                JdomHelper.postOrderTraversal(parent, new XMLVisitor(){

                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
                break;
            }
            case 2: {
                JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

                    public void visit(Object obj) {
                        if (((Element)obj).getNamespace().equals((Object)ns)) {
                            results.add(obj);
                        }
                    }
                });
            }
        }
        return results;
    }

    public static List getDescendents(Element parent) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_15"));
        }
        results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                results.add(obj);
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final String name) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_16"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_null_17"));
        }
        if (name.length() == 0) {
            ArgCheck.isNotZeroLength((String)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_18"));
        }
        results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final Namespace ns) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_19"));
        }
        if (ns == null) {
            ArgCheck.isNotNull((Object)ns, (String)CorePlugin.Util.getString("JdomHelper.The_Namespace_may_not_be_null_20"));
        }
        results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (((Element)obj).getNamespace().equals((Object)ns)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static List getDescendents(Element parent, final String name, final Namespace ns) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_21"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_null_22"));
        }
        if (name.length() == 0) {
            ArgCheck.isNotZeroLength((String)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_23"));
        }
        results = new LinkedList();
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name) && ((Element)obj).getNamespace().equals((Object)ns)) {
                    results.add(obj);
                }
            }
        });
        return results;
    }

    public static int getDescendentCount(Element parent) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_24"));
        }
        count = 0;
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                count++;
            }
        });
        return count;
    }

    public static int getDescendentCount(Element parent, final Namespace ns) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_25"));
        }
        count = 0;
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (((Element)obj).getNamespace().equals((Object)ns)) {
                    count++;
                }
            }
        });
        return count;
    }

    public static int getDescendentCount(Element parent, final String name) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_26"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_null_27"));
        }
        if (name.length() == 0) {
            ArgCheck.isNotZeroLength((String)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_28"));
        }
        count = 0;
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (((Element)obj).getName().equals(name)) {
                    count++;
                }
            }
        });
        return count;
    }

    public static Element findElement(Element parent, final String name) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_29"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_null_30"));
        }
        if (name.length() == 0) {
            ArgCheck.isNotZeroLength((String)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_31"));
        }
        result = null;
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (result != null) {
                    return;
                }
                if (((Element)obj).getName().equals(name)) {
                    result = (Element)obj;
                }
            }
        });
        return result;
    }

    public static Element findElement(Element parent, final String name, final Namespace ns) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_32"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_null_33"));
        }
        if (name.length() == 0) {
            ArgCheck.isNotZeroLength((String)name, (String)CorePlugin.Util.getString("JdomHelper.The_name_may_not_be_zero-length_34"));
        }
        if (ns == null) {
            ArgCheck.isNotNull((Object)ns, (String)CorePlugin.Util.getString("JdomHelper.The_Namespace_reference_may_not_be_null_35"));
        }
        result = null;
        JdomHelper.levelOrderTraversal(parent, new XMLVisitor(){

            public void visit(Object obj) {
                if (result != null) {
                    return;
                }
                if (((Element)obj).getName().equals(name) && ((Element)obj).getNamespace().equals((Object)ns)) {
                    result = (Element)obj;
                }
            }
        });
        return result;
    }

    public static void levelOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_36"));
        }
        if (v == null) {
            ArgCheck.isNotNull((Object)v, (String)CorePlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_37"));
        }
        LinkedList queue = new LinkedList(parent.getChildren());
        while (queue.size() != 0) {
            Element child = (Element)queue.getFirst();
            v.visit(child);
            queue.addAll(child.getChildren());
            queue.removeFirst();
        }
    }

    public static void preOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_38"));
        }
        if (v == null) {
            ArgCheck.isNotNull((Object)v, (String)CorePlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_39"));
        }
        List children = parent.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Element child = (Element)children.get(i);
            v.visit(child);
            JdomHelper.preOrderTraversal(child, v);
        }
    }

    public static void postOrderTraversal(Element parent, XMLVisitor v) {
        if (parent == null) {
            ArgCheck.isNotNull((Object)parent, (String)CorePlugin.Util.getString("JdomHelper.The_JDOM_Element_reference_may_not_be_null_40"));
        }
        if (v == null) {
            ArgCheck.isNotNull((Object)v, (String)CorePlugin.Util.getString("JdomHelper.The_XMLVisitor_reference_may_not_be_null_41"));
        }
        List children = parent.getChildren();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Element child = (Element)children.get(i);
            JdomHelper.postOrderTraversal(child, v);
            v.visit(child);
        }
    }

    public static void write(Document doc, String filename) throws IOException {
        JdomHelper.write(doc, filename, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, String filename, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            ArgCheck.isNotNull((Object)doc, (String)CorePlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_42"));
        }
        if (filename == null) {
            ArgCheck.isNotNull((Object)filename, (String)CorePlugin.Util.getString("JdomHelper.The_filename_may_not_be_null_43"));
        }
        if (filename.length() == 0) {
            ArgCheck.isNotZeroLength((String)filename, (String)CorePlugin.Util.getString("JdomHelper.The_filename_may_not_be_zero-length_44"));
        }
        FileOutputStream out = new FileOutputStream(filename);
        JdomHelper.write(doc, out, indent, newlines);
        out.flush();
        out.close();
    }

    public static void write(Document doc, OutputStream stream) throws IOException {
        JdomHelper.write(doc, stream, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, OutputStream stream, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            ArgCheck.isNotNull((Object)doc, (String)CorePlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_45"));
        }
        if (stream == null) {
            ArgCheck.isNotNull((Object)stream, (String)CorePlugin.Util.getString("JdomHelper.The_OutputStream_reference_may_not_be_null_46"));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        outputter.output(doc, stream);
    }

    public static void write(Document doc, Writer writer) throws IOException {
        JdomHelper.write(doc, writer, DEFAULT_INDENT, true);
    }

    public static void write(Document doc, Writer writer, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            ArgCheck.isNotNull((Object)doc, (String)CorePlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_47"));
        }
        if (writer == null) {
            ArgCheck.isNotNull((Object)writer, (String)CorePlugin.Util.getString("JdomHelper.The_Writer_reference_may_not_be_null_48"));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        outputter.output(doc, writer);
    }

    public static String write(Document doc) throws IOException {
        return JdomHelper.write(doc, DEFAULT_INDENT, true);
    }

    public static String write(Document doc, String indent, boolean newlines) throws IOException {
        if (doc == null) {
            ArgCheck.isNotNull((Object)doc, (String)CorePlugin.Util.getString("JdomHelper.The_Document_reference_may_not_be_null_49"));
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
        StringWriter writer = new StringWriter();
        outputter.output(doc, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static void print(PrintStream stream, Document doc) {
        if (stream == null) {
            ArgCheck.isNotNull((Object)stream, (String)CorePlugin.Util.getString("JdomHelper.The_stream_reference_may_not_be_null_50"));
        }
        stream.println(CorePlugin.Util.getString("JdomHelper.JDOM_Document_tree_51"));
        Element root = doc.getRootElement();
        JdomHelper.print(root, stream, CorePlugin.Util.getString("JdomHelper.___52"));
    }

    private static void print(Element elm, PrintStream stream, String leadingString) {
        stream.println(leadingString + elm.getName());
        Iterator itr = elm.getChildren().iterator();
        while (itr.hasNext()) {
            JdomHelper.print((Element)itr.next(), stream, leadingString + CorePlugin.Util.getString("JdomHelper.___53"));
        }
    }

    public static String getContentValue(Object jdomObject) {
        if (jdomObject == null) {
            return null;
        }
        if (jdomObject instanceof String) {
            return (String)jdomObject;
        }
        if (jdomObject instanceof Element) {
            return ((Element)jdomObject).getText();
        }
        if (jdomObject instanceof Attribute) {
            return ((Attribute)jdomObject).getValue();
        }
        if (jdomObject instanceof Text) {
            return ((Text)jdomObject).getValue();
        }
        if (jdomObject instanceof Namespace) {
            return ((Namespace)jdomObject).getURI();
        }
        if (jdomObject instanceof Comment) {
            return ((Comment)jdomObject).getText();
        }
        if (jdomObject instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)jdomObject).getData();
        }
        return jdomObject.toString();
    }

    public static Format getFormat(String indent, boolean newlines) {
        Format format = Format.getPrettyFormat();
        format.setIndent(indent);
        if (newlines) {
            format.setLineSeparator("\n");
        } else {
            format.setLineSeparator("");
        }
        return format;
    }
}

