/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml;

import com.metamatrix.core.util.ArgCheck;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class XPathHelper {
    public static String getSingleMatchAsString(Reader documentReader, String xpath) throws XPathException, IOException {
        Object o = XPathHelper.getSingleMatch(documentReader, xpath);
        if (o == null) {
            return null;
        }
        if (o instanceof Item) {
            return ((Item)o).getStringValue();
        }
        return o.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSingleMatch(Reader documentReader, String xpath) throws XPathException, IOException {
        ArgCheck.isNotNull((Object)documentReader);
        ArgCheck.isNotNull((Object)xpath);
        try {
            StreamSource s = new StreamSource(documentReader);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            Object object = expr.evaluateSingle((Source)s);
            return object;
        }
        finally {
            documentReader.close();
        }
    }

    public static void validateXpath(String xpath) throws XPathException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        eval.createExpression(xpath);
    }
}

