/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.ElementImport;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PackageImport;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.internal.operation.NamespaceOperations;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class PackageOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;

    private PackageOperations() {
    }

    public static boolean validateElementsPublicOrPrivate(Package package_, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator ownedElements = package_.getOwnedElements().iterator();
        while (ownedElements.hasNext()) {
            VisibilityKind visibility;
            Element ownedElement = (Element)ownedElements.next();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.NamedElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(ownedElement) || (visibility = ((NamedElement)ownedElement).getVisibility()) == null || ((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility) || ((Object)((Object)VisibilityKind.PRIVATE_LITERAL)).equals((Object)visibility)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 22, UML2Plugin.INSTANCE.getString("_UI_Package_ElementsPublicOrPrivate_diagnostic", PackageOperations.getMessageSubstitutions(context, ownedElement, package_)), new Object[]{package_, ownedElement}));
        }
        return result;
    }

    public static Set visibleMembers(Package package_) {
        HashSet visibleMembers = new HashSet();
        PackageOperations.visibleMembersHelper(package_, visibleMembers);
        Iterator allImportedPackages = PackageOperations.allImportedPackagesHelper(package_, new HashSet()).iterator();
        while (allImportedPackages.hasNext()) {
            PackageOperations.visibleMembersHelper((Package)allImportedPackages.next(), visibleMembers);
        }
        return Collections.unmodifiableSet(visibleMembers);
    }

    public static boolean makesVisible(Package package_, NamedElement el) {
        if (PackageOperations.getOwnedMembers(package_).contains((Object)el)) {
            VisibilityKind visibility = el.getVisibility();
            return visibility == null || ((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility);
        }
        Iterator elementImports = package_.getElementImports().iterator();
        while (elementImports.hasNext()) {
            ElementImport elementImport = (ElementImport)elementImports.next();
            if (!PackageOperations.safeEquals(elementImport.getImportedElement(), el)) continue;
            VisibilityKind visibility = elementImport.getVisibility();
            return visibility == null || ((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility);
        }
        Iterator packageImports = package_.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            PackageImport packageImport = (PackageImport)packageImports.next();
            VisibilityKind visibility = packageImport.getVisibility();
            if (visibility != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility)) continue;
            Package importedPackage = packageImport.getImportedPackage();
            return importedPackage != null && importedPackage.visibleMembers().contains(el);
        }
        return false;
    }

    public static boolean mustBeOwned(Package package_) {
        return false;
    }

    protected static Set visibleMembersHelper(Package package_, Set visibleMembers) {
        VisibilityKind visibility;
        Iterator ownedMembers = PackageOperations.getOwnedMembers(package_).iterator();
        while (ownedMembers.hasNext()) {
            PackageableElement ownedMember = (PackageableElement)ownedMembers.next();
            visibility = ownedMember.getVisibility();
            if (visibility != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility)) continue;
            visibleMembers.add(ownedMember);
        }
        Iterator elementImports = package_.getElementImports().iterator();
        while (elementImports.hasNext()) {
            PackageableElement importedElement;
            ElementImport elementImport = (ElementImport)elementImports.next();
            visibility = elementImport.getVisibility();
            if (visibility != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility) || (importedElement = elementImport.getImportedElement()) == null) continue;
            visibleMembers.add(importedElement);
        }
        return visibleMembers;
    }

    protected static Set allImportedPackagesHelper(Package package_, Set allImportedPackages) {
        Iterator packageImports = package_.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            Package importedPackage;
            PackageImport packageImport = (PackageImport)packageImports.next();
            VisibilityKind visibility = packageImport.getVisibility();
            if (visibility != null && !((Object)((Object)VisibilityKind.PUBLIC_LITERAL)).equals((Object)visibility) || (importedPackage = packageImport.getImportedPackage()) == null || allImportedPackages.contains(importedPackage)) continue;
            allImportedPackages.add(importedPackage);
            PackageOperations.allImportedPackagesHelper(importedPackage, allImportedPackages);
        }
        return allImportedPackages;
    }

    public static Package createNestedPackage(Package package_, String name) {
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (PackageOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Package nestedPackage = (Package)package_.createOwnedMember(UML2Package.eINSTANCE.getPackage());
        nestedPackage.setName(name);
        return nestedPackage;
    }

    public static Class createOwnedClass(Package package_, String name, boolean isAbstract) {
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (PackageOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Class ownedClass = (Class)package_.createOwnedMember(UML2Package.eINSTANCE.getClass_());
        ownedClass.setName(name);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Package package_, String name) {
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (PackageOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Enumeration ownedEnumeration = (Enumeration)package_.createOwnedMember(UML2Package.eINSTANCE.getEnumeration());
        ownedEnumeration.setName(name);
        return ownedEnumeration;
    }

    public static PrimitiveType createOwnedPrimitiveType(Package package_, String name) {
        if (package_ == null) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (PackageOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        PrimitiveType ownedPrimitiveType = (PrimitiveType)package_.createOwnedMember(UML2Package.eINSTANCE.getPrimitiveType());
        ownedPrimitiveType.setName(name);
        return ownedPrimitiveType;
    }

    public static EList getNestedPackages(Package package_) {
        UniqueEList nestedPackages = new UniqueEList();
        if (package_ != null) {
            Iterator ownedMembers = package_.getOwnedMembers().iterator();
            while (ownedMembers.hasNext()) {
                NamedElement ownedMember = (NamedElement)ownedMembers.next();
                java.lang.Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Package");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(ownedMember)) continue;
                nestedPackages.add((Object)ownedMember);
            }
        }
        return nestedPackages;
    }

    public static EList getOwnedTypes(Package package_) {
        UniqueEList ownedTypes = new UniqueEList();
        if (package_ != null) {
            Iterator ownedMembers = package_.getOwnedMembers().iterator();
            while (ownedMembers.hasNext()) {
                NamedElement ownedMember = (NamedElement)ownedMembers.next();
                java.lang.Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Type");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(ownedMember)) continue;
                ownedTypes.add((Object)ownedMember);
            }
        }
        return ownedTypes;
    }

    public static EList getOwnedMembers(Package package_) {
        UniqueEList ownedMembers = new UniqueEList();
        if (package_ != null) {
            ownedMembers.addAll((Collection)package_.getOwnedRules());
            ownedMembers.addAll((Collection)package_.getOwnedMembers());
        }
        return ownedMembers;
    }

    public static Set getNamesOfMember(Package package_, NamedElement element) {
        HashSet<String> namesOfMember = new HashSet<String>();
        if (PackageOperations.getOwnedMembers(package_).contains((Object)element)) {
            String name = element.getName();
            if (!PackageOperations.isEmpty(name)) {
                namesOfMember.add(name);
            }
        } else {
            return NamespaceOperations.getNamesOfMember(package_, element);
        }
        return Collections.unmodifiableSet(namesOfMember);
    }

    public static Set importMembers(Package package_, Set imps) {
        HashSet<PackageableElement> importMembers = new HashSet<PackageableElement>();
        EList ownedMembers = PackageOperations.getOwnedMembers(package_);
        Iterator excludeCollisions = package_.excludeCollisions(imps).iterator();
        block0: while (excludeCollisions.hasNext()) {
            PackageableElement excludeCollision = (PackageableElement)excludeCollisions.next();
            Iterator i = ownedMembers.iterator();
            while (i.hasNext()) {
                if (!excludeCollision.isDistinguishableFrom((PackageableElement)i.next(), package_)) continue block0;
            }
            importMembers.add(excludeCollision);
        }
        return Collections.unmodifiableSet(importMembers);
    }
}

