/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EcoreXMLSchemaBuilder
extends MapBuilder {
    public static final String OPTION_TO_ENFORCE_LOWERBOUND = "ENFORCE_LOWERBOUND";
    public static final String OPTION_USE_ENCODED_ATTRIBUTE_STYLE = "USE_ENCODE_ATTRIBUTE_STYLE";
    protected static final String EMF_SCHEMA_URI = "http://org.eclipse.emf/xsd";
    protected static final String EMF_SCHEMA_PREFIX = "emf";
    protected static final String EMF_SCHEMA_NAME = "EMF.xsd";
    protected static final String REFERENCE_TYPE_NAME = "string";
    protected XSDSchema xsdSchema;
    protected XSDSchema emfSchema;
    protected EPackage ePackage;
    protected Map ecoreToSchemaName;
    protected Map ePackageToXSDSchemaMap = new HashMap();
    protected Map ePackageToNsPrefixMap = new HashMap();
    protected QNameMap qNameMap;
    protected boolean minimizedXMI;
    protected boolean useEncodedAttributeStyle;
    protected boolean enforceLowerBound;
    protected List rootClasses;

    public EcoreXMLSchemaBuilder() {
        this.ePackageToNsPrefixMap.put(null, "xsd");
    }

    public Collection generate(EPackage ePackage) {
        return this.generate(ePackage, null);
    }

    public Collection generate(EPackage ePackage, QNameMap qNameMap) {
        this.qNameMap = qNameMap;
        this.addInput((EObject)ePackage);
        this.ePackage = ePackage;
        this.createSchema();
        this.processEnums();
        this.processClasses();
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(this.xsdSchema);
        if (this.emfSchema != null) {
            result.add(this.emfSchema);
        }
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        Iterator i = this.xsdComponentToEModelElementMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.addDocumentation((XSDConcreteComponent)entry.getKey(), (EModelElement)entry.getValue());
        }
        return result;
    }

    protected String getUniqueNsPrefix(EPackage ePackage) {
        String nsPrefix;
        if (this.ePackageToNsPrefixMap.containsKey(ePackage)) {
            return (String)this.ePackageToNsPrefixMap.get(ePackage);
        }
        String uniqueNsPrefix = nsPrefix = ePackage.getNsPrefix();
        int i = 1;
        while (this.ePackageToNsPrefixMap.values().contains(uniqueNsPrefix)) {
            uniqueNsPrefix = nsPrefix + "_" + i;
            ++i;
        }
        this.ePackageToNsPrefixMap.put(ePackage, uniqueNsPrefix);
        return uniqueNsPrefix;
    }

    protected void createSchema() {
        this.xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.addOutput(this.xsdSchema);
        this.xsdSchema.setTargetNamespace(this.ePackage.getNsURI());
        this.xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(this.getUniqueNsPrefix(this.ePackage), this.xsdSchema.getTargetNamespace());
        namespaces.put(this.xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.map(this.xsdSchema, (EModelElement)this.ePackage);
    }

    protected void createEMFSchema() {
        this.emfSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.emfSchema.setTargetNamespace(EMF_SCHEMA_URI);
        this.emfSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = this.emfSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(EMF_SCHEMA_PREFIX, this.emfSchema.getTargetNamespace());
        namespaces.put(this.emfSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        XSDSimpleTypeDefinition list = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        list.setName(REFERENCE_TYPE_NAME);
        XSDSimpleTypeDefinition union = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        union.getMemberTypeDefinitions().add((Object)this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("IDREF"));
        union.getMemberTypeDefinitions().add((Object)this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("QName"));
        union.getMemberTypeDefinitions().add((Object)this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("anyURI"));
        list.setItemTypeDefinition(union);
        list.getContents().add((Object)union);
        this.emfSchema.getContents().add((Object)list);
    }

    protected void addEMFSchema() {
    }

    protected XSDTypeDefinition typeInOtherSchema(EClassifier classifier) {
        String nsPrefix;
        EPackage typePkg = classifier.getEPackage();
        Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
        if (namespaces.get(nsPrefix = this.getUniqueNsPrefix(typePkg)) == null) {
            namespaces.put(nsPrefix, typePkg.getNsURI());
            this.addImport(typePkg.getNsURI(), this.getName((ENamedElement)typePkg) + ".xsd");
            this.createOtherSchema(typePkg);
        }
        XSDSchema otherXSDSchema = (XSDSchema)this.ePackageToXSDSchemaMap.get(typePkg);
        return otherXSDSchema.resolveTypeDefinition(this.getName((ENamedElement)classifier));
    }

    protected void addImport(String namespace, String schemaLocation) {
        XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
        xsdImport.setNamespace(namespace);
        xsdImport.setSchemaLocation(schemaLocation);
        this.xsdSchema.getContents().add(0, (Object)xsdImport);
    }

    protected void createOtherSchema(EPackage ePackage) {
        XSDSchema otherSchema = XSDFactory.eINSTANCE.createXSDSchema();
        otherSchema.setTargetNamespace(ePackage.getNsURI());
        otherSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = otherSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(this.getUniqueNsPrefix(ePackage), otherSchema.getTargetNamespace());
        namespaces.put(otherSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.ePackageToXSDSchemaMap.put(ePackage, otherSchema);
    }

    protected void processClasses() {
        Iterator classifiers = this.ePackage.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            EClassifier classifier = (EClassifier)classifiers.next();
            if (!(classifier instanceof EClass)) continue;
            this.processClass((EClass)classifier);
        }
    }

    protected void processEnums() {
        Iterator classifiers = this.ePackage.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            EClassifier classifier = (EClassifier)classifiers.next();
            if (!(classifier instanceof EEnum)) continue;
            this.processEnum((EEnum)classifier);
        }
    }

    protected String getName(ENamedElement element) {
        if (this.qNameMap == null) {
            return element.getName();
        }
        return this.qNameMap.getName(element);
    }

    protected void processEnum(EEnum eEnum) {
        XSDSimpleTypeDefinition enumType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        enumType.setName(this.getName((ENamedElement)eEnum));
        enumType.setBaseTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("NCName"));
        this.xsdSchema.getContents().add((Object)enumType);
        this.map(enumType, (EModelElement)eEnum);
        Iterator literals = eEnum.getELiterals().iterator();
        while (literals.hasNext()) {
            EEnumLiteral literal = (EEnumLiteral)literals.next();
            XSDEnumerationFacet facet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
            facet.setLexicalValue(this.getName((ENamedElement)literal));
            enumType.getFacetContents().add((Object)facet);
            this.map(facet, (EModelElement)literal);
        }
    }

    protected void processClass(EClass eClass) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(this.getName((ENamedElement)eClass));
        EList superClasses = eClass.getESuperTypes();
        if (superClasses.size() > 0) {
            xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            EClass superClass = (EClass)superClasses.get(0);
            if (superClass.getEPackage() == this.ePackage) {
                xsdComplexTypeDefinition.setBaseTypeDefinition(this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)superClass)));
            } else {
                xsdComplexTypeDefinition.setBaseTypeDefinition(this.typeInOtherSchema((EClassifier)superClass));
            }
        }
        this.xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        this.map(xsdComplexTypeDefinition, (EModelElement)eClass);
        List features = this.getFeatures(eClass, (List)superClasses);
        Iterator fs = features.iterator();
        while (fs.hasNext()) {
            EStructuralFeature f = (EStructuralFeature)fs.next();
            if (f instanceof EAttribute) {
                this.processAttribute((EAttribute)f, xsdComplexTypeDefinition);
                continue;
            }
            if (!(f instanceof EReference)) continue;
            this.processReference((EReference)f, xsdComplexTypeDefinition);
        }
        if (this.makeClassElementDeclaration(eClass)) {
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setName(this.getName((ENamedElement)eClass));
            xsdElementDeclaration.setTypeDefinition(xsdComplexTypeDefinition);
            this.xsdSchema.getContents().add((Object)xsdElementDeclaration);
            this.map(xsdElementDeclaration, (EModelElement)eClass);
        }
        this.additionalProcessing(eClass, xsdComplexTypeDefinition);
    }

    protected boolean makeClassElementDeclaration(EClass eClass) {
        return !eClass.isAbstract();
    }

    protected void additionalProcessing(EClass cls, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
    }

    protected List getFeatures(EClass eClass, List superClasses) {
        ArrayList features = new ArrayList();
        if (superClasses.size() > 0) {
            EList allSupers = ((EClass)superClasses.get(0)).getEAllSuperTypes();
            HashSet allSuperClasses = new HashSet();
            allSuperClasses.addAll(allSupers);
            allSuperClasses.add(superClasses.get(0));
            for (int i = 1; i < superClasses.size(); ++i) {
                EClass superClass = (EClass)superClasses.get(i);
                if (allSuperClasses.contains(superClass)) continue;
                features.addAll(this.getAllFeatures(superClass, allSuperClasses));
            }
        }
        features.addAll(eClass.getEAttributes());
        features.addAll(eClass.getEReferences());
        return features;
    }

    protected List getAllFeatures(EClass eClass, Set classesToIgnore) {
        ArrayList features = new ArrayList();
        EList superClasses = eClass.getESuperTypes();
        for (int i = 0; i < superClasses.size(); ++i) {
            if (classesToIgnore.contains(superClasses.get(i))) continue;
            features.addAll(this.getAllFeatures((EClass)superClasses.get(i), classesToIgnore));
        }
        features.addAll(eClass.getEAttributes());
        features.addAll(eClass.getEReferences());
        classesToIgnore.add(eClass);
        return features;
    }

    protected void processAttribute(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (this.processAttribute(attribute)) {
            if (this.makeAttributeDeclaration(attribute)) {
                this.createAttributeDeclaration(attribute, xsdComplexTypeDefinition);
            }
            if (this.makeAttributeElementDeclaration(attribute)) {
                this.createAttributeElementDeclaration(attribute, xsdComplexTypeDefinition);
            }
        }
    }

    protected void createAttributeDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attrDecl.setName(this.getName((ENamedElement)attribute));
        this.setAttributeType(attribute, attrDecl);
        this.setDefaultValue(attribute, attrDecl);
        XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        this.setUseToRequired(attribute, attrUse);
        attrUse.setContent(attrDecl);
        xsdComplexTypeDefinition.getAttributeContents().add((Object)attrUse);
        this.map(attrUse, (EModelElement)attribute);
    }

    protected void createAttributeElementDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.getName((ENamedElement)attribute));
        if (attribute.getEType().getDefaultValue() == null && (attribute.isMany() || !attribute.isRequired() && (attribute.getDefaultValueLiteral() != null || attribute.isUnsettable()))) {
            xsdElementDeclaration.setNillable(true);
        }
        if (xsdElementDeclaration.isNillable() || attribute.isMany() || !this.minimizedXMI) {
            XSDSimpleTypeDefinition attrType = this.getType(attribute.getEAttributeType());
            if (attrType != null) {
                xsdElementDeclaration.setTypeDefinition(attrType);
            }
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent(xsdElementDeclaration);
            this.setAttributeElementMultiplicity(attribute, particle);
            modelGroup.getContents().add((Object)particle);
            this.map(particle, (EModelElement)attribute);
        }
    }

    protected void setAttributeElementMultiplicity(EAttribute attribute, XSDParticle particle) {
        if (this.enforceLowerBound) {
            particle.setMinOccurs(attribute.getLowerBound());
        } else {
            particle.setMinOccurs(0);
        }
        particle.setMaxOccurs(attribute.getUpperBound());
    }

    protected boolean processAttribute(EAttribute attribute) {
        if (attribute.isTransient()) {
            return false;
        }
        EDataType type = attribute.getEAttributeType();
        return type == null || type.isSerializable();
    }

    protected boolean makeAttributeDeclaration(EAttribute attribute) {
        return !attribute.isMany();
    }

    protected boolean makeAttributeElementDeclaration(EAttribute attribute) {
        return attribute.isMany();
    }

    protected XSDModelGroup getModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (xsdComplexTypeDefinition.getContent() == null) {
            return this.createModelGroup(xsdComplexTypeDefinition);
        }
        XSDParticle particle = (XSDParticle)xsdComplexTypeDefinition.getContent();
        return (XSDModelGroup)particle.getContent();
    }

    protected XSDModelGroup createModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(modelGroup);
        xsdComplexTypeDefinition.setContent(particle);
        return modelGroup;
    }

    protected void setAttributeType(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
        XSDSimpleTypeDefinition attrType = this.getType(attribute.getEAttributeType());
        if (attrType != null) {
            attrDecl.setTypeDefinition(attrType);
        }
    }

    protected void setUseToRequired(EAttribute attribute, XSDAttributeUse attrUse) {
        if (attribute.isRequired()) {
            attrUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
        }
    }

    protected void setDefaultValue(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
        if (attribute.getDefaultValueLiteral() != null) {
            attrDecl.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            attrDecl.setLexicalValue(attribute.getDefaultValueLiteral());
        }
    }

    protected void processReference(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (!this.skipReference(reference)) {
            if (this.makeReferenceAttribute(reference)) {
                this.makeReferenceAttribute(reference, xsdComplexTypeDefinition);
            }
            if (this.makeReferenceElement(reference)) {
                this.makeReferenceElement(reference, xsdComplexTypeDefinition);
            }
        }
    }

    protected boolean makeReferenceAttribute(EReference reference) {
        return !reference.isContainment();
    }

    protected boolean makeReferenceElement(EReference reference) {
        return reference.isContainment() && !reference.isContainer();
    }

    protected boolean skipReference(EReference reference) {
        return reference.isTransient();
    }

    protected void makeReferenceAttribute(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attrDecl.setName(this.getName((ENamedElement)reference));
        this.setReferenceAttribType(attrDecl);
        XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        attrUse.setContent(attrDecl);
        xsdComplexTypeDefinition.getAttributeContents().add((Object)attrUse);
        this.map(attrUse, (EModelElement)reference);
    }

    protected void setReferenceAttribType(XSDAttributeDeclaration xsdAttributeDeclaration) {
        this.addEMFSchema();
        xsdAttributeDeclaration.setTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(REFERENCE_TYPE_NAME));
    }

    protected void makeReferenceElement(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.getName((ENamedElement)reference));
        if (reference.isUnsettable() && !reference.isMany()) {
            xsdElementDeclaration.setNillable(true);
        }
        this.setReferenceElementType(reference, xsdElementDeclaration);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(xsdElementDeclaration);
        this.setReferenceElementMultiplicity(reference, particle);
        modelGroup.getContents().add((Object)particle);
        this.map(particle, (EModelElement)reference);
    }

    protected void setReferenceElementType(EReference reference, XSDElementDeclaration xsdElementDeclaration) {
        XSDTypeDefinition type;
        if (reference.getEType() != null && (type = reference.getEType().getEPackage() == this.ePackage ? this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)reference.getEType())) : this.typeInOtherSchema(reference.getEType())) != null) {
            xsdElementDeclaration.setTypeDefinition(type);
        }
    }

    protected void setReferenceElementMultiplicity(EReference reference, XSDParticle particle) {
        particle.setMinOccurs(reference.getLowerBound());
        particle.setMaxOccurs(reference.getUpperBound());
    }

    protected XSDSimpleTypeDefinition getType(EDataType dataType) {
        if (dataType instanceof EEnum) {
            EPackage typePkg = dataType.getEPackage();
            if (typePkg == this.ePackage) {
                return this.xsdSchema.resolveSimpleTypeDefinition(this.getName((ENamedElement)dataType));
            }
            return (XSDSimpleTypeDefinition)this.typeInOtherSchema((EClassifier)dataType);
        }
        String name = null;
        if (dataType != null) {
            name = this.getName((ENamedElement)dataType);
        }
        return this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(this.getSchemaName(name));
    }

    private String getSchemaName(String name) {
        String schemaName;
        if (this.ecoreToSchemaName == null) {
            this.ecoreToSchemaName = new HashMap();
            this.ecoreToSchemaName.put("EBoolean", "boolean");
            this.ecoreToSchemaName.put("EBooleanObject", "boolean");
            this.ecoreToSchemaName.put("EInt", "int");
            this.ecoreToSchemaName.put("EIntegerObject", "int");
            this.ecoreToSchemaName.put("ELong", "long");
            this.ecoreToSchemaName.put("ELongObject", "long");
            this.ecoreToSchemaName.put("EFloat", "float");
            this.ecoreToSchemaName.put("EFloatObject", "float");
            this.ecoreToSchemaName.put("EDouble", "double");
            this.ecoreToSchemaName.put("EDoubleObject", "double");
            this.ecoreToSchemaName.put("EString", REFERENCE_TYPE_NAME);
        }
        if ((schemaName = (String)this.ecoreToSchemaName.get(name)) != null) {
            return schemaName;
        }
        return REFERENCE_TYPE_NAME;
    }

    protected void addDocumentation(XSDConcreteComponent xsdComponent, EModelElement eModelElement) {
        String documentation;
        if (EcoreUtil.isAncestor((EObject)this.ePackage, (EObject)eModelElement) && (documentation = EcoreUtil.getDocumentation((EModelElement)eModelElement)) != null) {
            XSDAnnotation xsdAnnotation = null;
            if (xsdComponent instanceof XSDAttributeUse) {
                xsdComponent = ((XSDAttributeUse)xsdComponent).getContent();
            } else if (xsdComponent instanceof XSDParticle) {
                xsdComponent = ((XSDParticle)xsdComponent).getContent();
            }
            if (xsdComponent instanceof XSDSchema) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDSchema)xsdComponent).getContents().add(0, (Object)xsdAnnotation);
            } else if (xsdComponent instanceof XSDTypeDefinition) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDTypeDefinition)xsdComponent).setAnnotation(xsdAnnotation);
            } else if (xsdComponent instanceof XSDFacet) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDFacet)xsdComponent).setAnnotation(xsdAnnotation);
            } else if (xsdComponent instanceof XSDElementDeclaration) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDElementDeclaration)xsdComponent).setAnnotation(xsdAnnotation);
            } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDAttributeDeclaration)xsdComponent).setAnnotation(xsdAnnotation);
            }
            if (xsdAnnotation != null) {
                Element userInformation = xsdAnnotation.createUserInformation(null);
                XSDParser xsdParser = new XSDParser();
                xsdParser.parseString("<documentation>" + documentation + "</documentation>");
                Document document = xsdParser.getDocument();
                if (xsdParser.getDiagnostics().isEmpty() && document.getDocumentElement().getFirstChild() != null) {
                    Document xsdDocument = this.xsdSchema.getDocument();
                    for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                        userInformation.appendChild(xsdDocument.importNode(node, true));
                    }
                } else {
                    userInformation.appendChild(this.xsdSchema.getDocument().createTextNode(documentation));
                }
                xsdAnnotation.getElement().appendChild(userInformation);
            }
        }
    }

    public static interface QNameMap {
        public String getName(ENamedElement var1);
    }
}

