/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.id;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.LongID;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.ParsedObjectID;
import java.io.Serializable;

public class LongIDFactory
implements ObjectIDFactory,
Serializable {
    private long lastID = 0L;

    public String getDescription() {
        return CorePlugin.Util.getString("LongIDFactory.Description");
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    public ObjectID create() {
        return new LongID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof LongID;
    }

    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new LongID(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new LongID(Long.parseLong(parsedID.getRemainder()));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    public String getProtocol() {
        return "mmlong";
    }
}

