/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Option
implements LanguageObject {
    private boolean showPlan = false;
    private boolean debug = false;
    private List makeDependentGroups = null;
    private List makeNotDependentGroups = null;
    private boolean planOnly = false;
    private List noCacheGroups;
    private boolean noCache;
    private boolean virtualDependentJoinAllowed = false;

    public void setShowPlan(boolean flag) {
        this.showPlan = flag;
    }

    public boolean getShowPlan() {
        return this.showPlan;
    }

    public void setPlanOnly(boolean planOnly) {
        this.planOnly = planOnly;
    }

    public boolean getPlanOnly() {
        return this.planOnly;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void addDependentGroup(String group) {
        if (this.makeDependentGroups == null) {
            this.makeDependentGroups = new ArrayList();
        }
        this.makeDependentGroups.add(group);
    }

    public List getDependentGroups() {
        return this.makeDependentGroups;
    }

    public void addNotDependentGroup(String group) {
        if (this.makeNotDependentGroups == null) {
            this.makeNotDependentGroups = new ArrayList();
        }
        this.makeNotDependentGroups.add(group);
    }

    public List getNotDependentGroups() {
        return this.makeNotDependentGroups;
    }

    public void addNoCacheGroup(String group) {
        if (this.noCacheGroups == null) {
            this.noCacheGroups = new ArrayList();
        }
        this.noCacheGroups.add(group);
    }

    public List getNoCacheGroups() {
        return this.noCacheGroups;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isVirtualDependentJoinAllowed() {
        return this.virtualDependentJoinAllowed;
    }

    public void setVirtualDependentJoinAllowed(boolean virtualDependentJoinAllowed) {
        this.virtualDependentJoinAllowed = virtualDependentJoinAllowed;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        return this.getShowPlan() == other.getShowPlan() && this.getDebug() == other.getDebug() && this.getPlanOnly() == other.getPlanOnly() && this.noCache == other.noCache && this.virtualDependentJoinAllowed == other.virtualDependentJoinAllowed && EquivalenceUtil.areEqual(this.getDependentGroups(), other.getDependentGroups()) && EquivalenceUtil.areEqual(this.getNotDependentGroups(), other.getNotDependentGroups()) && EquivalenceUtil.areEqual(this.getNoCacheGroups(), other.getNoCacheGroups());
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getShowPlan());
        hc = HashCodeUtil.hashCode(hc, this.getDebug());
        hc = HashCodeUtil.hashCode(hc, this.getPlanOnly());
        hc = HashCodeUtil.hashCode(hc, this.isVirtualDependentJoinAllowed());
        if (this.getDependentGroups() != null) {
            hc = HashCodeUtil.hashCode(hc, this.getDependentGroups());
        }
        if (this.getNotDependentGroups() != null) {
            hc = HashCodeUtil.hashCode(hc, this.getNotDependentGroups());
        }
        if (this.getNoCacheGroups() != null) {
            hc = HashCodeUtil.hashCode(hc, this.getNoCacheGroups());
        }
        return hc;
    }

    public Object clone() {
        Iterator iter;
        Option newOption = new Option();
        newOption.setDebug(this.getDebug());
        newOption.setShowPlan(this.getShowPlan());
        newOption.setPlanOnly(this.getPlanOnly());
        newOption.setNoCache(this.noCache);
        newOption.setVirtualDependentJoinAllowed(this.virtualDependentJoinAllowed);
        if (this.getDependentGroups() != null) {
            iter = this.getDependentGroups().iterator();
            while (iter.hasNext()) {
                newOption.addDependentGroup((String)iter.next());
            }
        }
        if (this.getNotDependentGroups() != null) {
            iter = this.getNotDependentGroups().iterator();
            while (iter.hasNext()) {
                newOption.addNotDependentGroup((String)iter.next());
            }
        }
        if (this.getNoCacheGroups() != null) {
            iter = this.getNoCacheGroups().iterator();
            while (iter.hasNext()) {
                newOption.addNoCacheGroup((String)iter.next());
            }
        }
        return newOption;
    }
}

