/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;

public class SystemPolicy
implements IBuddyPolicy {
    public static final byte BOOT = 0;
    public static final byte EXT = 1;
    public static final byte APP = 2;
    private static SystemPolicy[] instances = new SystemPolicy[3];
    private ClassLoader classLoader;

    public static SystemPolicy getInstance(final byte type) {
        if (instances[type] == null) {
            SystemPolicy.instances[type] = new SystemPolicy();
            SystemPolicy.instances[type].classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SystemPolicy.createClassLoader(type);
                }
            });
        }
        return instances[type];
    }

    public SystemPolicy() {
    }

    public SystemPolicy(ClassLoader parent) {
        this.classLoader = parent;
    }

    static ClassLoader createClassLoader(byte type) {
        switch (type) {
            case 2: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return new ParentClassLoader();
            }
            case 0: {
                return new ParentClassLoader();
            }
            case 1: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
                return new ParentClassLoader();
            }
        }
        return null;
    }

    public Class loadClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public URL loadResource(String name) {
        return this.classLoader.getResource(name);
    }

    public Enumeration loadResources(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

