/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.event;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSource;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractEventSource
implements EventSource {
    private static final String LISTENER_MAY_NOT_BE_NULL = CorePlugin.Util.getString("AbstractEventSource.The_event_listener_may_not_be_null");
    private static final String EVENT_CLASS_MAY_NOT_BE_NULL = CorePlugin.Util.getString("AbstractEventSource.The_event_class_may_not_be_null");
    Map eventClassListeners = new HashMap(5);
    List eventListeners = new ArrayList(5);

    public synchronized void addListener(Class eventClass, EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, LISTENER_MAY_NOT_BE_NULL);
        Assertion.isNotNull(eventClass, EVENT_CLASS_MAY_NOT_BE_NULL);
        if (!this.eventClassListeners.containsKey(eventClass)) {
            ArrayList<EventObjectListener> listenerList = new ArrayList<EventObjectListener>(1);
            listenerList.add(listener);
            this.eventClassListeners.put(eventClass, listenerList);
        } else {
            List listenerList = (List)this.eventClassListeners.get(eventClass);
            if (!listenerList.contains(listener)) {
                listenerList.add(listener);
            }
        }
    }

    public synchronized void addListener(EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, LISTENER_MAY_NOT_BE_NULL);
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeListener(Class eventClass, EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, LISTENER_MAY_NOT_BE_NULL);
        Assertion.isNotNull(eventClass, EVENT_CLASS_MAY_NOT_BE_NULL);
        if (this.eventClassListeners.containsKey(eventClass)) {
            List listenerList = (List)this.eventClassListeners.get(eventClass);
            listenerList.remove(listener);
        }
    }

    public synchronized void removeListener(EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, LISTENER_MAY_NOT_BE_NULL);
        this.eventListeners.remove(listener);
        Iterator iter = this.eventClassListeners.values().iterator();
        while (iter.hasNext()) {
            List listenerList = (List)iter.next();
            listenerList.remove(listener);
        }
    }

    public synchronized void removeAllListeners() throws EventSourceException {
        this.eventClassListeners.clear();
        this.eventListeners.clear();
    }

    public synchronized List getListeners() {
        return new ArrayList(this.eventListeners);
    }

    public synchronized List getAllListeners() {
        HashSet result = new HashSet();
        result.addAll(this.eventListeners);
        Iterator iter = this.eventClassListeners.values().iterator();
        while (iter.hasNext()) {
            List listenerList = (List)iter.next();
            result.addAll(listenerList);
        }
        return new ArrayList(result);
    }

    public synchronized List getListeners(Class eventClass) {
        Assertion.isNotNull(eventClass, EVENT_CLASS_MAY_NOT_BE_NULL);
        ArrayList<Object> returnList = new ArrayList<Object>(this.eventListeners);
        List listeners = (List)this.eventClassListeners.get(eventClass);
        if (listeners != null) {
            Object listener = null;
            Iterator itr = listeners.iterator();
            while (itr.hasNext()) {
                listener = itr.next();
                if (returnList.contains(listener)) continue;
                returnList.add(listener);
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(AbstractEventSource eventSource) throws EventSourceException {
        List anyListeners = eventSource.getListeners();
        HashMap listenersByClass = new HashMap();
        AbstractEventSource abstractEventSource = eventSource;
        synchronized (abstractEventSource) {
            Iterator classIter = eventSource.eventClassListeners.entrySet().iterator();
            while (classIter.hasNext()) {
                Map.Entry entry = classIter.next();
                Object eventClass = entry.getKey();
                List listeners = (List)entry.getValue();
                listenersByClass.put(eventClass, new ArrayList(listeners));
            }
        }
        this.eventListeners.addAll(anyListeners);
        Iterator classIter = listenersByClass.entrySet().iterator();
        while (classIter.hasNext()) {
            Map.Entry entry = classIter.next();
            Class eventClass = (Class)entry.getKey();
            List listeners = (List)entry.getValue();
            Iterator listenerIter = listeners.iterator();
            while (listenerIter.hasNext()) {
                EventObjectListener listener = (EventObjectListener)listenerIter.next();
                this.addListener(eventClass, listener);
            }
        }
    }
}

