/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.struct;

import com.metamatrix.core.struct.ReflectionWrapper;
import com.metamatrix.core.struct.StructHandler;
import java.lang.reflect.Array;

public class StructWalker {
    private StructHandler handler;

    public StructWalker(StructHandler handler) {
        this.handler = handler;
    }

    public void walk(Object struct) {
        this.walkDirect(null, null, struct, 0, false);
    }

    public void walk(Object struct, boolean walkPrimitive) {
        this.walkDirect(null, null, struct, 0, walkPrimitive);
    }

    private void walkDirect(String name, Integer arrayIndex, Object struct, int level, boolean walkPrimitive) {
        if (struct == null) {
            return;
        }
        if (struct.getClass().isArray()) {
            int count = Array.getLength(struct);
            for (int i = 0; i < count; ++i) {
                this.walkDirect(name, new Integer(i), Array.get(struct, i), level + 1, walkPrimitive);
            }
        } else {
            String fieldName;
            int i;
            this.handler.handle(name, arrayIndex, struct, level);
            ReflectionWrapper wrapper = new ReflectionWrapper(struct);
            if (walkPrimitive) {
                String[] primitives = wrapper.getFieldsWithPrimitiveTypes();
                for (i = 0; i < primitives.length; ++i) {
                    fieldName = primitives[i];
                    this.handler.handle(fieldName, null, wrapper.get(fieldName), level + 1);
                }
            }
            String[] subStructs = wrapper.getFieldsWithUserDefinedTypes();
            for (i = 0; i < subStructs.length; ++i) {
                fieldName = subStructs[i];
                this.walkDirect(fieldName, null, wrapper.get(fieldName), level + 1, walkPrimitive);
            }
        }
    }
}

