/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixCoreException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReflectionHelper {
    private Class targetClass;
    private Map methodMap = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    public ReflectionHelper(Class targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ReflectionHelper.errorConstructing"));
        }
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Method[] findMethods(String methodName) {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!m.getName().equals(methodName)) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public Method findFirstMethod(String methodName) {
        Method[] allMethods = this.targetClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        return this.findBestMethodOnTarget(methodName, arguments, false);
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments, boolean convertAllArgsToPrimitives) throws NoSuchMethodException, SecurityException {
        List argumentClasses = ReflectionHelper.buildArgumentClasses(arguments);
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodOnTarget(String methodName, List arguments) throws NoSuchMethodException, SecurityException {
        return this.findBestMethodOnTarget(methodName, arguments, false);
    }

    public Method findBestMethodOnTarget(String methodName, List arguments, boolean convertAllArgsToPrimitives) throws NoSuchMethodException, SecurityException {
        List argumentClasses = ReflectionHelper.buildArgumentClasses(arguments);
        if (convertAllArgsToPrimitives) {
            argumentClasses = ReflectionHelper.convertArgumentClassesToPrimitives(argumentClasses);
        }
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Object[] argumentsClasses) throws NoSuchMethodException, SecurityException {
        List<Object> argumentClassesList = Arrays.asList(argumentsClasses);
        return this.findBestMethodWithSignature(methodName, argumentClassesList);
    }

    public Method findBestMethodWithSignature(String methodName, List argumentsClasses) throws NoSuchMethodException, SecurityException {
        Class[] classArgs = new Class[argumentsClasses.size()];
        try {
            argumentsClasses.toArray(classArgs);
            Method result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException e) {
            List argumentsClassList = ReflectionHelper.convertArgumentClassesToPrimitives(argumentsClasses);
            argumentsClassList.toArray(classArgs);
            try {
                Method result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException e2) {
                LinkedList methodsWithSameName;
                Method method;
                if (this.methodMap == null) {
                    this.methodMap = new HashMap();
                    Method[] methods = this.targetClass.getMethods();
                    for (int i = 0; i != methods.length; ++i) {
                        method = methods[i];
                        methodsWithSameName = (LinkedList)this.methodMap.get(method.getName());
                        if (methodsWithSameName == null) {
                            methodsWithSameName = new LinkedList();
                            this.methodMap.put(method.getName(), methodsWithSameName);
                        }
                        methodsWithSameName.addFirst(method);
                    }
                }
                for (int j = 0; j != 2; ++j) {
                    methodsWithSameName = (LinkedList)this.methodMap.get(methodName);
                    if (methodsWithSameName == null) {
                        throw new NoSuchMethodException(methodName);
                    }
                    Iterator iter = methodsWithSameName.iterator();
                    while (iter.hasNext()) {
                        method = (Method)iter.next();
                        Class<?>[] args = method.getParameterTypes();
                        if (args.length != argumentsClasses.size()) continue;
                        boolean allMatch = true;
                        for (int i = 0; i < args.length && allMatch; ++i) {
                            Class primitiveClazz = (Class)argumentsClassList.get(i);
                            Class objectClazz = (Class)argumentsClasses.get(i);
                            if (objectClazz != null) {
                                if (args[i].equals(primitiveClazz) || args[i].isAssignableFrom(objectClazz)) continue;
                                allMatch = false;
                                continue;
                            }
                            if (!args[i].isPrimitive()) continue;
                            allMatch = false;
                        }
                        if (!allMatch) continue;
                        return method;
                    }
                }
                throw new NoSuchMethodException(methodName + " Args: " + argumentsClasses);
            }
        }
    }

    public static List buildArgumentClasses(List arguments) {
        ArrayList result = new ArrayList(arguments.size());
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            Class<?> clazz = iter.next().getClass();
            result.add(clazz);
        }
        return result;
    }

    public static List buildArgumentClasses(Object[] arguments) {
        int size = arguments.length;
        ArrayList result = new ArrayList(size);
        for (int i = 0; i != size; ++i) {
            if (arguments[i] != null) {
                Class<?> clazz = arguments[i].getClass();
                result.add(clazz);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static List convertArgumentClassesToPrimitives(List arguments) {
        ArrayList<Class<Boolean>> result = new ArrayList<Class<Boolean>>(arguments.size());
        ListIterator iter = arguments.listIterator();
        while (iter.hasNext()) {
            Class<Object> clazz = (Class<Boolean>)iter.next();
            if (clazz == (class$java$lang$Boolean == null ? ReflectionHelper.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                clazz = Boolean.TYPE;
            } else if (clazz == (class$java$lang$Character == null ? ReflectionHelper.class$("java.lang.Character") : class$java$lang$Character)) {
                clazz = Character.TYPE;
            } else if (clazz == (class$java$lang$Byte == null ? ReflectionHelper.class$("java.lang.Byte") : class$java$lang$Byte)) {
                clazz = Byte.TYPE;
            } else if (clazz == (class$java$lang$Short == null ? ReflectionHelper.class$("java.lang.Short") : class$java$lang$Short)) {
                clazz = Short.TYPE;
            } else if (clazz == (class$java$lang$Integer == null ? ReflectionHelper.class$("java.lang.Integer") : class$java$lang$Integer)) {
                clazz = Integer.TYPE;
            } else if (clazz == (class$java$lang$Long == null ? ReflectionHelper.class$("java.lang.Long") : class$java$lang$Long)) {
                clazz = Long.TYPE;
            } else if (clazz == (class$java$lang$Float == null ? ReflectionHelper.class$("java.lang.Float") : class$java$lang$Float)) {
                clazz = Float.TYPE;
            } else if (clazz == (class$java$lang$Double == null ? ReflectionHelper.class$("java.lang.Double") : class$java$lang$Double)) {
                clazz = Double.TYPE;
            } else if (clazz == (class$java$lang$Void == null ? ReflectionHelper.class$("java.lang.Void") : class$java$lang$Void)) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    public static final Class loadClass(String className, ClassLoader classLoader) throws MetaMatrixCoreException {
        try {
            Class<?> cls = null;
            cls = classLoader == null ? Class.forName(className.trim()) : Class.forName(className.trim(), true, classLoader);
            return cls;
        }
        catch (NullPointerException e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.nullPointer"), (Throwable)e));
        }
        catch (ClassNotFoundException e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.classNotFound", className), (Throwable)e));
        }
        catch (LinkageError e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.linkageError", className), (Throwable)e));
        }
        catch (Exception e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.exception", className), (Throwable)e));
        }
    }

    public static final Object create(String className, Collection ctorObjs, ClassLoader classLoader) throws MetaMatrixCoreException {
        try {
            int size = ctorObjs == null ? 0 : ctorObjs.size();
            Class[] names = new Class[size];
            Object[] objArray = new Object[size];
            int i = 0;
            if (size > 0) {
                Iterator it = ctorObjs.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    names[i] = ReflectionHelper.loadClass(obj.getClass().getName(), classLoader);
                    objArray[i] = obj;
                    ++i;
                }
            }
            Class cls = ReflectionHelper.loadClass(className, classLoader);
            Constructor ctor = cls.getDeclaredConstructor(names);
            return ctor.newInstance(objArray);
        }
        catch (NullPointerException e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.nullPointer"), (Throwable)e));
        }
        catch (InstantiationException e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.instantiationError", className), (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.illegalAccess", className), (Throwable)e));
        }
        catch (MetaMatrixCoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaMatrixCoreException((IStatus)new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.exception", className), (Throwable)e));
        }
    }

    public static final Object create(String className, Collection ctorObjs) throws MetaMatrixCoreException {
        return ReflectionHelper.create(className, ctorObjs, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

