/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.soap.service.ConnectionPoolFactory;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicConnectionPoolFactory
implements ConnectionPoolFactory {
    private static final Properties defaultProperties = new Properties();

    public DataSource createConnectionPool(Properties poolProperties) {
        if (poolProperties == null) {
            return null;
        }
        BasicDataSource pool = new BasicDataSource();
        pool.setDriverClassName("com.metamatrix.jdbc.MMDriver");
        pool.setUsername(poolProperties.getProperty("Username"));
        pool.setPassword(poolProperties.getProperty("Password"));
        pool.setUrl(poolProperties.getProperty("ServerURL"));
        pool.setInitialSize(Integer.parseInt(this.getProperty("com.metamatrix.soap.service.initpoolsize")));
        pool.setMaxActive(Integer.parseInt(this.getProperty("com.metamatrix.soap.service.maxactiveconnections")));
        pool.setMaxIdle(Integer.parseInt(this.getProperty("com.metamatrix.soap.service.maxidleconnections")));
        pool.setMaxWait((long)Integer.parseInt(this.getProperty("com.metamatrix.soap.service.maxwait")));
        pool.setMinIdle(Integer.parseInt(this.getProperty("com.metamatrix.soap.service.minidlecount")));
        pool.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(this.getProperty("com.metamatrix.soap.service.timebetweenevictionthreadruns")));
        pool.setMinEvictableIdleTimeMillis((long)Integer.parseInt(this.getProperty("com.metamatrix.soap.service.minevictableidletime")));
        pool.setTestWhileIdle(true);
        return pool;
    }

    protected String getProperty(String propKey) {
        return System.getProperty(propKey, defaultProperties.getProperty(propKey));
    }

    static {
        defaultProperties.setProperty("com.metamatrix.soap.service.initpoolsize", String.valueOf(1));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxactiveconnections", String.valueOf(25));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxidleconnections", String.valueOf(10));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxwait", String.valueOf(30000));
        defaultProperties.setProperty("com.metamatrix.soap.service.minidlecount", String.valueOf(0));
        defaultProperties.setProperty("com.metamatrix.soap.service.minevictableidletime", String.valueOf(600000));
        defaultProperties.setProperty("com.metamatrix.soap.service.timebetweenevictionthreadruns", String.valueOf(60000));
    }
}

