/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.servlet;

import com.metamatrix.common.util.WSDLServletUtil;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.license.LicenseInfo;
import com.metamatrix.soap.servlet.MMGetVDBResourcePlatformLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSDLURLGenerator
extends HttpServlet {
    public LogListener newListener = null;
    public FileLogWriter logWriter = null;
    MMGetVDBResourcePlatformLog platformLog = MMGetVDBResourcePlatformLog.getInstance();
    private static final boolean isLicensed = LicenseInfo.getInstance().isSOAPAPILicensed();

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        String logFile = this.getServletContext().getInitParameter("logfile");
        File log = new File(logFile);
        this.logWriter = new FileLogWriter(log);
        this.platformLog.getPlatformLog().addListener((LogListener)this.logWriter);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String servletPath;
        URL url;
        HttpURLConnection connection;
        if (!isLicensed) {
            String message = LicenseInfo.getErrorMessage() + SOAPPlugin.Util.getString("LicenseInfo.ErrorMessage");
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            resp.getOutputStream().println(message);
            return;
        }
        String mmServerHost = req.getParameter("MMServerHost");
        String mmServerPort = req.getParameter("MMServerPort");
        String vdbName = req.getParameter("VDBName");
        String vdbVersion = req.getParameter("VDBVersion");
        String targetHost = req.getParameter("TargetHost");
        String targetPort = req.getParameter("TargetPort");
        String isHttpString = req.getParameter("httptype");
        String txnAutoWrap = req.getParameter("txnAutoWrap");
        String scheme = req.getScheme();
        try {
            WSDLURLGenerator.checkFormValue(mmServerHost, "MMServerHost");
            WSDLURLGenerator.checkFormValue(mmServerPort, "MMServerPort");
            WSDLURLGenerator.checkFormValue(txnAutoWrap, "txnAutoWrap");
            WSDLURLGenerator.checkFormValue(vdbName, "VDBName");
            WSDLURLGenerator.checkFormValue(vdbVersion, "VDBVersion");
            WSDLURLGenerator.checkFormValue(targetHost, "TargetHost");
        }
        catch (Exception e) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, e.getMessage());
            resp.getOutputStream().println(e.getMessage());
            return;
        }
        if (!this.validateInteger(resp, mmServerPort, "ERR.018.002.0020")) {
            return;
        }
        if (targetPort != null && targetPort.length() > 0 && !this.validateInteger(resp, targetPort, "ERR.018.002.0020")) {
            return;
        }
        if (!this.validateInteger(resp, vdbVersion, "ERR.018.002.0024")) {
            return;
        }
        try {
            new URL(scheme + "://" + mmServerHost + ":" + mmServerPort);
        }
        catch (MalformedURLException mue) {
            String message = SOAPPlugin.Util.getString("ERR.018.002.0021", (Object)mmServerHost);
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)mue, message);
            resp.getOutputStream().println(message);
            return;
        }
        String serverURL = URLEncoder.encode(this.getProtocol(req.getParameter("Secure")) + "://" + mmServerHost + ":" + mmServerPort, "UTF-8");
        if (targetPort == null) {
            targetPort = "";
        }
        if ((connection = (HttpURLConnection)(url = new URL(servletPath = WSDLServletUtil.formatURL((String)scheme, (String)targetHost, (String)targetPort, (String)serverURL, (String)vdbName, (String)vdbVersion, (isHttpString != null ? 1 : 0) != 0, (String)txnAutoWrap))).openConnection()) == null || "wsdlerror".equals(connection.getHeaderField("wsdlerror"))) {
            StringBuffer error = new StringBuffer();
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    error.append((char)c);
                }
                String message = SOAPPlugin.Util.getString("ERR.018.002.0022", (Object)servletPath, (Object)error.toString());
                MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, message);
                resp.getOutputStream().println(message);
            }
            finally {
                reader.close();
            }
            return;
        }
        resp.getOutputStream().println("<a href='" + servletPath + "'>" + servletPath + "</a>");
    }

    private boolean validateInteger(HttpServletResponse resp, String integer, String error_key) throws IOException {
        try {
            int port = Integer.parseInt(integer);
            if (port < 0) {
                throw new NumberFormatException(SOAPPlugin.Util.getString("ERR.018.002.0023"));
            }
        }
        catch (NumberFormatException nfe) {
            String message = SOAPPlugin.Util.getString(error_key, (Object)integer);
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)nfe, message);
            resp.getOutputStream().println(message);
            return false;
        }
        return true;
    }

    private String getProtocol(String secure) {
        if (secure != null && secure.equals("Secure")) {
            return "mms";
        }
        return "mm";
    }

    private static void checkFormValue(String parameter, String expectedParameterName) throws Exception {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", (Object)expectedParameterName));
        }
    }
}

