/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.core.Plugin;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.Customer;
import com.metamatrix.license.domain.IPSets;
import com.metamatrix.license.domain.LicenseInfo;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.domain.ProductLicenses;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.UnlicensedProductException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class License {
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
    static final String DEFAULT_VERSION = "3";
    String version = "3";
    private LicenseInfo licenseInfo;
    private Customer customer;
    private IPSets ipSets;
    private ProductLicenses productLicenses;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public void setLicenseInfo(LicenseInfo value) {
        this.licenseInfo = value;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer value) {
        this.customer = value;
    }

    public IPSets getIPSets() {
        return this.ipSets;
    }

    public void setIPSets(IPSets value) {
        this.ipSets = value;
    }

    public ProductLicenses getProductLicenses() {
        return this.productLicenses;
    }

    public void setProductLicenses(ProductLicenses value) {
        this.productLicenses = value;
    }

    public String checkValidity(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        this.checkOrganization();
        return this.productLicenses.checkLicenseValidity(productName, version);
    }

    public String getEffectivityMessageForAboutDialog(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        return this.productLicenses.getEffectivityMessageForAboutDialog(productName, version);
    }

    public void resetExpireWarned() {
        ProductLicenses.resetExpireWarned();
    }

    public String checkValidity(String productName, String version, int nUnits) throws UnlicensedProductException, InvalidLicenseException {
        this.checkOrganization();
        return this.productLicenses.checkLicenseValidity(productName, version, nUnits);
    }

    public String checkValidity(String productName, String version, boolean checkIP) throws UnlicensedProductException, InvalidLicenseException {
        this.checkOrganization();
        return this.productLicenses.checkLicenseValidity(productName, version, checkIP);
    }

    private void checkOrganization() throws InvalidLicenseException {
        String type;
        String organization = this.customer.getOrganization();
        boolean valid = Plugin.isValid((String)organization, (String)(type = this.licenseInfo.getLicenseType()));
        if (!valid) {
            String reason = LicensePlugin.Util.getString("ERR.003.016.0053", (Object)organization, (Object)type);
            throw new InvalidLicenseException("", this.version, reason);
        }
    }

    public ProductLicense getProductLicense(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        return this.productLicenses.getBestLicense(productName, version);
    }

    public ProductLicense getProductLicense(String productName, String version, String type, String ipAddr) throws UnlicensedProductException, InvalidLicenseException {
        return this.productLicenses.getBestLicense(productName, version, type, ipAddr);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("License: version " + this.version);
        buffer.append("\n");
        buffer.append(this.getLicenseInfo().toString());
        buffer.append("\n");
        buffer.append(this.getCustomer().toString());
        buffer.append("\n");
        buffer.append("Available IP Sets: " + this.getIPSets().toString());
        buffer.append("\n");
        buffer.append(this.getProductLicenses().toString());
        return buffer.toString();
    }

    public String toStringVerbose() {
        StringBuffer buffer = new StringBuffer("License: version " + this.version);
        buffer.append("\n");
        buffer.append(this.getLicenseInfo().toString());
        buffer.append("\n");
        buffer.append(this.getCustomer().toString());
        buffer.append("\n");
        buffer.append("Available IP Sets: " + this.getIPSets().toStringVerbose());
        buffer.append("\n");
        buffer.append(this.getProductLicenses().toStringVerbose());
        return buffer.toString();
    }

    public static Date stringToDate(String s) {
        return DATE_FORMAT.parse(s, new ParsePosition(0));
    }

    public static String dateToString(Date d) {
        return d != null ? DATE_FORMAT.format(d) : "";
    }

    public static License example(int key) {
        License license = new License();
        license.setLicenseInfo(LicenseInfo.example(key));
        license.setCustomer(Customer.example(key));
        license.setIPSets(IPSets.example(key));
        license.setProductLicenses(ProductLicenses.example(key));
        return license;
    }

    public static void main(String[] args) {
        License license = License.example(0);
        System.out.println(license);
    }
}

