/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.id.UUIDFactory;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.IPSet;
import com.metamatrix.license.domain.License;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class ProductLicense {
    private static final long MILLIS_TO_DAYS = 86400000L;
    public static final String UNLIMITED_UNITS = "Unlimited";
    public static final int UNLIMITED = Integer.MAX_VALUE;
    public static final String PRODUCT_INTEGRATION_SERVER = "Integration Server";
    public static final String PRODUCT_METADATA_MODELER = "Modeler";
    public static final String PRODUCT_METADATA_SERVER = "Repository";
    public static final String PRODUCT_TRANSACTION_MANAGER = "MetaMatrix Server/Transactions";
    public static final String[] PRODUCT_NAMES = new String[]{"Integration Server", "Modeler", "Repository", "MetaMatrix Server/Transactions"};
    private UUID uuid;
    private String type = "Development";
    private String productName;
    private String versionSpec;
    private int numberOfUnits = 1;
    private IPSet ipSet = IPSet.UNDEFINED;
    private Date issuanceDate;
    private Date effectiveDate;
    private Date expirationDate;
    private UUIDFactory idGenerator = new UUIDFactory();

    public ProductLicense() {
        this.uuid = (UUID)this.idGenerator.create();
        this.setIssuanceDate();
        this.setEffectiveDate();
    }

    public ProductLicense(String productName) {
        this();
        this.setProductName(productName);
    }

    public ProductLicense(String productName, String version) {
        this(productName);
        this.setVersionSpec(version);
    }

    public String getUUID() {
        return this.uuid.exportableForm();
    }

    public void setUUID(String uuidString) {
        try {
            this.uuid = (UUID)this.idGenerator.stringToObject(uuidString);
        }
        catch (InvalidIDException e) {
            try {
                this.uuid = (UUID)this.idGenerator.stringToObject("mmuuid:" + uuidString);
            }
            catch (InvalidIDException e1) {
                throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0022", (Object)uuidString));
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        if (!(value.equals("Evaluation") || value.equals("Development") || value.equals("Production"))) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0023", (Object)value));
        }
        this.type = value;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String value) {
        this.productName = value;
    }

    public String getVersionSpec() {
        return this.versionSpec;
    }

    public void setVersionSpec(String value) {
        this.versionSpec = value;
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(int value) {
        this.numberOfUnits = value;
    }

    public IPSet getIPSet() {
        return this.ipSet;
    }

    public void setIPSet(IPSet value) {
        this.ipSet = value != null ? value : IPSet.UNDEFINED;
    }

    public Date getIssuanceDate() {
        return this.issuanceDate;
    }

    public void setIssuanceDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0024"));
        }
        this.issuanceDate = this.removeTimeInfoFromDate(date);
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0025"));
        }
        this.effectiveDate = this.removeTimeInfoFromDate(date);
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0026"));
        }
        this.expirationDate = this.removeTimeInfoFromDate(date);
    }

    public void setIssuanceDate() {
        this.setIssuanceDate(new Date());
    }

    public void setEffectiveDate() {
        if (this.getIssuanceDate() == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0027"));
        }
        this.setEffectiveDate(this.getIssuanceDate());
    }

    public void setExpiration(int calendarConstant, int increment) {
        if (this.getEffectiveDate() == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0028"));
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getEffectiveDate());
        ((Calendar)calendar).add(calendarConstant, increment);
        this.setExpirationDate(calendar.getTime());
    }

    public boolean isExpired() {
        return this.getDaysToExpiration() < 0;
    }

    public int getDaysToExpiration() {
        if (this.getExpirationDate() == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0029"));
        }
        long todaysDate = this.removeTimeInfoFromMillis(System.currentTimeMillis());
        return (int)((this.expirationDate.getTime() - todaysDate) / 86400000L);
    }

    public boolean isEffective() {
        return this.getDaysEffective() >= 0 && !this.isExpired();
    }

    public int getDaysEffective() {
        if (this.getEffectiveDate() == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0030"));
        }
        long todaysDate = this.removeTimeInfoFromMillis(System.currentTimeMillis());
        return (int)((todaysDate - this.effectiveDate.getTime()) / 86400000L);
    }

    public boolean isIPValid(String ipAddress) {
        if (this.getIPSet().equals(IPSet.UNDEFINED)) {
            return true;
        }
        return this.getIPSet().contains(ipAddress);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ProductLicense)) {
            return false;
        }
        ProductLicense license = (ProductLicense)other;
        return this.getUUID().equals(license.getUUID());
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public String toString() {
        return "Product license " + this.getUUID() + " " + this.getType() + (this.isExpired() ? " [expired " + License.dateToString(this.getExpirationDate()) + "]" : "");
    }

    public String toStringVerbose() {
        return "Product license " + this.getUUID() + " " + this.getType() + "\n  Product " + this.productName + " version " + this.versionSpec + "\n  Issued    : " + License.dateToString(this.getIssuanceDate()) + "\n  Effective : " + License.dateToString(this.getEffectiveDate()) + "\n  Expiration: " + License.dateToString(this.getExpirationDate()) + "\n  Number of units " + this.getNumberOfUnits() + "\n  IP Set: " + this.getIPSet();
    }

    private long removeTimeInfoFromMillis(long date) {
        return this.removeTimeInfoFromDate(new Date(date)).getTime();
    }

    private Date removeTimeInfoFromDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0031"));
        }
        GregorianCalendar calendar1 = new GregorianCalendar();
        calendar1.setTime(date);
        GregorianCalendar calendar2 = new GregorianCalendar(calendar1.get(1), calendar1.get(2), calendar1.get(5));
        return calendar2.getTime();
    }

    public static String getLocalHostShortName() throws UnknownHostException {
        StringTokenizer tokens = new StringTokenizer(InetAddress.getLocalHost().getHostName(), ".");
        return tokens.nextToken();
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static String getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static ProductLicense example(int key) {
        String name = PRODUCT_NAMES[key % PRODUCT_NAMES.length];
        String version = "1." + key % 3;
        ProductLicense license = new ProductLicense(name, version);
        license.setNumberOfUnits(key % 10 + 1);
        license.setIPSet(IPSet.example(key));
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(license.getIssuanceDate());
        int effectiveDelta = -10;
        ((Calendar)calendar).add(5, key);
        license.setExpirationDate(calendar.getTime());
        ((Calendar)calendar).add(5, effectiveDelta);
        license.setEffectiveDate(calendar.getTime());
        license.setIssuanceDate(calendar.getTime());
        calendar = null;
        return license;
    }

    public static void main(String[] args) {
        ProductLicense license = new ProductLicense(PRODUCT_INTEGRATION_SERVER, "2.*");
        PrintWriter pw = new PrintWriter(System.out, true);
        license.setIssuanceDate();
        license.setEffectiveDate();
        license.setExpirationDate(license.getIssuanceDate());
        ProductLicense.testExpiration(license, pw);
    }

    private static void testExpiration(ProductLicense license, PrintWriter pw) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(license.getIssuanceDate());
        pw.println("\nToday's Date " + calendar.getTime() + "\n");
        ProductLicense.testDateDelta(license, calendar, 1, 0, pw);
        ProductLicense.testDateDelta(license, calendar, 5, 1, pw);
        ProductLicense.testDateDelta(license, calendar, 5, -1, pw);
        ProductLicense.testDateDelta(license, calendar, 5, 7, pw);
        ProductLicense.testDateDelta(license, calendar, 5, -7, pw);
        ProductLicense.testDateDelta(license, calendar, 2, 1, pw);
        ProductLicense.testDateDelta(license, calendar, 2, -1, pw);
        ProductLicense.testDateDelta(license, calendar, 1, 1, pw);
        ProductLicense.testDateDelta(license, calendar, 1, -1, pw);
    }

    private static void testDateDelta(ProductLicense license, Calendar calendar, int calendarConstant, int increment, PrintWriter pw) {
        int effectiveDelta = -10;
        calendar.add(calendarConstant, increment);
        license.setExpirationDate(calendar.getTime());
        pw.println("\nExpiration Date " + calendar.getTime() + "...");
        calendar.add(5, effectiveDelta);
        license.setEffectiveDate(calendar.getTime());
        pw.println("Effective  Date " + calendar.getTime() + "...");
        pw.println("  -- Number of days until expiration: " + license.getDaysToExpiration());
        pw.println("  -- Number of days effective       : " + license.getDaysEffective());
        pw.println("  -- Is expired?   : " + license.isExpired());
        pw.println("  -- Is effective? : " + license.isEffective());
        calendar.add(5, -effectiveDelta);
        calendar.add(calendarConstant, -increment);
    }
}

