/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.RangeSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class ReferenceSet
extends HashSet {
    private String name;
    private Set includeSet;

    public ReferenceSet() {
    }

    public ReferenceSet(String name) {
        this();
        this.setName(name);
    }

    public ReferenceSet(String name, Set includeSet) {
        this();
        this.setName(name);
        this.setIncludeSet(includeSet);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Set getIncludeSet() {
        return this.includeSet;
    }

    public void setIncludeSet(Set set) {
        this.includeSet = set;
        this.add(set);
    }

    public boolean add(Object otherSet) {
        if (!(otherSet instanceof Set)) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0021"));
        }
        this.clear();
        this.includeSet = (Set)otherSet;
        this.addElements(this.includeSet);
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getName());
        Iterator iter = this.iterator();
        int k = 0;
        while (iter.hasNext()) {
            if (k % 5 == 0) {
                buffer.append("\n");
            }
            buffer.append(" " + iter.next());
            ++k;
        }
        return buffer.toString();
    }

    private void addElements(Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Set) {
                this.addElements((Set)obj);
                continue;
            }
            super.add(obj);
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Set)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static void main(String[] args) throws Exception {
        TreeSet<Integer> os1 = new TreeSet<Integer>();
        os1.add(new Integer(5));
        os1.add(new Integer(4));
        os1.add(new Integer(3));
        os1.add(new Integer(2));
        os1.add(new Integer(1));
        TreeSet<Integer> os2 = new TreeSet<Integer>();
        os2.add(new Integer(15));
        os2.add(new Integer(14));
        os2.add(new Integer(13));
        os2.add(new Integer(12));
        os2.add(new Integer(11));
        ReferenceSet set1 = new ReferenceSet("Set of integers");
        set1.add(os1);
        System.out.println("\nSet1: " + set1);
        ReferenceSet set2 = new ReferenceSet("Set of set of integers");
        set2.add(set1);
        System.out.println("\nSet2: " + set2);
        ReferenceSet set3 = new ReferenceSet("Set of set of set of integers");
        set3.add(set2);
        System.out.println("\nSet3: " + set3);
        Iterator iter3 = set3.iterator();
        while (iter3.hasNext()) {
            System.out.println("  Element " + iter3.next());
        }
        RangeSet rs2 = new RangeSet();
        rs2.setRange(new Integer(10), new Integer(15));
        ReferenceSet set4 = new ReferenceSet("Range set");
        set4.add(set1);
        set4.add(rs2);
        System.out.println("\nSet4: " + set4);
        Iterator iter4 = set4.iterator();
        while (iter4.hasNext()) {
            System.out.println("  Element " + iter4.next());
        }
    }
}

