/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.exception;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.exception.LicenseException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.core.runtime.Platform;

public class InvalidLicenseException
extends LicenseException {
    public String productName;
    public String version;
    public String reason;
    public int daysToExpire;

    public InvalidLicenseException() {
    }

    public InvalidLicenseException(String p, String v, String reason) {
        super(reason);
        this.productName = p;
        this.version = v;
    }

    public InvalidLicenseException(String p, String v, int days) {
        this(p, v, InvalidLicenseException.getEffectivityInfo(p, v, days));
        this.daysToExpire = days;
    }

    private static String getEffectivityInfo(String productName, String version, int daysToExpire) {
        String msg = null;
        if (Platform.getProduct() == null) {
            msg = LicensePlugin.Util.getString("InvalidLicenseException.MetaMatrix_license_for_product");
        } else {
            String vendor = Platform.getProduct().getProperty("ownerName");
            msg = LicensePlugin.Util.getString("InvalidLicenseException.vendorLicenseForProduct", (Object)vendor);
        }
        StringBuffer buffer = new StringBuffer(msg);
        buffer.append(productName);
        buffer.append(LicensePlugin.Util.getString("InvalidLicenseException.version"));
        buffer.append(version);
        if (daysToExpire != Integer.MIN_VALUE) {
            if (daysToExpire == -1) {
                buffer.append(LicensePlugin.Util.getString("InvalidLicenseException.expired_1_day_ago"));
            } else {
                buffer.append(LicensePlugin.Util.getString("InvalidLicenseException.expired") + -daysToExpire + LicensePlugin.Util.getString("InvalidLicenseException.days_ago"));
            }
        } else {
            buffer.append(LicensePlugin.Util.getString("InvalidLicenseException.has_not_yet_become_effective"));
        }
        return buffer.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.productName = (String)in.readObject();
        this.version = (String)in.readObject();
        this.reason = (String)in.readObject();
        this.daysToExpire = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.productName);
        out.writeObject(this.version);
        out.writeObject(this.reason);
        out.writeInt(this.daysToExpire);
    }
}

