/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.util;

import com.metamatrix.license.util.HexInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class MessageIntegrityChecker {
    private static final String CERT_TYPE = "X.509";
    private static final String SIG_TYPE = "DSA";
    private InputStream messageStream;
    private X509Certificate certificate;
    private InputStream certificateStream;
    private Signature signature;
    private byte[] signatureBytes;

    public MessageIntegrityChecker() {
        try {
            this.signature = Signature.getInstance(SIG_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setMessage(String message) {
        this.setMessageStream(new ByteArrayInputStream(message.getBytes()));
    }

    public void setMessageStream(InputStream istream) {
        this.messageStream = istream;
    }

    public void setMessageStream(String filename) throws FileNotFoundException {
        this.setMessageStream(new FileInputStream(filename));
    }

    public void setCertificateStream(InputStream istream) {
        this.certificateStream = istream;
    }

    public void setCertificateStream(String filename) throws FileNotFoundException {
        this.setCertificateStream(new FileInputStream(filename));
    }

    public void setSignatureBytes(byte[] bytes) {
        this.signatureBytes = bytes;
    }

    public void setSignatureBytes(String encodedBytes) throws FileNotFoundException, IOException {
        HexInputStream is = new HexInputStream(new ByteArrayInputStream(encodedBytes.getBytes()));
        byte[] bytes = MessageIntegrityChecker.readAllBytes(is, true);
        ((InputStream)is).close();
        this.setSignatureBytes(bytes);
    }

    public void init() throws CertificateException, InvalidKeyException {
        this.loadCertificate();
        this.signature.initVerify(this.certificate.getPublicKey());
    }

    public boolean verify() throws SignatureException, IOException {
        this.loadMessage();
        return this.signature.verify(this.signatureBytes);
    }

    public void finish() {
        if (this.certificateStream != null) {
            try {
                this.certificateStream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        try {
            this.messageStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] readAllBytes(String filename, boolean encoded) throws FileNotFoundException, IOException {
        FileInputStream fileStream = new FileInputStream(filename);
        InputStream inStream = encoded ? new HexInputStream(fileStream) : fileStream;
        byte[] sigBytes = MessageIntegrityChecker.readAllBytes(inStream, encoded);
        inStream.close();
        return sigBytes;
    }

    private static byte[] readAllBytes(InputStream stream, boolean encoded) throws IOException {
        byte[] bytesTotal = new byte[]{};
        byte[] bytesRead = new byte[50];
        int numBytesRead = 0;
        while ((numBytesRead = encoded ? ((HexInputStream)stream).read(bytesRead) : stream.read(bytesRead)) != -1) {
            byte[] temp = new byte[bytesTotal.length + numBytesRead];
            System.arraycopy(bytesTotal, 0, temp, 0, bytesTotal.length);
            System.arraycopy(bytesRead, 0, temp, bytesTotal.length, numBytesRead);
            bytesTotal = temp;
        }
        return bytesTotal;
    }

    private void loadCertificate() throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(CERT_TYPE);
        this.certificate = (X509Certificate)cf.generateCertificate(this.certificateStream);
        try {
            this.certificateStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadMessage() throws SignatureException, IOException {
        int length;
        byte[] buffer = new byte[8192];
        while ((length = this.messageStream.read(buffer)) != -1) {
            this.signature.update(buffer, 0, length);
        }
    }

    public static void main(String[] args) throws Exception {
        String messageFile = args.length > 0 ? args[0] : null;
        String sigFile = args.length > 1 ? args[1] : null;
        String certFile = args.length > 2 ? args[2] : null;
        MessageIntegrityChecker ic = new MessageIntegrityChecker();
        ic.setCertificateStream(certFile);
        if (messageFile.indexOf(".") > 0) {
            ic.setMessageStream(messageFile);
        } else {
            ic.setMessage(messageFile);
        }
        ic.setSignatureBytes(MessageIntegrityChecker.readAllBytes(sigFile, true));
        ic.init();
        boolean ok = ic.verify();
        ic.finish();
        System.out.print("\nMessage file " + messageFile + " was ");
        if (!ok) {
            System.out.print("NOT ");
        }
        System.out.println("signed with the signature in " + sigFile + " using the certificate in " + certFile + ".\n");
    }
}

