/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.util;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.util.HexOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public class MessageSigner {
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String SIG_TYPE = "DSA";
    private KeyStore keyStore;
    private Signature signature = Signature.getInstance("DSA");
    private byte[] signatureBytes;
    private InputStream messageStream;

    public MessageSigner(String storeFile, char[] storePass, String entryName) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, InvalidKeyException, UnrecoverableKeyException, FileNotFoundException, IOException {
        this.loadKeyStore(storeFile, storePass);
        char[] entryPass = storePass;
        this.signature.initSign((PrivateKey)this.keyStore.getKey(entryName, entryPass));
    }

    public void setMessage(String message) {
        this.setMessageStream(new ByteArrayInputStream(message.getBytes()));
    }

    public void setMessageStream(InputStream istream) {
        this.messageStream = istream;
    }

    public void setMessageStream(String filename) throws FileNotFoundException {
        this.setMessageStream(new FileInputStream(filename));
    }

    public byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public String getSignatureString() {
        String sig = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.signatureBytes.length);
        try {
            MessageSigner.writeAllBytes(this.signatureBytes, baos, true);
            sig = baos.toString();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(LicensePlugin.Util.getString("ERR.003.016.0046"));
        }
        return sig;
    }

    public void init() {
    }

    public void sign() throws SignatureException, IOException {
        this.loadMessage();
        this.signatureBytes = this.signature.sign();
    }

    public void finish() {
        try {
            this.messageStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeAllBytes(byte[] bytes, String filename, boolean encoded) throws FileNotFoundException, IOException {
        FileOutputStream fileStream = new FileOutputStream(filename);
        MessageSigner.writeAllBytes(bytes, fileStream, encoded);
        ((OutputStream)fileStream).close();
    }

    public static void writeAllBytes(byte[] bytes, OutputStream stream, boolean encoded) throws IOException {
        OutputStream outStream = encoded ? new HexOutputStream(stream) : stream;
        outStream.write(bytes);
    }

    private void loadKeyStore(String keyStoreFile, char[] keyStorePass) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException {
        this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.keyStore.load(new FileInputStream(keyStoreFile), keyStorePass);
    }

    private void loadMessage() throws SignatureException, IOException {
        int length;
        byte[] buffer = new byte[8192];
        while ((length = this.messageStream.read(buffer)) != -1) {
            this.signature.update(buffer, 0, length);
        }
    }

    public static void main(String[] args) throws Exception {
        String messageFile = args.length > 0 ? args[0] : null;
        String sigFile = args.length > 1 ? args[1] : null;
        String storeFile = args.length > 2 ? args[2] : null;
        char[] storePass = args.length > 3 ? args[3].toCharArray() : null;
        String entryName = args.length > 4 ? args[4] : null;
        MessageSigner ls = new MessageSigner(storeFile, storePass, entryName);
        if (messageFile.indexOf(".") > 0) {
            ls.setMessageStream(messageFile);
        } else {
            ls.setMessage(messageFile);
        }
        ls.init();
        ls.sign();
        ls.finish();
        MessageSigner.writeAllBytes(ls.getSignatureBytes(), sigFile, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(ls.getSignatureBytes().length);
        MessageSigner.writeAllBytes(ls.getSignatureBytes(), baos, true);
        String sig1 = baos.toString();
        System.out.println("\nSignature using writeAllBytes:\n" + sig1 + "\n");
        String sig2 = ls.getSignatureString();
        System.out.println("Signature from convenience accessor:\n" + sig2 + "\n");
        if (sig1.equals(sig2)) {
            System.out.println("\nSignature strings match from both ways of getting.\n");
        } else {
            System.out.println("\nSignature strings DO NOT match!\n");
        }
    }
}

