/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xsd;

import com.metamatrix.core.util.ObjectVector;

public final class XsdHeader {
    private ObjectVector namespaceURIs = new ObjectVector();
    private ObjectVector importNamespaceURIs = new ObjectVector();
    private ObjectVector importSchemaLocations = new ObjectVector();
    private ObjectVector includeSchemaLocations = new ObjectVector();
    private String targetNamespaceURI = null;

    public String getTargetNamespaceURI() {
        return this.targetNamespaceURI;
    }

    public String[] getNamespaceURIs() {
        Object[] result = new String[this.namespaceURIs.size];
        this.namespaceURIs.copyInto(result);
        return result;
    }

    public String[] getImportNamespaces() {
        Object[] result = new String[this.importNamespaceURIs.size];
        this.importNamespaceURIs.copyInto(result);
        return result;
    }

    public String[] getImportSchemaLocations() {
        Object[] result = new String[this.importSchemaLocations.size];
        this.importSchemaLocations.copyInto(result);
        return result;
    }

    public String[] getIncludeSchemaLocations() {
        Object[] result = new String[this.includeSchemaLocations.size];
        this.includeSchemaLocations.copyInto(result);
        return result;
    }

    public void addNamespaceURI(String uri) {
        if (!this.namespaceURIs.contains((Object)uri)) {
            this.namespaceURIs.add((Object)uri);
        }
    }

    public void addImportNamespaceURI(String uri) {
        if (!this.importNamespaceURIs.contains((Object)uri)) {
            this.importNamespaceURIs.add((Object)uri);
        }
    }

    public void addImportSchemaLocation(String location) {
        if (!this.importSchemaLocations.contains((Object)location)) {
            this.importSchemaLocations.add((Object)location);
        }
    }

    public void addIncludeSchemaLocation(String location) {
        if (!this.includeSchemaLocations.contains((Object)location)) {
            this.includeSchemaLocations.add((Object)location);
        }
    }

    public void setTargetNamespaceURI(String uri) {
        this.targetNamespaceURI = uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Xsd Header:");
        sb.append("\n  targetNamespace:       ");
        sb.append(this.getTargetNamespaceURI());
        sb.append("\n  Namespace URIs:");
        String[] nsUris = this.getNamespaceURIs();
        for (int i = 0; i < nsUris.length; ++i) {
            sb.append("\n    ");
            sb.append(nsUris[i]);
        }
        sb.append("\n  Import Namespace URIs:");
        String[] imports = this.getImportNamespaces();
        for (int i = 0; i < imports.length; ++i) {
            sb.append("\n    ");
            sb.append(imports[i]);
        }
        sb.append("\n  Import Schema Locations:");
        String[] importLocs = this.getImportSchemaLocations();
        for (int i = 0; i < importLocs.length; ++i) {
            sb.append("\n    ");
            sb.append(importLocs[i]);
        }
        sb.append("\n  Include Schema Locations:");
        String[] includeLocs = this.getIncludeSchemaLocations();
        for (int i = 0; i < includeLocs.length; ++i) {
            sb.append("\n    ");
            sb.append(includeLocs[i]);
        }
        return sb.toString();
    }
}

