/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.util.HashCodeUtil;

public class ClassDefinition
implements Comparable {
    private String className;
    private String packageName;
    private Class c;
    int hashCode;

    public ClassDefinition(Class c) {
        this.c = c;
        String fullName = c.getName();
        int index = fullName.lastIndexOf(46);
        if (index > 0) {
            this.packageName = fullName.substring(0, index);
            this.className = ++index < fullName.length() ? fullName.substring(index) : "";
        } else {
            this.packageName = "";
        }
        this.hashCode = 0;
        this.hashCode = HashCodeUtil.hashCode((int)this.hashCode, (Object)c);
    }

    public String getFullName() {
        return this.c.getName();
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Class getClassObject() {
        return this.c;
    }

    public String toString() {
        return this.className;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0004", (Object)this.getClass().getName()));
        }
        if (!(obj instanceof ClassDefinition)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0005", new Object[]{obj.getClass().getName(), this.getClass().getName()}));
        }
        ClassDefinition that = (ClassDefinition)obj;
        return this.getFullName().compareTo(that.getFullName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassDefinition) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            ClassDefinition that = (ClassDefinition)obj;
            return that.getClassObject() == this.getClassObject();
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

