/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.impl.BatchMapValueTranslator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class BatchMap {
    private TreeMap batches = new TreeMap();
    private BatchMapValueTranslator translator;

    public BatchMap(BatchMapValueTranslator translator) {
        this.translator = translator;
    }

    public void addBatch(int beginRow, Object batch) {
        this.batches.put(new Integer(beginRow), batch);
    }

    public Object getBatch(int beginRow) {
        int batchSize = this.batches.size();
        if (batchSize == 0) {
            return null;
        }
        if (batchSize == 1) {
            Object batch = this.batches.values().iterator().next();
            if (beginRow >= this.translator.getBeginRow(batch) && beginRow <= this.translator.getEndRow(batch)) {
                return batch;
            }
            return null;
        }
        Object batch = this.batches.get(new Integer(beginRow));
        if (batch != null) {
            return batch;
        }
        ArrayList batchList = new ArrayList(this.batches.values());
        return this.doBinarySearchForBatch(batchList, beginRow);
    }

    public void removeBatch(int beginRow) {
        if (this.batches.isEmpty()) {
            return;
        }
        this.batches.remove(new Integer(beginRow));
    }

    public Iterator getBatchIterator() {
        return this.batches.values().iterator();
    }

    public boolean isEmpty() {
        return this.batches.isEmpty();
    }

    private Object doBinarySearchForBatch(List batches, int beginRow) {
        int batchSize = batches.size();
        int beginIndex = 0;
        int endIndex = batchSize;
        while (beginIndex < endIndex) {
            int midIndex = (beginIndex + endIndex) / 2;
            Object batch = batches.get(midIndex);
            if (beginRow < this.translator.getBeginRow(batch)) {
                endIndex = midIndex;
                continue;
            }
            if (beginRow > this.translator.getEndRow(batch)) {
                beginIndex = midIndex + 1;
                continue;
            }
            return batch;
        }
        return null;
    }
}

