/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class ComponentCryptoUtil {
    public static boolean checkPropertiesDecryptable(ComponentDefn defn, Collection componentTypeDefns) {
        boolean result = true;
        try {
            Properties properties = defn.getProperties();
            Iterator iter2 = componentTypeDefns.iterator();
            while (iter2.hasNext()) {
                ComponentTypeDefn componentTypeDefn = (ComponentTypeDefn)iter2.next();
                PropertyDefinition propertyDefinition = componentTypeDefn.getPropertyDefinition();
                String name = propertyDefinition.getName();
                String value = properties.getProperty(name);
                if (value == null || !propertyDefinition.isMasked()) continue;
                CryptoUtil.stringDecrypt(value.toCharArray());
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean checkPropertiesDecryptable(Properties props, Collection maskedPropertyNames) {
        boolean decryptable = true;
        if (maskedPropertyNames != null) {
            Iterator propItr = maskedPropertyNames.iterator();
            while (propItr.hasNext()) {
                String maskedPropName = (String)propItr.next();
                String maskedValue = null;
                if (props != null) {
                    maskedValue = props.getProperty(maskedPropName);
                }
                if (maskedValue == null) continue;
                try {
                    CryptoUtil.stringDecrypt(maskedValue.toCharArray());
                }
                catch (CryptoException err) {
                    decryptable = false;
                    break;
                }
            }
        }
        return decryptable;
    }
}

