/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.core.util.StringUtil;
import java.util.Iterator;
import java.util.List;

public class PropertyValidations {
    public static final String UDP_MCAST_ADDR_PROPERTY = "udp.mcast_addr";
    public static final String SYSTEM_NAME = "metamatrix.cluster.name";
    private static final String MULTICAST_PORT_FORMAT = "224.255.255.255";

    public void isPropertyValid(String key, String value) throws ConfigurationException {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase(UDP_MCAST_ADDR_PROPERTY)) {
            this.validate_multicast_port(key, value);
        }
        if (key.equalsIgnoreCase(SYSTEM_NAME)) {
            this.validate_nonnull_and_contiguous("System Name", key, value);
        }
    }

    protected void validate_multicast_port(String key, String value) throws ConfigurationException {
        List parts;
        if (value == null || value.trim().length() == 0) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_format", new Object[]{"MulticastPort", "Null", MULTICAST_PORT_FORMAT}));
        }
        if ((parts = StringUtil.getTokens((String)value, (String)".")).size() != 4) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_format", new Object[]{"MulticastPort", value, MULTICAST_PORT_FORMAT}));
        }
        this.validate_nonnull_and_contiguous("MulticastPort", key, value);
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            String part = (String)it.next();
            if (this.isInvalidNumeric(part)) {
                this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_numeric_value", new Object[]{part, ", must be between 0 and 255"}));
            }
            this.validate_port_range(key, part, 0, 255);
        }
    }

    protected void validate_port_range(String key, String value, int start, int end) throws ConfigurationException {
        if (value == null || value.trim().length() == 0) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_format", new Object[]{key, "Null", "Range " + start + " and " + end}));
        }
        Long nbr = null;
        try {
            nbr = new Long(value);
        }
        catch (NumberFormatException nfe) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_numeric_value", new Object[]{key, ", must be between " + start + " and " + end}));
        }
        if (nbr < (long)start || nbr > (long)end) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_numeric_value", new Object[]{key, ", must be between " + start + " and " + end}));
        }
    }

    protected void validate_nonnull_and_contiguous(String display, String key, String value) throws ConfigurationException {
        if (value == null || value.trim().length() == 0) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_contiguous_value", new Object[]{display}));
        }
        if (value.indexOf(" ") > 0) {
            this.throwException(CommonPlugin.Util.getString("PropertyValidation.Invalid_contiguous_value", new Object[]{display}));
        }
    }

    protected void throwException(String msg) throws ConfigurationException {
        throw new ConfigurationException(msg);
    }

    protected boolean isInvalidNumeric(String value) {
        try {
            new Long(value);
            return false;
        }
        catch (NumberFormatException nfe) {
            return true;
        }
    }
}

