/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.reader;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.reader.CurrentConfigurationInitializer;
import com.metamatrix.common.config.reader.CurrentConfigurationReader;
import com.metamatrix.common.properties.UnmodifiableProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileCurrentConfigurationReader
implements CurrentConfigurationReader {
    private InputStream inputStream;
    private String filename;
    private Configuration currentConfiguration = null;
    private Properties globalProperties = null;
    public static final String FILENAME = "metamatrix.config.readerFile";

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void connect(Properties env) throws ConfigurationConnectionException {
        this.filename = env.getProperty(FILENAME);
        if (this.filename == null || this.filename.trim().length() == 0) {
            throw new ConfigurationConnectionException("ERR.003.001.0062", CommonPlugin.Util.getString("ERR.003.001.0062"));
        }
        try {
            this.inputStream = this.getClass().getClassLoader().getResourceAsStream(this.filename);
        }
        catch (Exception e) {
            throw new ConfigurationConnectionException(e, "ERR.003.001.0063", CommonPlugin.Util.getString("ERR.003.001.0063", (Object)this.filename));
        }
        if (this.inputStream == null) {
            try {
                this.inputStream = new FileInputStream(this.filename);
            }
            catch (FileNotFoundException err) {
                throw new ConfigurationConnectionException("ERR.003.001.0064", CommonPlugin.Util.getString("ERR.003.001.0064", (Object)this.filename));
            }
        }
        if (this.inputStream == null) {
            throw new ConfigurationConnectionException("ERR.003.001.0064", CommonPlugin.Util.getString("ERR.003.001.0064", (Object)this.filename));
        }
        this.globalProperties = env;
    }

    public void close() throws Exception {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new ConfigurationException(e, "ERR.003.001.0065", CommonPlugin.Util.getString("ERR.003.001.0065", (Object)this.filename));
            }
            this.inputStream = null;
        }
    }

    public Properties getConfigurationProperties() throws ConfigurationException {
        if (this.currentConfiguration == null) {
            this.buildConfiguration();
        }
        return this.currentConfiguration.getProperties();
    }

    public Properties getStartupConfigurationProperties() throws ConfigurationException {
        if (this.currentConfiguration == null) {
            this.buildConfiguration();
        }
        return this.currentConfiguration.getProperties();
    }

    public String getComponentPropertyValue(ConfigurationID configID, String propertyName) throws ConfigurationException {
        if (this.currentConfiguration == null) {
            this.buildConfiguration();
        }
        String result = null;
        if (propertyName != null && configID.equals(this.currentConfiguration.getID())) {
            result = this.currentConfiguration.getProperties().getProperty(propertyName);
        }
        return result;
    }

    public Configuration getNextStartupConfiguration() throws ConfigurationException {
        if (this.currentConfiguration == null) {
            this.buildConfiguration();
        }
        return this.currentConfiguration;
    }

    public ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        throw new UnsupportedOperationException("Method getConfigurationModel is not implemented in FileCurrentConfigurationReader");
    }

    public Configuration getStartupConfiguration() throws ConfigurationException {
        throw new UnsupportedOperationException("Method getStartupConfigurationModel is not implemented in FileCurrentConfigurationReader");
    }

    public ConfigurationModelContainer getStartupConfigurationModel() throws ConfigurationException {
        throw new UnsupportedOperationException("Method getStartupConfigurationModel is not implemented in FileCurrentConfigurationReader");
    }

    public Collection getComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        if (this.inputStream == null) {
            throw new ConfigurationException("ERR.003.001.0063", CommonPlugin.Util.getString("ERR.003.001.0063"));
        }
        List result = Collections.EMPTY_LIST;
        return result;
    }

    public Collection getProductTypes() throws ConfigurationException {
        if (this.inputStream == null) {
            throw new ConfigurationException("ERR.003.001.0063", CommonPlugin.Util.getString("ERR.003.001.0063"));
        }
        List result = Collections.EMPTY_LIST;
        return result;
    }

    private void buildConfiguration() throws ConfigurationException {
        if (this.inputStream == null) {
            throw new ConfigurationException("ERR.003.001.0063", CommonPlugin.Util.getString("ERR.003.001.0063"));
        }
        Properties configProps = new Properties(this.globalProperties);
        if (this.inputStream != null) {
            try {
                configProps.load(this.inputStream);
            }
            catch (IOException e) {
                throw new ConfigurationException(e, "ERR.003.001.0067", CommonPlugin.Util.getString("ERR.003.001.0067", (Object)this.filename));
            }
        }
        configProps = new UnmodifiableProperties(configProps);
        BasicConfigurationObjectEditor coe = new BasicConfigurationObjectEditor(false);
        this.currentConfiguration = coe.createConfiguration(this.filename);
        try {
            this.currentConfiguration = (Configuration)coe.modifyProperties(this.currentConfiguration, configProps, 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new ConfigurationException(e, "ERR.003.001.0068", CommonPlugin.Util.getString("ERR.003.001.0068", (Object)this.filename));
        }
    }

    public Host getHost(HostID hostID) throws ConfigurationException {
        throw new UnsupportedOperationException("Method getHost is not implemented in FileCurrentConfigurationReader");
    }

    public CurrentConfigurationInitializer getInitializer() throws ConfigurationException {
        throw new UnsupportedOperationException("Method getInitializer is not implemented in FileCurrentConfigurationReader");
    }

    public Map getResourceProperties() throws ConfigurationException {
        return new HashMap();
    }

    public SharedResource getResource(String resourceName) throws ConfigurationException {
        return null;
    }
}

