/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.CleanUpThread;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.ManagedConnectionFactory;
import com.metamatrix.common.connection.TransactionInterface;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ManagedConnectionPool {
    public static final String FACTORY = "com.metamatrix.common.connection.ManagedConnectionPool.Factory";
    public static final String MAXIMUM_AGE = "com.metamatrix.common.connection.ManagedConnectionPool.MaximumAge";
    public static final String DEFAULT_MAXIMUM_AGE = "600000";
    public static final String MAXIMUM_CONCURRENT_USERS = "com.metamatrix.common.connection.ManagedConnectionPool.MaximumConcurrentUsers";
    public static final String DEFAULT_MAXIMUM_CONCURRENT_USERS = "1";
    public static final String MINIMUM_CONNECTIONS = "com.metamatrix.common.connection.ManagedConnectionPool.MinConnections";
    public static final String DEFAULT_MINIMUM_CONNECTIONS = "1";
    private static final long CLEANUP_TIME = 1200000L;
    private Properties environment;
    private Properties connectionProperties;
    private long maximumAge;
    private long minimumConnections;
    private int maximumConcurrentUsers;
    private ManagedConnectionFactory connectionFactory;
    private Set writeLockedConnections = Collections.synchronizedSet(new HashSet());
    private Set connectionsAvailableForRead = Collections.synchronizedSet(new HashSet());
    private Set unusedConnections = Collections.synchronizedSet(new HashSet());
    private CleanUpThread cleanerThread;
    private boolean shutdownRequested = false;

    protected void finalize() {
        this.shutdownPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionPool(Properties env, Properties connectionProperties) throws ManagedConnectionException {
        if (env == null) {
            this.environment = new Properties();
        } else {
            Properties properties = env;
            synchronized (properties) {
                this.environment = (Properties)env.clone();
            }
        }
        if (!(this.environment instanceof UnmodifiableProperties)) {
            this.environment = new UnmodifiableProperties(this.environment);
        }
        String connectionFactoryClassName = this.environment.getProperty(FACTORY);
        try {
            this.connectionFactory = (ManagedConnectionFactory)ReflectionHelper.create((String)connectionFactoryClassName, null, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new ManagedConnectionException(e);
        }
        String maximumAgeValue = this.environment.getProperty(MAXIMUM_AGE);
        if (maximumAgeValue == null) {
            maximumAgeValue = DEFAULT_MAXIMUM_AGE;
        }
        try {
            this.maximumAge = Long.parseLong(maximumAgeValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0007", new Object[]{maximumAgeValue, MAXIMUM_AGE}));
        }
        String minConnValue = this.environment.getProperty(MINIMUM_CONNECTIONS);
        if (minConnValue == null) {
            minConnValue = "1";
        }
        try {
            this.minimumConnections = Long.parseLong(minConnValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0007", new Object[]{minConnValue, MINIMUM_CONNECTIONS}));
        }
        String maximumConcurrentUsersValue = this.environment.getProperty(MAXIMUM_CONCURRENT_USERS);
        if (maximumConcurrentUsersValue == null) {
            maximumConcurrentUsersValue = "1";
        }
        try {
            this.maximumConcurrentUsers = Integer.parseInt(maximumConcurrentUsersValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0007", new Object[]{maximumConcurrentUsersValue, MAXIMUM_CONCURRENT_USERS}));
        }
        if (connectionProperties == null) {
            connectionProperties = new Properties();
        }
        this.connectionProperties = (Properties)connectionProperties.clone();
        if (!(this.connectionProperties instanceof UnmodifiableProperties)) {
            this.connectionProperties = new UnmodifiableProperties(this.connectionProperties);
        }
        this.cleanerThread = new CleanUpThread(this, 1200000L);
        this.cleanerThread.start();
    }

    public TransactionInterface getReadTransaction() throws ManagedConnectionException {
        ManagedConnection connection = this.checkOutForRead();
        return this.connectionFactory.createTransaction(this, connection, true);
    }

    public TransactionInterface getWriteTransaction() throws ManagedConnectionException {
        ManagedConnection connection = this.checkOutForWrite();
        return this.connectionFactory.createTransaction(this, connection, false);
    }

    public synchronized void shutdownPool() {
        this.shutdownRequested = true;
        this.cleanerThread.stopCleanup();
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Set set;
        Iterator iter = null;
        ArrayList<ManagedConnection> closeConns = null;
        if (this.shutdownRequested) {
            set = this.unusedConnections;
            synchronized (set) {
                closeConns = new ArrayList<ManagedConnection>(this.unusedConnections.size());
                ManagedConnection connection = null;
                iter = this.unusedConnections.iterator();
                while (iter.hasNext()) {
                    connection = (ManagedConnection)iter.next();
                    iter.remove();
                    closeConns.add(connection);
                }
            }
        }
        if ((long)this.unusedConnections.size() > this.minimumConnections) {
            set = this.unusedConnections;
            synchronized (set) {
                long maxTimeAllowed = System.currentTimeMillis() - this.maximumAge;
                closeConns = new ArrayList(this.unusedConnections.size());
                ManagedConnection connection = null;
                boolean gotMin = false;
                iter = this.unusedConnections.iterator();
                while (iter.hasNext()) {
                    connection = (ManagedConnection)iter.next();
                    if (!gotMin) {
                        gotMin = true;
                        continue;
                    }
                    ManagedConnection.ConnectionStatistics stats = connection.getStats();
                    if (stats.getLastUsed() >= maxTimeAllowed) continue;
                    iter.remove();
                    closeConns.add(connection);
                }
            }
        }
        ManagedConnection conn = null;
        if (closeConns != null && closeConns.size() > 0) {
            Iterator it = closeConns.iterator();
            while (it.hasNext()) {
                conn = (ManagedConnection)it.next();
                try {
                    conn.close();
                }
                catch (ManagedConnectionException e) {
                    LogManager.logError("RESOURCE_POOLING", CommonPlugin.Util.getString("ERR.003.010.0008", (Object)conn.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Protocol", "NoProtocol")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedConnection checkOutForRead() throws ManagedConnectionException {
        if (this.shutdownRequested) {
            throw new ManagedConnectionException("ERR.003.010.0009", CommonPlugin.Util.getString("ERR.003.010.0009"));
        }
        ManagedConnection connection = null;
        ManagedConnection.ConnectionStatistics stats = null;
        Set set = this.connectionsAvailableForRead;
        synchronized (set) {
            Iterator iter = this.connectionsAvailableForRead.iterator();
            if (iter.hasNext()) {
                connection = (ManagedConnection)iter.next();
                stats = connection.getStats();
                stats.addConcurrentUser();
                if (stats.getConcurrentUserCount() >= this.maximumConcurrentUsers) {
                    this.connectionsAvailableForRead.remove(connection);
                }
                return connection;
            }
            Set set2 = this.unusedConnections;
            synchronized (set2) {
                Iterator unusedIter = this.unusedConnections.iterator();
                if (unusedIter.hasNext()) {
                    connection = (ManagedConnection)unusedIter.next();
                    unusedIter.remove();
                }
            }
            if (connection == null) {
                connection = this.connectionFactory.createConnection(this.connectionProperties);
                connection.open();
            }
            connection.getStats().addConcurrentUser();
            if (this.maximumConcurrentUsers > 1) {
                this.connectionsAvailableForRead.add(connection);
            }
        }
        connection.open();
        connection.setForRead();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedConnection checkOutForWrite() throws ManagedConnectionException {
        if (this.shutdownRequested) {
            throw new ManagedConnectionException("ERR.003.010.0009", CommonPlugin.Util.getString("ERR.003.010.0009"));
        }
        ManagedConnection connection = null;
        Set set = this.unusedConnections;
        synchronized (set) {
            Iterator iter = this.unusedConnections.iterator();
            if (iter.hasNext()) {
                connection = (ManagedConnection)iter.next();
                iter.remove();
            }
        }
        if (connection == null) {
            connection = this.connectionFactory.createConnection(this.connectionProperties);
            connection.open();
        }
        set = this.writeLockedConnections;
        synchronized (set) {
            connection.getStats().addConcurrentUser();
            this.writeLockedConnections.add(connection);
        }
        connection.open();
        connection.setForWrite();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkInReadConnection(ManagedConnection connection) {
        boolean removed = false;
        ManagedConnection.ConnectionStatistics stats = null;
        Set set = this.connectionsAvailableForRead;
        synchronized (set) {
            stats = connection.getStats();
            stats.removeConcurrentUser();
            if (!stats.hasConcurrentUsers()) {
                this.connectionsAvailableForRead.remove(connection);
                removed = true;
                if (!this.shutdownRequested) {
                    Set set2 = this.unusedConnections;
                    synchronized (set2) {
                        this.unusedConnections.add(connection);
                    }
                }
            } else if (!this.shutdownRequested) {
                this.connectionsAvailableForRead.add(connection);
            }
        }
        if (removed && this.shutdownRequested) {
            try {
                connection.close();
            }
            catch (ManagedConnectionException e) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkInWriteConnection(ManagedConnection connection) {
        boolean found = false;
        Set set = this.writeLockedConnections;
        synchronized (set) {
            found = this.writeLockedConnections.remove(connection);
        }
        if (!found) {
            return false;
        }
        connection.getStats().removeConcurrentUser();
        if (this.shutdownRequested) {
            try {
                connection.close();
            }
            catch (ManagedConnectionException managedConnectionException) {}
        } else {
            set = this.unusedConnections;
            synchronized (set) {
                this.unusedConnections.add(connection);
            }
        }
        return true;
    }
}

