/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class ExtensionModuleInstallUtil {
    private static final String LOG_CONTEXT = "EXTENSION_MODULE";
    ExtensionModuleManager manager = null;

    public ExtensionModuleInstallUtil(Properties overrideResourceProps) {
        Properties props = overrideResourceProps;
        if (props == null) {
            props = new Properties();
        }
        Properties resourceProps = null;
        try {
            resourceProps = CurrentConfiguration.getResourceProperties("ExtensionSourceManager");
        }
        catch (Exception e) {
            LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0001"));
        }
        if (resourceProps != null) {
            boolean deepClone = true;
            boolean makeUnmodifiable = false;
            props = PropertiesUtils.clone(props, resourceProps, deepClone, makeUnmodifiable);
        }
        this.manager = ExtensionModuleManager.getInstance(props);
    }

    public ExtensionModuleDescriptor installExtensionModule(String fileName, String parentPath, String type, String principal) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        return this.installExtensionModule(fileName, parentPath, type, principal, null, fileName);
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor installExtensionModule(String fileName, String parentPath, String type, String principal, String description, String alternateName) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleDescriptor esd;
        block12: {
            InputStream stream;
            block11: {
                ArgCheck.isNotNull((Object)fileName);
                ArgCheck.isNotNull((Object)parentPath);
                ArgCheck.isNotNull((Object)principal);
                ArgCheck.isNotNull((Object)type);
                ArgCheck.isNotZeroLength((String)type);
                ArgCheck.isNotZeroLength((String)principal);
                ArgCheck.isNotZeroLength((String)fileName);
                ArgCheck.isNotZeroLength((String)parentPath);
                if (alternateName == null) {
                    alternateName = fileName;
                }
                stream = null;
                byte[] data = null;
                esd = null;
                File aFile = new File(parentPath, fileName);
                stream = new FileInputStream(aFile);
                int size = (int)aFile.length();
                data = ByteArrayHelper.toByteArray(stream, size + 1);
                if (this.manager.isSourceInUse(alternateName)) {
                    esd = this.manager.setSource(principal, alternateName, data);
                    break block11;
                }
                esd = this.manager.addSource(principal, type, alternateName, data, description, true);
            }
            Object var13_13 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block12;
            }
            catch (IOException e) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block12;
            {
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0002", (Object)fileName));
                    throw new MetaMatrixComponentException(e);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
        return esd;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor installExtensionModule(String fileFullPath, String type, String principal, String description, String assignedName) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleDescriptor esd;
        block11: {
            InputStream stream;
            block10: {
                ArgCheck.isNotNull((Object)fileFullPath);
                ArgCheck.isNotNull((Object)type);
                ArgCheck.isNotNull((Object)principal);
                ArgCheck.isNotNull((Object)assignedName);
                ArgCheck.isNotNull((Object)description);
                ArgCheck.isNotZeroLength((String)fileFullPath);
                ArgCheck.isNotZeroLength((String)type);
                ArgCheck.isNotZeroLength((String)principal);
                ArgCheck.isNotZeroLength((String)assignedName);
                ArgCheck.isNotZeroLength((String)description);
                stream = null;
                byte[] data = null;
                esd = null;
                File aFile = new File(fileFullPath);
                stream = new FileInputStream(aFile);
                int size = (int)aFile.length();
                data = ByteArrayHelper.toByteArray(stream, size + 1);
                if (this.manager.isSourceInUse(assignedName)) {
                    esd = this.manager.setSource(principal, assignedName, data);
                    break block10;
                }
                esd = this.manager.addSource(principal, type, assignedName, data, description, true);
            }
            Object var12_12 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block11;
            }
            catch (IOException e) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block11;
            {
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0002", (Object)fileFullPath));
                    throw new MetaMatrixComponentException(e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
        return esd;
    }

    /*
     * Loose catch block
     */
    public void updateExtensionModule(String fileFullPath, String sourceName, String principal) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block10: {
            ArgCheck.isNotNull((Object)fileFullPath);
            ArgCheck.isNotNull((Object)principal);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)fileFullPath);
            ArgCheck.isNotZeroLength((String)principal);
            ArgCheck.isNotZeroLength((String)sourceName);
            InputStream stream = null;
            byte[] data = null;
            File aFile = new File(fileFullPath);
            data = ByteArrayHelper.toByteArray(aFile);
            if (!this.manager.isSourceInUse(sourceName)) {
                throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", (Object)sourceName));
            }
            this.manager.setSource(principal, sourceName, data);
            Object var8_8 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block10;
            }
            catch (IOException e) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block10;
            {
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0002", (Object)fileFullPath));
                    throw new MetaMatrixComponentException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
    }

    public ExtensionModuleDescriptor exportExtensionModule(OutputStream outputStream, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        source = this.manager.getSourceDescriptor(sourceName);
        byte[] data = this.manager.getSource(sourceName);
        if (data == null || data.length == 0) {
            throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", (Object)sourceName));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream is = new BufferedInputStream(bais);
        try {
            int bytesRead;
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = ((InputStream)is).read(buff, 0, buff.length))) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0005", CommonPlugin.Util.getString("ERR.014.004.0005", (Object)sourceName));
        }
        return source;
    }

    public ExtensionModuleDescriptor exportExtensionModule(String outputFileName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        source = this.manager.getSourceDescriptor(sourceName);
        byte[] data = this.manager.getSource(sourceName);
        if (data == null || data.length == 0) {
            throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", (Object)sourceName));
        }
        try {
            FileUtils.write((byte[])data, (String)outputFileName);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", (Object)sourceName, (Object)outputFileName));
        }
        return source;
    }

    public List exportExtensionModulesOfType(String type, String outputDirectory) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        String sourceName = "";
        String outputfile = "";
        try {
            List sds = this.manager.getSourceDescriptors(type);
            if (sds == null) {
                return Collections.EMPTY_LIST;
            }
            Iterator it = sds.iterator();
            while (it.hasNext()) {
                source = (ExtensionModuleDescriptor)it.next();
                sourceName = source.getName();
                outputfile = FileUtils.buildDirectoryPath((String[])new String[]{outputDirectory != null ? outputDirectory : "", sourceName});
                this.exportExtensionModule(outputfile, source.getName());
            }
            return sds;
        }
        catch (ExtensionModuleNotFoundException notFound) {
            throw notFound;
        }
        catch (MetaMatrixComponentException compException) {
            throw compException;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", (Object)sourceName, (Object)outputfile));
        }
    }

    public void removeExtensionModule(String extensionName, String principal) throws ExtensionModuleNotFoundException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ArgCheck.isNotNull((Object)extensionName);
        ArgCheck.isNotZeroLength((String)extensionName);
        try {
            if (!this.manager.isSourceInUse(extensionName)) {
                throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", (Object)extensionName));
            }
            this.manager.removeSource(principal, extensionName);
        }
        catch (ExtensionModuleNotFoundException ne) {
            throw ne;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0071", CommonPlugin.Util.getString("ERR.014.004.0071", (Object)extensionName));
        }
    }
}

