/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.file;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.common.extensionmodule.spi.file.FileEMDescriptor;
import com.metamatrix.common.extensionmodule.spi.file.FileExtensionModulePropertyNames;
import com.metamatrix.common.extensionmodule.spi.file.ManifestFile;
import com.metamatrix.common.util.ByteArrayHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FileExtensionModuleTransaction
extends BaseTransaction
implements ExtensionModuleTransaction,
FileExtensionModulePropertyNames {
    private static final String READ_ONLY_MSG = CommonPlugin.Util.getString("ERR.014.004.0038");
    private String parentDirectory = CurrentConfiguration.getProperty("metamatrix.extensionsource.file.HomeDirectory");
    private String manifestFilename;
    private ManifestFile manifestFile;

    FileExtensionModuleTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
        if (this.parentDirectory == null) {
            throw new ManagedConnectionException("ERR.014.004.0039", CommonPlugin.Util.getString("ERR.014.004.0039", (Object)"metamatrix.extensionsource.file.HomeDirectory"));
        }
        this.manifestFilename = CurrentConfiguration.getProperty("metamatrix.extensionsource.file.ManifestFilename");
        if (this.manifestFilename == null) {
            this.manifestFilename = "manifest.txt";
        }
    }

    public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] source, long checksum, String description, boolean enabled) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public List getSourceNames() throws MetaMatrixComponentException {
        Iterator i = this.getManifestFile().getOrderedDescriptors().iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (i.hasNext()) {
            FileEMDescriptor desc = (FileEMDescriptor)i.next();
            result.add(desc.name);
        }
        return result;
    }

    public List getSourceDescriptors() throws MetaMatrixComponentException {
        return new ArrayList(this.getManifestFile().getOrderedDescriptors());
    }

    public List getSourceDescriptors(String type, boolean includeDisabled) throws MetaMatrixComponentException {
        Iterator i = this.getManifestFile().getOrderedDescriptors().iterator();
        ArrayList<FileEMDescriptor> result = new ArrayList<FileEMDescriptor>();
        while (i.hasNext()) {
            FileEMDescriptor desc = (FileEMDescriptor)i.next();
            if (!desc.type.equals(type) || !includeDisabled && !desc.enabled) continue;
            result.add(desc);
        }
        return result;
    }

    public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        return this.getManifestFile().getDescriptor(sourceName);
    }

    public void setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public void setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        byte[] byArray;
        FileInputStream stream = null;
        try {
            try {
                File sourceFile = new File(this.parentDirectory, sourceName);
                if (!sourceFile.exists()) {
                    throw new ExtensionModuleNotFoundException(sourceName);
                }
                stream = new FileInputStream(sourceFile);
                int size = (int)sourceFile.length();
                byArray = ByteArrayHelper.toByteArray(stream, size + 1);
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException(e, "ERR.014.004.0040", CommonPlugin.Util.getString("ERR.014.004.0040", (Object)sourceName));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return byArray;
        }
        if (stream == null) return byArray;
        stream.close();
        return byArray;
    }

    public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] source, long checksum) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        throw new UnsupportedOperationException(READ_ONLY_MSG);
    }

    public boolean needsRefresh() throws MetaMatrixComponentException {
        try {
            return this.getManifestFile().synch();
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0041", CommonPlugin.Util.getString("ERR.014.004.0041"));
        }
        catch (NumberFormatException e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0042", CommonPlugin.Util.getString("ERR.014.004.0042"));
        }
    }

    private ManifestFile getManifestFile() throws MetaMatrixComponentException {
        if (this.manifestFile == null) {
            this.manifestFile = new ManifestFile(this.parentDirectory, this.manifestFilename);
            try {
                this.manifestFile.init();
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException(e, "ERR.014.004.0043", CommonPlugin.Util.getString("ERR.014.004.0043"));
            }
            catch (NumberFormatException e) {
                throw new MetaMatrixComponentException(e, "ERR.014.004.0043", CommonPlugin.Util.getString("ERR.014.004.0043"));
            }
        }
        return this.manifestFile;
    }

    public boolean isNameInUse(String sourceName) throws MetaMatrixComponentException {
        File sourceFile = new File(this.parentDirectory, sourceName);
        return sourceFile.exists();
    }
}

