/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.jdbc.metadata.Column;
import com.metamatrix.common.jdbc.metadata.JDBCObject;
import com.metamatrix.common.jdbc.metadata.Table;
import com.metamatrix.core.util.ArgCheck;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ColumnSet
extends JDBCObject {
    private String catalogName;
    private String schemaName;
    private List columns = new LinkedList();
    static /* synthetic */ Class class$com$metamatrix$common$jdbc$metadata$Column;

    protected ColumnSet() {
    }

    protected ColumnSet(String name) {
        super(name);
    }

    public ColumnSet(String catalogName, String schemaName, String name) {
        this(name);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List getColumns() {
        return this.columns;
    }

    public void add(Column object) {
        this.addColumn(object, false);
    }

    public void addAll(Collection columns) {
        Iterator it = columns.iterator();
        while (it.hasNext()) {
            this.addColumn((Column)it.next(), false);
        }
    }

    public boolean remove(Column object) {
        return this.removeColumn(object, false);
    }

    protected void addColumn(Column object, boolean takeOwnership) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Column reference may not be null");
        }
        if (!this.columns.contains(object)) {
            this.columns.add(object);
            if (takeOwnership) {
                object.setOwner(this);
            }
        }
    }

    protected boolean removeColumn(Column object, boolean releaseOwnership) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Column reference may not be null");
        }
        if (object.getOwner() != this) {
            ArgCheck.isTrue((object.getOwner() == this ? 1 : 0) != 0, (String)"The specified object is not contained by this object");
        }
        if (releaseOwnership) {
            object.setOwner(null);
        }
        return this.columns.remove(object);
    }

    public Column lookupColumn(String columnName) {
        return (Column)JDBCObject.lookupJDBCObject(this.getColumns(), columnName, class$com$metamatrix$common$jdbc$metadata$Column == null ? (class$com$metamatrix$common$jdbc$metadata$Column = ColumnSet.class$("com.metamatrix.common.jdbc.metadata.Column")) : class$com$metamatrix$common$jdbc$metadata$Column);
    }

    public boolean contains(Column object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Column reference may not be null");
        }
        return this.columns.contains(object);
    }

    protected String getColumnNames() {
        JDBCObject obj;
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.columns.iterator();
        if (iter.hasNext()) {
            obj = (JDBCObject)iter.next();
            sb.append(obj.getName());
        }
        while (iter.hasNext()) {
            obj = (JDBCObject)iter.next();
            sb.append(',');
            sb.append(obj.getName());
        }
        return sb.toString();
    }

    public boolean hasMatchingColumns(ColumnSet matchingSet) {
        if (this.getColumns().size() != matchingSet.getColumns().size()) {
            return false;
        }
        Iterator thisIter = this.columns.iterator();
        Iterator thatIter = matchingSet.columns.iterator();
        while (thisIter.hasNext()) {
            Column thisCol = (Column)thisIter.next();
            Column thatCol = (Column)thatIter.next();
            if (!thisCol.getName().equals(thatCol.getName())) continue;
            return true;
        }
        return false;
    }

    boolean generateUniqueName(String prefix) {
        Column column;
        if (this.hasName()) {
            return false;
        }
        super.setOriginalNameNull(true);
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            sb.append(prefix);
        }
        String baseName = sb.toString();
        Iterator iter = this.getColumns().iterator();
        if (iter.hasNext()) {
            column = (Column)iter.next();
            sb.append(column.getName());
        }
        while (iter.hasNext()) {
            column = (Column)iter.next();
            sb.append('_');
            sb.append(column.getName());
        }
        String potentialName = null;
        if (this.hasOwner()) {
            Table owner = (Table)this.getOwner();
            potentialName = baseName + owner.getName();
            if (potentialName != null) {
                baseName = potentialName;
                int counter = 0;
                while (owner.lookupUniqueKey(potentialName) != null) {
                    potentialName = baseName + ++counter;
                }
            }
        } else {
            potentialName = sb.toString();
        }
        this.setName(potentialName);
        return true;
    }

    public String getFullName() {
        String name = super.getFullName();
        if (name.indexOf(".") < 0) {
            StringBuffer buf = new StringBuffer(0);
            if (this.catalogName != null && this.catalogName.length() > 0) {
                buf.append(this.catalogName);
                buf.append(".");
            }
            if (this.schemaName != null && this.schemaName.length() > 0) {
                buf.append(this.schemaName);
                buf.append(".");
            }
            buf.append(name);
            return buf.toString();
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

