/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.jdbc.metadata.Column;
import com.metamatrix.common.jdbc.metadata.ColumnSet;
import com.metamatrix.common.jdbc.metadata.ForeignKey;
import com.metamatrix.common.jdbc.metadata.Index;
import com.metamatrix.common.jdbc.metadata.IndexType;
import com.metamatrix.common.jdbc.metadata.JDBCObject;
import com.metamatrix.common.jdbc.metadata.UniqueKey;
import com.metamatrix.core.util.ArgCheck;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Table
extends ColumnSet {
    public static final int NO_CARDINALITY = -1;
    private String type;
    private String remarks;
    private final List uniqueKeys = new LinkedList();
    private final List foreignKeys = new LinkedList();
    private final List indexes = new LinkedList();
    private final List privileges = new LinkedList();
    private int cardinality = -1;
    static /* synthetic */ Class class$com$metamatrix$common$jdbc$metadata$Index;
    static /* synthetic */ Class class$com$metamatrix$common$jdbc$metadata$UniqueKey;
    static /* synthetic */ Class class$com$metamatrix$common$jdbc$metadata$ForeignKey;

    public Table() {
    }

    public Table(String name) {
        super(name);
    }

    public Table(String catalogName, String schemaName, String name) {
        super(catalogName, schemaName, name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void addAll(Collection tableEntities) {
        Iterator it = tableEntities.iterator();
        while (it.hasNext()) {
            Object entity = it.next();
            if (entity instanceof Column) {
                this.add((Column)entity);
                continue;
            }
            if (entity instanceof ForeignKey) {
                this.add((ForeignKey)entity);
                continue;
            }
            if (entity instanceof UniqueKey) {
                this.add((UniqueKey)entity);
                continue;
            }
            if (!(entity instanceof Index)) continue;
            this.add((Index)entity);
        }
    }

    public void add(Column object) {
        super.addColumn(object, true);
    }

    public boolean remove(Column object) {
        return super.removeColumn(object, true);
    }

    public List getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void add(UniqueKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The UniqueKey reference may not be null");
        }
        if (!this.uniqueKeys.contains(object)) {
            Iterator iter = object.getColumns().iterator();
            while (iter.hasNext()) {
                JDBCObject obj = (JDBCObject)iter.next();
                if (!obj.hasOwner() || obj.getOwner() == this) continue;
                ArgCheck.isTrue((boolean)false, (String)"The UniqueKey contains columns that are not owned by this table");
            }
            this.uniqueKeys.add(object);
            object.setOwner(this);
        }
    }

    public boolean remove(UniqueKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The UniqueKey reference may not be null");
        }
        if (object.getOwner() != this) {
            ArgCheck.isTrue((object.getOwner() == this ? 1 : 0) != 0, (String)"The specified object is not contained by this object");
        }
        object.setOwner(null);
        return this.uniqueKeys.remove(object);
    }

    public boolean contains(UniqueKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The UniqueKey reference may not be null");
        }
        return this.uniqueKeys.contains(object);
    }

    public boolean hasUniqueKeys() {
        return this.uniqueKeys.size() != 0;
    }

    public List getForeignKeys() {
        return this.foreignKeys;
    }

    public void add(ForeignKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The ForeignKey reference may not be null");
        }
        if (!this.foreignKeys.contains(object)) {
            Iterator iter = object.getColumns().iterator();
            while (iter.hasNext()) {
                JDBCObject obj = (JDBCObject)iter.next();
                if (!obj.hasOwner() || obj.getOwner() == this) continue;
                ArgCheck.isTrue((boolean)false, (String)"The ForeignKey contains columns that are not owned by this table");
            }
            this.foreignKeys.add(object);
            object.setOwner(this);
        }
    }

    public boolean remove(ForeignKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The ForeignKey reference may not be null");
        }
        if (object.getOwner() != this) {
            ArgCheck.isTrue((object.getOwner() == this ? 1 : 0) != 0, (String)"The specified object is not contained by this object");
        }
        object.setOwner(null);
        return this.foreignKeys.remove(object);
    }

    public boolean contains(ForeignKey object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The ForeignKey reference may not be null");
        }
        return this.foreignKeys.contains(object);
    }

    public boolean hasForeignKeys() {
        return this.foreignKeys.size() != 0;
    }

    public List getIndexes() {
        return this.indexes;
    }

    public void add(Index object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Index reference may not be null");
        }
        if (!this.indexes.contains(object)) {
            this.indexes.add(object);
        }
    }

    public boolean remove(Index object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Index reference may not be null");
        }
        return this.indexes.remove(object);
    }

    public boolean contains(Index object) {
        if (object == null) {
            ArgCheck.isNotNull((Object)object, (String)"The Index reference may not be null");
        }
        return this.indexes.contains(object);
    }

    public boolean hasIndexes() {
        return this.indexes.size() != 0;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality < 0 ? -1 : cardinality;
    }

    public int getCardinality() {
        if (this.cardinality != -1) {
            return this.cardinality;
        }
        List indexes = this.getIndexes();
        if (indexes.size() != 0) {
            int maxCardinality = 0;
            Iterator iter = indexes.iterator();
            while (iter.hasNext()) {
                Index index = (Index)iter.next();
                if (index.getType().equals(IndexType.STATISTIC)) {
                    return index.getCardinality();
                }
                maxCardinality = Math.max(maxCardinality, index.getCardinality());
            }
            return maxCardinality;
        }
        return -1;
    }

    public void addPrivilege(String privilege) {
        if (privilege != null && !this.privileges.contains(privilege)) {
            this.privileges.add(privilege);
        }
    }

    public boolean removePrivilege(String privilege) {
        if (privilege != null) {
            return this.privileges.remove(privilege);
        }
        return false;
    }

    public boolean hasPrivilege(String privilege) {
        return this.hasPrivilege(privilege, true);
    }

    public boolean hasPrivilege(String privilege, boolean caseSensitive) {
        if (privilege != null) {
            if (caseSensitive) {
                return this.privileges.contains(privilege);
            }
            Iterator iter = this.privileges.iterator();
            while (iter.hasNext()) {
                String priv = (String)iter.next();
                if (!privilege.equalsIgnoreCase(priv)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Index lookupIndex(String indexName) {
        return (Index)JDBCObject.lookupJDBCObject(this.getIndexes(), indexName, class$com$metamatrix$common$jdbc$metadata$Index == null ? (class$com$metamatrix$common$jdbc$metadata$Index = Table.class$("com.metamatrix.common.jdbc.metadata.Index")) : class$com$metamatrix$common$jdbc$metadata$Index);
    }

    public UniqueKey lookupUniqueKey(String keyName) {
        return (UniqueKey)JDBCObject.lookupJDBCObject(this.getUniqueKeys(), keyName, class$com$metamatrix$common$jdbc$metadata$UniqueKey == null ? (class$com$metamatrix$common$jdbc$metadata$UniqueKey = Table.class$("com.metamatrix.common.jdbc.metadata.UniqueKey")) : class$com$metamatrix$common$jdbc$metadata$UniqueKey);
    }

    public UniqueKey lookupUniqueKey(UniqueKey matchingKey) {
        if (matchingKey == null) {
            ArgCheck.isNotNull((Object)matchingKey, (String)"The UniqueKey used for lookup may not be null");
        }
        Iterator iter = this.getUniqueKeys().iterator();
        while (iter.hasNext()) {
            UniqueKey uk = (UniqueKey)iter.next();
            if (!matchingKey.hasMatchingColumns(uk)) continue;
            return uk;
        }
        if (matchingKey.getName() != null && matchingKey.getName().length() != 0) {
            return this.lookupUniqueKey(matchingKey.getName());
        }
        return null;
    }

    public ForeignKey lookupForeignKey(String keyName) {
        return (ForeignKey)JDBCObject.lookupJDBCObject(this.getForeignKeys(), keyName, class$com$metamatrix$common$jdbc$metadata$ForeignKey == null ? (class$com$metamatrix$common$jdbc$metadata$ForeignKey = Table.class$("com.metamatrix.common.jdbc.metadata.ForeignKey")) : class$com$metamatrix$common$jdbc$metadata$ForeignKey);
    }

    public ForeignKey lookupForeignKey(ForeignKey matchingKey) {
        if (matchingKey == null) {
            ArgCheck.isNotNull((Object)matchingKey, (String)"The ForeignKey used for lookup may not be null");
        }
        Iterator iter = this.getForeignKeys().iterator();
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            if (!matchingKey.hasMatchingColumns(fk)) continue;
            return fk;
        }
        if (matchingKey.getName() != null && matchingKey.getName().length() != 0) {
            return this.lookupForeignKey(matchingKey.getName());
        }
        return null;
    }

    public void print(PrintStream stream) {
        this.print(stream, "  ");
    }

    public void print(PrintStream stream, String lead) {
        super.print(stream, lead);
        JDBCObject child = null;
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            child = (JDBCObject)iter.next();
            child.print(stream, lead + "  ");
        }
        iter = this.getUniqueKeys().iterator();
        while (iter.hasNext()) {
            child = (JDBCObject)iter.next();
            child.print(stream, lead + "  ");
        }
        iter = this.getForeignKeys().iterator();
        while (iter.hasNext()) {
            child = (JDBCObject)iter.next();
            child.print(stream, lead + "  ");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

