/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.MultiplicityExpressionException;
import com.metamatrix.common.object.MultiplicityHolder;
import com.metamatrix.common.util.exception.AssertionException;
import java.util.HashMap;
import java.util.Map;

public class MultiplicityPool {
    private static Map INSTANCES = new HashMap();
    public static final Multiplicity UNBOUNDED = Multiplicity.UNBOUNDED;
    public static final Multiplicity ZERO_OR_ONE = Multiplicity.getInstance(0, 1);
    public static final Multiplicity ONLY_ONE = Multiplicity.getInstance(1);
    public static final Multiplicity ONE_OR_MORE = Multiplicity.getInstance(1, Integer.MAX_VALUE);

    public static Multiplicity get(String multiplicityValue, boolean isOrdered, boolean isUnique) throws MultiplicityExpressionException {
        if (multiplicityValue == null) {
            throw new AssertionException("ERR.003.019.0013", CommonPlugin.Util.getString("ERR.003.019.0013"));
        }
        MultiplicityHolder key = new MultiplicityHolder(multiplicityValue, isOrdered, isUnique);
        Multiplicity result = (Multiplicity)INSTANCES.get(key);
        if (result == null) {
            result = Multiplicity.getInstance(multiplicityValue, isOrdered, isUnique);
            INSTANCES.put(key, result);
        }
        return result;
    }

    public static Multiplicity get(String multiplicityValue) throws MultiplicityExpressionException {
        return MultiplicityPool.get(multiplicityValue, false, false);
    }

    static {
        try {
            INSTANCES.put(new MultiplicityHolder(UNBOUNDED.toString(), UNBOUNDED.isOrdered(), UNBOUNDED.isUnique()), UNBOUNDED);
            INSTANCES.put(new MultiplicityHolder(ZERO_OR_ONE.toString(), ZERO_OR_ONE.isOrdered(), ZERO_OR_ONE.isUnique()), ZERO_OR_ONE);
            INSTANCES.put(new MultiplicityHolder(ONLY_ONE.toString(), ONLY_ONE.isOrdered(), ONLY_ONE.isUnique()), ONLY_ONE);
            INSTANCES.put(new MultiplicityHolder(ONE_OR_MORE.toString(), ONE_OR_MORE.isOrdered(), ONE_OR_MORE.isUnique()), ONE_OR_MORE);
            MultiplicityPool.get("0..*");
        }
        catch (MultiplicityExpressionException multiplicityExpressionException) {
            // empty catch block
        }
    }
}

