/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.impl.ResourcePoolMgrImpl;
import java.rmi.RemoteException;
import java.util.Properties;

public final class ResourceHelper {
    private static final ResourcePoolMgrImpl mgr;
    private static BasicConfigurationObjectEditor editor;

    public static Resource getResource(Properties properties, String userName) throws ResourcePoolException {
        String poolName = properties.getProperty("metamatrix.common.pooling.resource.name");
        if (poolName == null) {
            throw new ResourcePoolException("ERR.003.002.0001");
        }
        return ResourceHelper.getResource(poolName, userName);
    }

    public static Resource getResource(String poolName, String userName) throws ResourcePoolException {
        ResourceDescriptor descriptor = ResourceHelper.getDescriptor(poolName);
        return ResourceHelper.getResourceFromPool(descriptor, userName);
    }

    static ResourceDescriptor getDescriptor(String poolName) throws ResourcePoolException {
        ResourceDescriptor descriptor = null;
        try {
            descriptor = CurrentConfiguration.getResourceDescriptor(poolName);
            if (descriptor == null) {
                throw new ResourcePoolException("ERR.003.002.0002");
            }
        }
        catch (Exception e) {
            throw new ResourcePoolException(e, CommonPlugin.Util.getString("ERR.003.002.0003", (Object)poolName));
        }
        return descriptor;
    }

    static ResourceDescriptor createDescriptor(ConfigurationID configID, ComponentTypeID resourceTypeID, String poolName, Properties properties) throws ResourcePoolException {
        ResourceDescriptor descriptor = editor.createResourceDescriptor(configID, resourceTypeID, poolName);
        descriptor = (ResourceDescriptor)editor.modifyProperties(descriptor, properties, 1);
        return descriptor;
    }

    public static Resource getResourceFromPool(ResourceDescriptor descriptor, String userName) throws ResourcePoolException {
        try {
            return mgr.getResource(descriptor, userName);
        }
        catch (RemoteException e) {
            throw new ResourcePoolException(e, CommonPlugin.Util.getString("ERR.003.002.0004", (Object)descriptor.getName()));
        }
    }

    static {
        editor = null;
        mgr = new ResourcePoolMgrImpl();
        editor = new BasicConfigurationObjectEditor();
    }
}

