/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.api;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceAdapter;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.ResourcePoolStatistics;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import java.util.Collection;
import java.util.Properties;

public interface ResourcePool {
    public static final String RESOURCE_POOL = "metamatrix.common.pooling.resource.name";
    public static final String JDBC_SHARED_CONNECTION_POOL = "JDBC Shared Connection Pool";

    public void init(ResourceDescriptor var1) throws ResourcePoolException;

    public ResourceDescriptorID getResourceDescriptorID();

    public ComponentTypeID getComponentTypeID();

    public int getResourcePoolSize();

    public Resource checkOut(String var1) throws ResourcePoolException;

    public void checkIn(ResourceContainer var1, String var2) throws ResourcePoolException;

    public ResourceDescriptor getResourceDescriptor();

    public ResourcePoolStatistics getResourcePoolStatistics();

    public Collection getPoolResourceStatistics();

    public ResourceAdapter getResourceAdapter();

    public void shutDown();

    public void update(Properties var1) throws ResourcePoolException;

    public static interface Defaults {
        public static final String DEFAULT_MINIMUM_RESOURCE_SIZE = "1";
        public static final String DEFAULT_MAXIMUM_RESOURCE_SIZE = "5";
        public static final String DEFAULT_NUM_OF_CONCURRENT_USERS = "1";
        public static final String DEFAULT_LIVE_AND_UNUSED_TIME = "600000";
        public static final String DEFAULT_SHRINK_PERIOD = "300000";
        public static final String DEFAULT_ALLOW_SHRINKING = "true";
        public static final String DEFAULT_SHRINK_INCREMENT = "0";
        public static final String DEFAULT_WAIT_FOR_RESOURCE_TIME = "30000";
        public static final String DEFAULT_EXTEND_MODE = "false";
        public static final String DEFAULT_EXTEND_PERCENT = "1.000";
        public static final String UNLIMITED_NUM_OF_CONCURRENT_USERS = "-1";
    }
}

