/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.pooling.api.PoolStatistic;
import com.metamatrix.common.pooling.api.ResourcePool;
import com.metamatrix.common.pooling.api.ResourcePoolStatistics;
import com.metamatrix.common.pooling.impl.BasicPoolStatistic;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BasicResourcePoolStatistics
implements ResourcePoolStatistics,
Serializable {
    private ResourceDescriptorID id;
    private ComponentTypeID typeId;
    private Map stats;

    public BasicResourcePoolStatistics(ResourcePool pool) {
        this.id = pool.getResourceDescriptorID();
        this.typeId = pool.getComponentTypeID();
        this.stats = new HashMap();
    }

    public void addStatistic(PoolStatistic statistic) {
        this.stats.put(statistic.getName(), statistic);
    }

    public ResourceDescriptorID getResourceDescriptorID() {
        return this.id;
    }

    public ComponentTypeID getComponentTypeID() {
        return this.typeId;
    }

    public Collection getStatisticNames() {
        return this.stats.keySet();
    }

    public Map getStatistics() {
        HashMap<String, PoolStatistic> copy = new HashMap<String, PoolStatistic>(this.stats.size());
        Iterator it = this.stats.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            copy.put(name, this.getStatistic(name));
        }
        return copy;
    }

    public synchronized PoolStatistic getStatistic(String statName) {
        if (this.stats.containsKey(statName)) {
            PoolStatistic stat = (PoolStatistic)this.stats.get(statName);
            return stat;
        }
        return null;
    }

    public synchronized void increment(String statName) {
        if (this.stats.containsKey(statName)) {
            BasicPoolStatistic stat = (BasicPoolStatistic)this.stats.get(statName);
            stat.increment();
        }
    }

    public synchronized void increment(String statName, long value) {
        if (this.stats.containsKey(statName)) {
            BasicPoolStatistic stat = (BasicPoolStatistic)this.stats.get(statName);
            stat.increment(value);
        }
    }

    public synchronized void decrement(String statName) {
        if (this.stats.containsKey(statName)) {
            BasicPoolStatistic stat = (BasicPoolStatistic)this.stats.get(statName);
            stat.decrement();
        }
    }

    public synchronized void decrement(String statName, long value) {
        if (this.stats.containsKey(statName)) {
            BasicPoolStatistic stat = (BasicPoolStatistic)this.stats.get(statName);
            stat.decrement(value);
        }
    }

    public String toString() {
        Map s = this.getStatistics();
        StringBuffer result = new StringBuffer("\nPool: ");
        result.append(this.getResourceDescriptorID().getFullName());
        Iterator it = s.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            PoolStatistic ps = (PoolStatistic)s.get(name);
            result.append("\nStatistic: ");
            result.append(ps.getName());
            result.append("  value: ");
            result.append(ps.getValue().toString());
        }
        result.append("\n");
        return result.toString();
    }
}

